/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.rtrep.common.extension.AbstractExtensionBundle;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.ode.ODEConfigProperties;
import org.eclipse.smila.ode.ODEServer;
import org.eclipse.smila.ode.ODEServerContextFactory;
import org.eclipse.smila.ode.ODEServerException;
import org.eclipse.smila.ode.WebServiceContextFactory;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.bpel.BpelEngine;
import org.eclipse.smila.processing.bpel.activities.PipeletExtensionBundle;
import org.eclipse.smila.processing.bpel.internal.DeploymentManager;
import org.eclipse.smila.processing.bpel.util.ConfigurationHelper;
import org.w3c.dom.Element;

public class OdeBpelEngine
implements BpelEngine {
    private ODEServer _odeServer;
    private DeploymentManager _deploymentManager;
    private final Log _log = LogFactory.getLog(this.getClass());

    protected void activate() {
        try {
            Properties properties = ConfigurationHelper.readConfiguration();
            ODEConfigProperties odeConfig = new ODEConfigProperties(properties, "ode.");
            WebServiceContextFactory processingContext = new WebServiceContextFactory();
            this._odeServer = new ODEServer(odeConfig, (ODEServerContextFactory)processingContext);
            this._odeServer.registerExtensionBundle((AbstractExtensionBundle)new PipeletExtensionBundle());
            this._deploymentManager = new DeploymentManager();
        }
        catch (Exception ex) {
            this._log.error((Object)"Start of BPEL workflow service failed: Unknown fatal error. Service is non-functional, please fix problem and restart bundle", (Throwable)ex);
        }
    }

    protected void deactivate() {
        this._odeServer.shutdown();
    }

    @Override
    public Element invoke(String workflowName, Element message) throws ODEServerException {
        QName processId = this.getProcessId(workflowName);
        return this._odeServer.invoke(processId, "process", message);
    }

    @Override
    public boolean isPredefinedWorkflow(String workflowName) {
        return this._deploymentManager.isPredefinedWorkflow(workflowName);
    }

    @Override
    public boolean isCustomWorkflow(String workflowName) {
        return this._deploymentManager.isCustomWorkflow(workflowName);
    }

    @Override
    public AnyMap getWorkflow(String workflowName) throws IOException {
        AnyMap resultMap = DataFactory.DEFAULT.createAnyMap();
        QName processId = this.getProcessId(workflowName);
        String bpelContent = this._odeServer.getBpelDocument(processId);
        if (bpelContent != null) {
            Value bpel = DataFactory.DEFAULT.createStringValue(bpelContent);
            resultMap.put("name", workflowName);
            resultMap.put("readOnly", Boolean.valueOf(true));
            resultMap.put("definition", (Any)bpel);
            return resultMap;
        }
        return null;
    }

    @Override
    public File validateWorkflow(String workflowName, AnyMap workflowDefinition) throws ProcessingException {
        return this._deploymentManager.validateWorkflow(workflowName, workflowDefinition);
    }

    @Override
    public QName deployWorkflowDir(String workflowName, File deploymentDirectory) throws ProcessingException {
        return this._deploymentManager.deployWorkflowDir(workflowName, deploymentDirectory, this._odeServer);
    }

    @Override
    public void undeployWorkflow(String workflowName) throws ProcessingException {
        this._deploymentManager.undeployWorkflow(workflowName, this._odeServer);
    }

    @Override
    public void deployWorkflow(String workflowName, AnyMap workflowDefinition) throws ProcessingException {
        this._deploymentManager.deployWorkflow(workflowName, workflowDefinition, this._odeServer);
    }

    @Override
    public Collection<String> deployPredefinedWorkflows(String pipelineDirName) throws ProcessingException, IOException {
        Collection<QName> processNames = this._deploymentManager.deployPredefinedWorkflows(pipelineDirName, this._odeServer);
        ArrayList<String> workflowNames = new ArrayList<String>(processNames.size());
        for (QName processName : processNames) {
            workflowNames.add(processName.getLocalPart());
        }
        return workflowNames;
    }

    private QName getProcessId(String workflowName) {
        return new QName("http://www.eclipse.org/smila/processor", workflowName);
    }
}

