/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.common.definitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;

public final class ValueExpression {
    public static final String VARIABLE_REGEX = "\\$\\{([^\\$\\{\\s]+?)\\}";
    private static final String VARIABLE_START = "${";
    private static final String VARIABLE_END = "}";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([^\\$\\{\\s]+?)\\}");
    private final String _expression;
    private final List<String> _variables = new ArrayList<String>();

    public ValueExpression(String expression) {
        this._expression = expression;
        this.findVariables();
    }

    public ValueExpression evaluate(Map<String, String> context) {
        String intermediate = this._expression;
        boolean intermediateChanged = true;
        while (intermediateChanged && ValueExpression.referencesVariables(intermediate)) {
            String oldIntermediate = intermediate;
            for (Map.Entry<String, String> entry : context.entrySet()) {
                intermediate = this.solveVariableReference(intermediate, entry.getKey(), entry.getValue());
            }
            boolean bl = intermediateChanged = !oldIntermediate.equals(intermediate);
        }
        return new ValueExpression(intermediate);
    }

    public ValueExpression evaluate(AnyMap context) {
        String intermediate = this._expression;
        boolean intermediateChanged = true;
        while (intermediateChanged && ValueExpression.referencesVariables(intermediate)) {
            String oldIntermediate = intermediate;
            for (Map.Entry entry : context.entrySet()) {
                if (!((Any)entry.getValue()).isValue()) continue;
                intermediate = this.solveVariableReference(intermediate, (String)entry.getKey(), ((Any)entry.getValue()).asValue().asString());
            }
            boolean bl = intermediateChanged = !oldIntermediate.equals(intermediate);
        }
        return new ValueExpression(intermediate);
    }

    public ValueExpression evaluateExpr(Map<String, ValueExpression> context) {
        String intermediate = this._expression;
        boolean intermediateChanged = true;
        while (intermediateChanged && ValueExpression.referencesVariables(intermediate)) {
            String oldIntermediate = intermediate;
            for (Map.Entry<String, ValueExpression> entry : context.entrySet()) {
                intermediate = this.solveVariableReference(intermediate, entry.getKey(), entry.getValue().getExpression());
            }
            boolean bl = intermediateChanged = !oldIntermediate.equals(intermediate);
        }
        return new ValueExpression(intermediate);
    }

    private String solveVariableReference(String expression, String name, String value) {
        String variableExpression;
        StringBuilder stringBuilder = new StringBuilder(expression);
        if (name != null && !name.equals("") && !value.contains(variableExpression = VARIABLE_START + name + VARIABLE_END)) {
            int beginIndex = stringBuilder.indexOf(variableExpression);
            while (beginIndex >= 0) {
                stringBuilder = stringBuilder.replace(beginIndex, beginIndex + variableExpression.length(), value);
                beginIndex = stringBuilder.indexOf(variableExpression, beginIndex);
            }
        }
        return stringBuilder.toString();
    }

    public Map<String, String> extractValues(String evaluatedExpression) {
        String extractRegex = this._expression.replaceAll(VARIABLE_REGEX, "\\(.*\\)");
        extractRegex = extractRegex.replace("$", "\\$");
        extractRegex = extractRegex.replace("{", "\\{");
        extractRegex = extractRegex.replace(VARIABLE_END, "\\}");
        Matcher m = Pattern.compile(extractRegex).matcher(evaluatedExpression);
        HashMap<String, String> values = new HashMap<String, String>();
        if (m.find()) {
            int i = 1;
            for (String variable : this._variables) {
                values.put(variable, m.group(i++));
            }
        } else {
            throw new IllegalArgumentException("'" + evaluatedExpression + "' doesn't match expression '" + this._expression + "'");
        }
        return values;
    }

    public boolean referencesVariables() {
        return ValueExpression.referencesVariables(this._expression);
    }

    public Collection<String> getVariables() {
        return new HashSet<String>(this._variables);
    }

    public String getExpression() {
        return this._expression;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof ValueExpression) {
            return this._expression.equals(((ValueExpression)arg0).getExpression());
        }
        return false;
    }

    public int hashCode() {
        return this._expression.hashCode();
    }

    public String toString() {
        return this._expression;
    }

    private void findVariables() {
        if (this._expression != null) {
            Matcher m = VARIABLE_PATTERN.matcher(this._expression);
            while (m.find()) {
                this._variables.add(m.group(1));
            }
        }
    }

    private static boolean referencesVariables(String potentialExpression) {
        return VARIABLE_PATTERN.matcher(potentialExpression).find();
    }
}

