/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Peter Wissel (brox IT Solutions GmbH) - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.solr.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.NotImplementedException;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.client.solrj.response.LukeResponse.FieldInfo;
import org.apache.solr.common.util.NamedList;
import org.eclipse.smila.solr.server.SolrServers;
import org.eclipse.smila.solr.util.SolrHelper;

/**
 * The SolrHttpAdmin class.
 * 
 * @author pwissel
 * 
 */
public class SolrHttpAdmin extends SolrBaseAdmin {

  /**
   * Constructor.
   * 
   * @param helper
   *          the SolrHelper.
   */
  public SolrHttpAdmin(final SolrHelper helper, SolrServers servers) {
    super(helper, servers);
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.solr.SolrAdminBase#alias(java.lang.String, java.lang.String)
   */
  @Override
  public String alias(final String coreName, final String aliasName) {
    // TODO Auto-generated method stub
    throw new NotImplementedException();
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.solr.admin.SolrAdmin#create(java.lang.String, java.lang.String, java.lang.String)
   */
  @Override
  public String create(final String coreName, final String instanceDir, final String dataDir) {
    throw new NotImplementedException();
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.solr.admin.SolrAdmin#create(java.lang.String, java.lang.String)
   */
  @Override
  public String create(String srcCore, String targetCoreName) throws Exception {
    throw new UnsupportedOperationException();
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.solr.SolrAdminBase#merge(java.lang.String, java.lang.String, java.lang.String)
   */
  @Override
  public String merge(final String coreName, final String indexPath1, final String indexPath2) {
    // TODO Auto-generated method stub
    throw new NotImplementedException();
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.solr.SolrAdminBase#reload(java.lang.String)
   */
  @Override
  public String reload(final String coreName) {
    // TODO Auto-generated method stub
    clearCoreCache(coreName);
    throw new NotImplementedException();
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.solr.SolrAdminBase#rename(java.lang.String, java.lang.String)
   */
  @Override
  public String rename(final String coreName, final String newName) {
    // TODO Auto-generated method stub
    clearCoreCache(coreName);
    throw new NotImplementedException();
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.solr.SolrAdminBase#status(java.lang.String)
   */
  @Override
  public String status(final String coreName) {
    // TODO Auto-generated method stub
    throw new NotImplementedException();
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.solr.SolrAdminBase#unload(java.lang.String)
   */
  @Override
  public String unload(final String coreName) {
    // TODO Auto-generated method stub
    clearCoreCache(coreName);
    throw new NotImplementedException();
  }

  @Override
  public List<String> getCoreNames() throws Exception {
    final List<String> coreNames = new ArrayList<String>();
    final SolrServer adminServer = getServers().getAdminServer();
    final CoreAdminResponse status = CoreAdminRequest.getStatus(null, adminServer);
    final NamedList<Object> response = status.getResponse();
    if (response != null) {
      @SuppressWarnings("unchecked")
      final NamedList<Object> cores = (NamedList<Object>) response.get("status");
      if (cores != null) {
        for (Map.Entry<String, Object> entry : cores) {
          coreNames.add(entry.getKey());
        }
      }
    }
    return coreNames;
  }

  @Override
  protected List<String> readFieldNames(String coreName) throws SolrServerException, IOException {
    final SolrServer server = getServers().getSolrServer(coreName);
    final LukeRequest request = new LukeRequest();
    request.setShowSchema(true);
    request.setNumTerms(0);
    final LukeResponse response = request.process(server);
    final Map<String, FieldInfo> fields = response.getFieldInfo();
    return new ArrayList<String>(fields.keySet());
  }

}
