/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.common.exceptions;

/**
 * Thrown on definition parsing and validation errors.
 */
public class InvalidDefinitionException extends Exception {

  /**
   * exceptions are serializable.
   */
  private static final long serialVersionUID = 1L;

  /**
   * create exception.
   * 
   * @param message
   *          details
   * @param cause
   *          reason
   */
  public InvalidDefinitionException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /**
   * create exception.
   * 
   * @param message
   *          details
   */
  public InvalidDefinitionException(final String message) {
    super(message);
  }

}
