/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.httphandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.jobmanager.definitions.DataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;

/**
 * Implements the handling of HTTP requests to request the data object types list. <br>
 * 
 * URL pattern: <code>smila/jobmanager/dataobjecttypes/</code> <br>
 * 
 * Methods allowed: <code>GET</code>
 */
public class DataObjectTypesHandler extends AJobManagerHandler {

  /**
   * {@inheritDoc}
   */
  @Override
  public Object process(final String method, final String requestUri, final Record inputRecord) throws Exception {
    final DefinitionPersistence defPersistence = getDefinitionPersistence();
    final Map<String, Object> resultMap = new HashMap<String, Object>();
    final List<Map<String, Object>> dotList = new ArrayList<Map<String, Object>>();
    for (final String dataObjectTypeName : defPersistence.getDataObjectTypes()) {
      final LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
      map.put("name", dataObjectTypeName);
      map.put("url", URLCreator.create(getRequestHost(), requestUri, dataObjectTypeName));
      dotList.add(map);
    }
    resultMap.put(DataObjectTypeDefinition.KEY_DATA_OBJECT_TYPE_DEFINITIONS, dotList);
    return resultMap;
  }

 

}
