/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.taskgenerator;

import java.util.List;

import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition.Input;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskworker.input.InputMode;

/** Helper class used for task generation issues. */
public abstract class TaskGenerationUtil {

  /**
   * set task properties needed by JobManager for task-to-workflow association, and set qualifier, if the given worker
   * requires one.
   * 
   * @param tasks
   *          new tasks
   * @param workflowRunId
   *          id of workflow run in which these task was created.
   * @param worker
   *          the worker for which this task was created
   */
  public static void setAdditionalTaskProperties(final List<Task> tasks, final String jobName,
    final String jobRunId, final String workflowRunId, final WorkerDefinition worker) {
    String qualifierSlot = null;
    for (final Input input : worker.getInput()) {
      if (input.getModes().contains(InputMode.QUALIFIER)) {
        qualifierSlot = input.getName();
      }
    }
    for (final Task task : tasks) {
      task.getProperties().put(Task.PROPERTY_WORKFLOW_RUN_ID, workflowRunId);
      task.getProperties().put(Task.PROPERTY_JOB_RUN_ID, jobRunId);
      task.getProperties().put(Task.PROPERTY_JOB_NAME, jobName);
      if (qualifierSlot != null) {
        final List<BulkInfo> inputBulks = task.getInputBulks().get(qualifierSlot);
        if (inputBulks != null && !inputBulks.isEmpty()) {
          final BulkInfo firstBulk = inputBulks.get(0);
          task.setQualifier(firstBulk.getObjectName());
        }
      }
    }
  }

}
