/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.binarystorage.persistence.efs;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.config.BinaryStorageConfiguration;
import org.eclipse.smila.binarystorage.persistence.BinaryPersistence;
import org.eclipse.smila.binarystorage.persistence.efs.EFSUtils;

public class EFSBinaryPersistence
extends BinaryPersistence {
    private final Log _log = LogFactory.getLog(EFSBinaryPersistence.class);

    public EFSBinaryPersistence(BinaryStorageConfiguration binaryStorageConfig) throws BinaryStorageException {
        EFSUtils.init(binaryStorageConfig);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Initializing fyle system manager for binary storage.");
        }
    }

    public void storeBinary(String key, byte[] content) throws BinaryStorageException {
        EFSUtils.writeByteArrayToFile(key, content);
    }

    public void storeBinary(String key, InputStream stream) throws BinaryStorageException {
        EFSUtils.writeInputStreamToFile(key, stream);
    }

    public void deleteBinary(String key) throws BinaryStorageException {
        EFSUtils.deleteFile(key);
    }

    public long fetchSize(String key) throws BinaryStorageException {
        return EFSUtils.fetchSize(key);
    }

    public byte[] loadBinaryAsByteArray(String key) throws BinaryStorageException {
        return EFSUtils.readFileToByteArray(key);
    }

    public InputStream loadBinaryAsInputStream(String key) throws BinaryStorageException {
        return EFSUtils.readFileToInputStream(key);
    }

    public void cleanup() throws BinaryStorageException {
    }
}

