/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.binarystorage.persistence.efs;

import java.io.File;
import java.io.InputStream;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.config.BinaryStorageConfiguration;
import org.eclipse.smila.binarystorage.persistence.efs.EFSBinaryPersistence;

public class EFSHierarchicalManager
extends EFSBinaryPersistence {
    private int _pathDepth = 2;
    private final byte _length = (byte)2;
    private static final String _separator = File.separator;

    public EFSHierarchicalManager(BinaryStorageConfiguration binaryStorageConfig) throws BinaryStorageException {
        super(binaryStorageConfig);
        int pathDepthInt;
        Integer pathDepth = binaryStorageConfig.getPathDepth();
        if (pathDepth != null && (pathDepthInt = pathDepth.intValue()) > 0) {
            this._pathDepth = pathDepthInt;
        }
    }

    @Override
    public void storeBinary(String key, byte[] content) throws BinaryStorageException {
        super.storeBinary(this.calculateDirectoryPath(key), content);
    }

    @Override
    public void storeBinary(String key, InputStream stream) throws BinaryStorageException {
        super.storeBinary(this.calculateDirectoryPath(key), stream);
    }

    @Override
    public byte[] loadBinaryAsByteArray(String key) throws BinaryStorageException {
        return super.loadBinaryAsByteArray(this.calculateDirectoryPath(key));
    }

    @Override
    public InputStream loadBinaryAsInputStream(String key) throws BinaryStorageException {
        return super.loadBinaryAsInputStream(this.calculateDirectoryPath(key));
    }

    @Override
    public void deleteBinary(String key) throws BinaryStorageException {
        super.deleteBinary(this.calculateDirectoryPath(key));
    }

    @Override
    public long fetchSize(String key) throws BinaryStorageException {
        return super.fetchSize(this.calculateDirectoryPath(key));
    }

    private String calculateDirectoryPath(String id) {
        StringBuffer internalPath = new StringBuffer();
        int i = 0;
        while (i < this._pathDepth) {
            internalPath.append(id.substring(i * 2, i * 2 + 2));
            internalPath.append(_separator);
            ++i;
        }
        internalPath.append(id);
        return internalPath.toString();
    }
}

