/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.http;

import java.util.HashMap;
import java.util.Map;

public class HttpStatus {
    public static final int SUCCESS = 1;
    public static final int FAILED = 2;
    public static final int PROTO_NOT_FOUND = 10;
    public static final int GONE = 11;
    public static final int MOVED = 12;
    public static final int TEMP_MOVED = 13;
    public static final int NOTFOUND = 14;
    public static final int RETRY = 15;
    public static final int EXCEPTION = 16;
    public static final int ACCESS_DENIED = 17;
    public static final int ROBOTS_DENIED = 18;
    public static final int REDIR_EXCEEDED = 19;
    public static final int NOTFETCHING = 20;
    public static final int NOTMODIFIED = 21;
    public static final int WOULDBLOCK = 22;
    public static final int BLOCKED = 23;
    public static final HttpStatus STATUS_SUCCESS = new HttpStatus(1);
    public static final HttpStatus STATUS_FAILED = new HttpStatus(2);
    public static final HttpStatus STATUS_GONE = new HttpStatus(11);
    public static final HttpStatus STATUS_NOTFOUND = new HttpStatus(14);
    public static final HttpStatus STATUS_RETRY = new HttpStatus(15);
    public static final HttpStatus STATUS_ROBOTS_DENIED = new HttpStatus(18);
    public static final HttpStatus STATUS_REDIR_EXCEEDED = new HttpStatus(19);
    public static final HttpStatus STATUS_NOTFETCHING = new HttpStatus(20);
    public static final HttpStatus STATUS_NOTMODIFIED = new HttpStatus(21);
    public static final HttpStatus STATUS_WOULDBLOCK = new HttpStatus(22);
    public static final HttpStatus STATUS_BLOCKED = new HttpStatus(23);
    private static Map<Integer, String> s_codeToName = new HashMap<Integer, String>();
    private int _code;
    private String _message;

    static {
        s_codeToName.put(1, "success");
        s_codeToName.put(2, "failed");
        s_codeToName.put(10, "proto_not_found");
        s_codeToName.put(11, "gone");
        s_codeToName.put(12, "moved");
        s_codeToName.put(13, "temp_moved");
        s_codeToName.put(14, "notfound");
        s_codeToName.put(15, "retry");
        s_codeToName.put(16, "exception");
        s_codeToName.put(17, "access_denied");
        s_codeToName.put(18, "robots_denied");
        s_codeToName.put(19, "redir_exceeded");
        s_codeToName.put(20, "notfetching");
        s_codeToName.put(21, "notmodified");
        s_codeToName.put(22, "wouldblock");
        s_codeToName.put(23, "blocked");
    }

    public HttpStatus() {
    }

    public HttpStatus(int code, String message) {
        this._code = code;
        this._message = message;
    }

    public HttpStatus(int code) {
        this(code, null);
    }

    public HttpStatus(int code, Object message) {
        this._code = code;
        if (message != null) {
            this._message = String.valueOf(message);
        }
    }

    public HttpStatus(Throwable throwable) {
        this(16, throwable);
    }

    public int getCode() {
        return this._code;
    }

    public void setCode(int code) {
        this._code = code;
    }

    public boolean isSuccess() {
        return this._code == 1;
    }

    public boolean isTransientFailure() {
        return this._code == 17 || this._code == 16 || this._code == 19 || this._code == 15 || this._code == 13 || this._code == 22 || this._code == 10;
    }

    public boolean isPermanentFailure() {
        return this._code == 2 || this._code == 11 || this._code == 12 || this._code == 14 || this._code == 18;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof HttpStatus)) {
            return false;
        }
        HttpStatus other = (HttpStatus)o;
        if (this._code != other._code) {
            return false;
        }
        if (this._message == null) {
            return other._message == null;
        }
        return other._message != null;
    }

    public int hashCode() {
        return this._code;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append(String.valueOf(s_codeToName.get(new Integer(this._code))) + "(" + this._code + ")");
        if (this._message != null) {
            res.append(": " + String.valueOf(this._message));
        }
        return res.toString();
    }
}

