/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.parse;

import org.eclipse.smila.connectivity.framework.crawler.web.configuration.Configuration;
import org.eclipse.smila.connectivity.framework.crawler.web.metadata.Metadata;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.Outlink;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.Parse;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.ParseData;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.html.HTMLMetaTags;

public class ParseStatus {
    public static final byte NOTPARSED = 0;
    public static final byte SUCCESS = 1;
    public static final byte FAILED = 2;
    public static final String[] MAJOR_CODES = new String[]{"notparsed", "success", "failed"};
    public static final short SUCCESS_REDIRECT = 100;
    public static final short FAILED_EXCEPTION = 200;
    public static final short FAILED_TRUNCATED = 202;
    public static final short FAILED_INVALID_FORMAT = 203;
    public static final short FAILED_MISSING_PARTS = 204;
    public static final short FAILED_MISSING_CONTENT = 205;
    public static final ParseStatus STATUS_NOTPARSED = new ParseStatus(0);
    public static final ParseStatus STATUS_SUCCESS = new ParseStatus(1);
    public static final ParseStatus STATUS_FAILURE = new ParseStatus(2);
    private byte _majorCode;
    private short _minorCode;
    private String _message;

    public ParseStatus() {
    }

    public ParseStatus(int majorCode, int minorCode, String message) {
        this._message = message;
        this._majorCode = (byte)majorCode;
        this._minorCode = (short)minorCode;
    }

    public ParseStatus(int majorCode) {
        this(majorCode, 0, null);
    }

    public ParseStatus(int majorCode, String message) {
        this(majorCode, 0, message);
    }

    public ParseStatus(int majorCode, int minorCode) {
        this(majorCode, minorCode, null);
    }

    public ParseStatus(Throwable throwable) {
        this(2, 200, throwable.toString());
    }

    public boolean isSuccess() {
        return this._majorCode == 1;
    }

    public String getMessage() {
        return this._message;
    }

    public int getMajorCode() {
        return this._majorCode;
    }

    public int getMinorCode() {
        return this._minorCode;
    }

    public Parse getEmptyParse(Configuration conf) {
        return new EmptyParseImpl(this, conf);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        String name = null;
        name = this._majorCode >= 0 && this._majorCode < MAJOR_CODES.length ? MAJOR_CODES[this._majorCode] : "UNKNOWN!";
        res.append(String.valueOf(name) + "(" + this._majorCode + "," + this._minorCode + ")");
        if (this._message != null) {
            res.append("message=" + this._message);
        }
        return res.toString();
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setMajorCode(byte majorCode) {
        this._majorCode = majorCode;
    }

    public void setMinorCode(short minorCode) {
        this._minorCode = minorCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ParseStatus)) {
            return false;
        }
        boolean res = true;
        ParseStatus other = (ParseStatus)o;
        boolean bl = res = res && this._majorCode == other._majorCode && this._minorCode == other._minorCode;
        if (!res) {
            return res;
        }
        if (this._message == null) {
            return other._message == null;
        }
        if (other._message == null) {
            return false;
        }
        return other._message.equals(this._message);
    }

    public int hashCode() {
        return this._majorCode;
    }

    private static class EmptyParseImpl
    implements Parse {
        private final ParseData _data;

        public EmptyParseImpl(ParseStatus status, Configuration conf) {
            this._data = new ParseData(status, "", new Outlink[0], new Metadata(), new Metadata(), new HTMLMetaTags());
            this._data.setConf(conf);
        }

        @Override
        public ParseData getData() {
            return this._data;
        }

        @Override
        public String getText() {
            return "";
        }
    }
}

