/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.parse.html;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class HTMLMetaTags {
    private static final String COLON = ":";
    private boolean _noIndex;
    private boolean _noFollow;
    private boolean _noCache;
    private URL _baseHref;
    private boolean _refresh;
    private int _refreshTime;
    private URL _refreshHref;
    private final Properties _generalTags = new Properties();
    private final Properties _httpEquivTags = new Properties();

    public void reset() {
        this._noIndex = false;
        this._noFollow = false;
        this._noCache = false;
        this._refresh = false;
        this._refreshTime = 0;
        this._baseHref = null;
        this._refreshHref = null;
        this._generalTags.clear();
        this._httpEquivTags.clear();
    }

    public void setNoFollow() {
        this._noFollow = true;
    }

    public void setNoIndex() {
        this._noIndex = true;
    }

    public void setNoCache() {
        this._noCache = true;
    }

    public void setRefresh(boolean refresh) {
        this._refresh = refresh;
    }

    public void setBaseHref(URL baseHref) {
        this._baseHref = baseHref;
    }

    public void setRefreshHref(URL refreshHref) {
        this._refreshHref = refreshHref;
    }

    public void setRefreshTime(int refreshTime) {
        this._refreshTime = refreshTime;
    }

    public boolean getNoIndex() {
        return this._noIndex;
    }

    public boolean getNoFollow() {
        return this._noFollow;
    }

    public boolean getNoCache() {
        return this._noCache;
    }

    public boolean getRefresh() {
        return this._refresh;
    }

    public URL getBaseHref() {
        return this._baseHref;
    }

    public URL getRefreshHref() {
        return this._refreshHref;
    }

    public int getRefreshTime() {
        return this._refreshTime;
    }

    public Properties getGeneralTags() {
        return this._generalTags;
    }

    public Properties getHttpEquivTags() {
        return this._httpEquivTags;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("base=" + this._baseHref + ", noCache=" + this._noCache + ", noFollow=" + this._noFollow + ", noIndex=" + this._noIndex + ", refresh=" + this._refresh + ", refreshHref=" + this._refreshHref + "\n");
        sb.append(" * general tags:\n");
        for (String string : this._generalTags.keySet()) {
            sb.append("   - " + string + "\t=\t" + this._generalTags.get(string) + "\n");
        }
        sb.append(" * http-equiv tags:\n");
        for (String string : this._httpEquivTags.keySet()) {
            sb.append("   - " + string + "\t=\t" + this._httpEquivTags.get(string) + "\n");
        }
        return sb.toString();
    }

    public List<String> toArrayList() {
        ArrayList<String> htmlMetaTagsArray = new ArrayList<String>();
        htmlMetaTagsArray.add("base:" + this._baseHref);
        htmlMetaTagsArray.add("noCache:" + this._noCache);
        htmlMetaTagsArray.add("noFollow:" + this._noFollow);
        htmlMetaTagsArray.add("noIndex:" + this._noIndex);
        htmlMetaTagsArray.add("refresh:" + this._refresh);
        htmlMetaTagsArray.add("refreshHref:" + this._refreshHref);
        for (String string : this._generalTags.keySet()) {
            htmlMetaTagsArray.add(String.valueOf(string) + COLON + this._generalTags.get(string));
        }
        for (String string : this._httpEquivTags.keySet()) {
            htmlMetaTagsArray.add(String.valueOf(string) + COLON + this._httpEquivTags.get(string));
        }
        return htmlMetaTagsArray;
    }
}

