/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.rapi.ActivityModel;
import org.apache.ode.bpel.rapi.ConstantsModel;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.bpel.rapi.PropertyAliasModel;
import org.apache.ode.bpel.rtrep.v1.OBase;
import org.apache.ode.bpel.rtrep.v1.OConstants;
import org.apache.ode.bpel.rtrep.v1.OElementVarType;
import org.apache.ode.bpel.rtrep.v1.OExpression;
import org.apache.ode.bpel.rtrep.v1.OExpressionLanguage;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.OPartnerLink;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OVarType;
import org.apache.ode.bpel.rtrep.v1.OXsdTypeVarType;
import org.apache.ode.bpel.rtrep.v1.OXslSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OProcess
extends OBase
implements ProcessModel {
    public static int instanceCount = 0;
    static final long serialVersionUID = -1L;
    public String guid;
    public final String version;
    public OConstants constants;
    public String uuid;
    public String targetNamespace;
    public String processName;
    public OScope procesScope;
    public final Set<OPartnerLink> allPartnerLinks = new HashSet<OPartnerLink>();
    public final List<OProperty> properties = new ArrayList<OProperty>();
    public Date compileDate;
    int _childIdCounter = 0;
    List<OBase> _children = new ArrayList<OBase>();
    public final HashSet<OExpressionLanguage> expressionLanguages = new HashSet();
    public final HashMap<QName, OMessageVarType> messageTypes = new HashMap();
    public final HashMap<QName, OElementVarType> elementTypes = new HashMap();
    public final HashMap<QName, OXsdTypeVarType> xsdTypes = new HashMap();
    public final HashMap<URI, OXslSheet> xslSheets = new HashMap();

    public OProcess(String string) {
        super(null);
        this.version = string;
        ++instanceCount;
    }

    public ActivityModel getChild(int n) {
        for (int i = this._children.size() - 1; i >= 0; --i) {
            OBase oBase = this._children.get(i);
            if (oBase.getId() != n) continue;
            return oBase;
        }
        return null;
    }

    public List<OBase> getChildren() {
        return this._children;
    }

    public OScope getScope(String string) {
        throw new UnsupportedOperationException();
    }

    public Set<? extends PartnerLinkModel> getAllPartnerLinks() {
        return Collections.unmodifiableSet(this.allPartnerLinks);
    }

    public PartnerLinkModel getPartnerLink(String string) {
        for (OPartnerLink oPartnerLink : this.allPartnerLinks) {
            if (!oPartnerLink.getName().equals(string)) continue;
            return oPartnerLink;
        }
        return null;
    }

    public String getName() {
        return this.processName;
    }

    public Collection getExpressionLanguages() {
        throw new UnsupportedOperationException();
    }

    public List<String> getCorrelators() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet hashSet = new HashSet(this.getAllPartnerLinks());
        for (OPartnerLink oPartnerLink : hashSet) {
            if (!oPartnerLink.hasMyRole()) continue;
            for (Object e : oPartnerLink.myRolePortType.getOperations()) {
                Operation operation = (Operation)e;
                arrayList.add(oPartnerLink.getId() + "." + operation.getName());
            }
        }
        return arrayList;
    }

    public QName getQName() {
        return new QName(this.targetNamespace, this.processName);
    }

    protected void finalize() throws Throwable {
        --instanceCount;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ++instanceCount;
    }

    public PartnerLinkModel getPartnerLink(int n) {
        return (PartnerLinkModel)this.getChild(n);
    }

    public String getGuid() {
        return this.guid;
    }

    public int getModelVersion() {
        return 1;
    }

    public ConstantsModel getConstantsModel() {
        return new ConstantsModel(){

            public QName getConflictingReceive() {
                return OProcess.this.constants.qnConflictingReceive;
            }

            public QName getCorrelationViolation() {
                return OProcess.this.constants.qnCorrelationViolation;
            }

            public QName getDuplicateInstance() {
                return null;
            }

            public QName getForEachCounterError() {
                return OProcess.this.constants.qnForEachCounterError;
            }

            public QName getForcedTermination() {
                return OProcess.this.constants.qnForcedTermination;
            }

            public QName getInvalidBranchCondition() {
                return OProcess.this.constants.qnInvalidBranchCondition;
            }

            public QName getInvalidExpressionValue() {
                return OProcess.this.constants.qnInvalidExpressionValue;
            }

            public QName getJoinFailure() {
                return OProcess.this.constants.qnJoinFailure;
            }

            public QName getMismatchedAssignmentFailure() {
                return OProcess.this.constants.qnMismatchedAssignmentFailure;
            }

            public QName getMissingReply() {
                return OProcess.this.constants.qnMissingReply;
            }

            public QName getMissingRequest() {
                return OProcess.this.constants.qnMissingRequest;
            }

            public QName getRetiredProcess() {
                return null;
            }

            public QName getSelectionFailure() {
                return OProcess.this.constants.qnSelectionFailure;
            }

            public QName getSubLanguageExecutionFault() {
                return OProcess.this.constants.qnSubLanguageExecutionFault;
            }

            public QName getUninitializedPartnerRole() {
                return OProcess.this.constants.qnUninitializedPartnerRole;
            }

            public QName getUninitializedVariable() {
                return OProcess.this.constants.qnUninitializedVariable;
            }

            public QName getUnknownFault() {
                return null;
            }

            public QName getXsltInvalidSource() {
                return OProcess.this.constants.qnXsltInvalidSource;
            }
        };
    }

    public static class OPropertyAlias
    extends OBase
    implements PropertyAliasModel {
        static final long serialVersionUID = -1L;
        public OVarType varType;
        public OMessageVarType.Part part;
        public OExpression location;

        public OPropertyAlias(OProcess oProcess) {
            super(oProcess);
        }

        public String toString() {
            return "{OPropertyAlias " + this.getDescription() + "}";
        }

        public String getDescription() {
            StringBuffer stringBuffer = new StringBuffer(this.varType.toString());
            stringBuffer.append('[');
            stringBuffer.append(this.part != null ? this.part.name : "");
            if (this.location != null) {
                stringBuffer.append("][");
                stringBuffer.append(this.location.toString());
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }

    public static class OProperty
    extends OBase {
        static final long serialVersionUID = -1L;
        public final List<OPropertyAlias> aliases = new ArrayList<OPropertyAlias>();
        public QName name;

        public OProperty(OProcess oProcess) {
            super(oProcess);
        }

        public OPropertyAlias getAlias(OVarType oVarType) {
            for (OPropertyAlias oPropertyAlias : this.aliases) {
                if (!oPropertyAlias.varType.equals(oVarType)) continue;
                return oPropertyAlias;
            }
            return null;
        }

        public String toString() {
            return "{OProperty " + this.name + "}";
        }
    }
}

