/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ActivityDisabledEvent;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableReadEvent;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.EventContextImpl;
import org.apache.ode.bpel.rtrep.v2.ExprEvaluationContextImpl;
import org.apache.ode.bpel.rtrep.v2.LinkFrame;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OConstants;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.VariableInstance;
import org.apache.ode.jacob.IndexedObject;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ACTIVITY
extends BpelJacobRunnable
implements IndexedObject {
    private static final Log __log = LogFactory.getLog(ACTIVITY.class);
    protected ActivityInfo _self;
    protected boolean _permeable = true;
    protected LinkFrame _linkFrame;

    public ACTIVITY(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        assert (activityInfo != null);
        assert (scopeFrame != null);
        assert (linkFrame != null);
        this._self = activityInfo;
        this._scopeFrame = scopeFrame;
        this._linkFrame = linkFrame;
    }

    public Object getKey() {
        return new Key(this._self.o, this._self.aId);
    }

    protected void sendVariableReadEvent(VariableInstance variableInstance) {
        VariableReadEvent variableReadEvent = new VariableReadEvent();
        variableReadEvent.setVarName(variableInstance.declaration.name);
        this.sendEvent((ScopeEvent)variableReadEvent);
    }

    protected void sendEvent(ActivityEvent activityEvent) {
        activityEvent.setActivityName(this._self.o.name);
        activityEvent.setActivityType(this._self.o.getType());
        activityEvent.setActivityDeclarationId(this._self.o.getId());
        activityEvent.setActivityId(this._self.aId);
        if (activityEvent.getLineNo() == -1) {
            activityEvent.setLineNo(this.getLineNo());
        }
        this.sendEvent((ScopeEvent)activityEvent);
    }

    protected void sendEvent(ScopeEvent scopeEvent) {
        if (scopeEvent.getLineNo() == -1 && this._self.o.debugInfo != null) {
            scopeEvent.setLineNo(this._self.o.debugInfo.startLine);
        }
        this._scopeFrame.fillEventInfo(scopeEvent);
        this.fillEventContext(scopeEvent);
        this.getBpelRuntime().sendEvent(scopeEvent);
    }

    protected void fillEventContext(ScopeEvent scopeEvent) {
        EventContextImpl eventContextImpl = new EventContextImpl(this._scopeFrame.oscope, this._scopeFrame.scopeInstanceId, this.getBpelRuntime());
        scopeEvent.eventContext = eventContextImpl;
    }

    protected void dpe(Collection<OLink> collection) {
        for (OLink oLink : collection) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("DPE on link " + oLink.name));
            }
            this._linkFrame.resolve((OLink)oLink).channel.linkStatus(false);
        }
    }

    protected OConstants getConstants() {
        return this._self.o.getOwner().constants;
    }

    protected void dpe(OActivity oActivity) {
        this.dpe(oActivity.sourceLinks);
        this.dpe(oActivity.outgoingLinks);
        this.sendEvent((ActivityEvent)new ActivityDisabledEvent());
    }

    protected EvaluationContext getEvaluationContext() {
        return new ExprEvaluationContextImpl(this._scopeFrame, this.getBpelRuntime());
    }

    private int getLineNo() {
        if (this._self.o.debugInfo != null && this._self.o.debugInfo.startLine != -1) {
            return this._self.o.debugInfo.startLine;
        }
        return -1;
    }

    Node fetchVariableData(VariableInstance variableInstance, boolean bl) throws FaultException {
        return this.getBpelRuntime().fetchVariableData(variableInstance, this._scopeFrame, bl);
    }

    void commitChanges(VariableInstance variableInstance, Node node) throws ExternalVariableModuleException {
        this.getBpelRuntime().commitChanges(variableInstance, this._scopeFrame, node);
    }

    public static final class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final OActivity type;
        final long aid;

        public Key(OActivity oActivity, long l) {
            this.type = oActivity;
            this.aid = l;
        }

        public String toString() {
            return this.type + "::" + this.aid;
        }
    }
}

