/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2.xpath10;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.common.ConfigurationException;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.ExpressionLanguageRuntime;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.xpath10.BpelDocumentNavigator;
import org.apache.ode.bpel.rtrep.v2.xpath10.JaxenContexts;
import org.apache.ode.bpel.rtrep.v2.xpath10.JaxenNamespaceContextAdapter;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v2.xpath10.WrappedFaultException;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.xsd.Duration;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XPath10ExpressionRuntime
implements ExpressionLanguageRuntime {
    private static final Log __log = LogFactory.getLog(XPath10ExpressionRuntime.class);
    private final Map<String, XPath> _compiledExpressions = new HashMap<String, XPath>();
    private final Map _extensionFunctions = new HashMap();

    public void initialize(Map map) throws ConfigurationException {
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)transformerFactoryImpl);
    }

    public String evaluateAsString(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        try {
            return this.compile((OXPath10Expression)oExpression).stringValueOf((Object)this.createContext((OXPath10Expression)oExpression, evaluationContext));
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(oExpression, jaxenException);
            throw new AssertionError((Object)"UNREACHABLE");
        }
    }

    public boolean evaluateAsBoolean(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        try {
            return this.compile((OXPath10Expression)oExpression).booleanValueOf((Object)this.createContext((OXPath10Expression)oExpression, evaluationContext));
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(oExpression, jaxenException);
            throw new AssertionError((Object)"UNREACHABLE");
        }
    }

    public Number evaluateAsNumber(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        try {
            return this.compile((OXPath10Expression)oExpression).numberValueOf((Object)this.createContext((OXPath10Expression)oExpression, evaluationContext));
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(oExpression, jaxenException);
            throw new AssertionError((Object)"UNREACHABLE");
        }
    }

    public List evaluate(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        try {
            XPath xPath = this.compile((OXPath10Expression)oExpression);
            Context context = this.createContext((OXPath10Expression)oExpression, evaluationContext);
            List<Text> list = xPath.selectNodes((Object)context);
            if (list.size() == 1 && !(list.get(0) instanceof Node)) {
                Document document = DOMUtils.newDocument();
                Element element = document.createElement("wrapper");
                Text text = document.createTextNode(list.get(0).toString());
                element.appendChild(text);
                document.appendChild(element);
                list = Collections.singletonList(text);
            }
            return list;
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(oExpression, jaxenException);
            throw new AssertionError((Object)"UNREACHABLE");
        }
    }

    public Node evaluateNode(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        List list = this.evaluate(oExpression, evaluationContext);
        if (list.size() == 0) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "No results for expression: " + oExpression);
        }
        if (list.size() > 1) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + oExpression);
        }
        return (Node)list.get(0);
    }

    public Calendar evaluateAsDate(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        String string = this.evaluateAsString(oExpression, evaluationContext);
        try {
            return ISO8601DateParser.parseCal((String)string);
        }
        catch (Exception exception) {
            String string2 = "Invalid date: " + string;
            __log.error((Object)string2, (Throwable)exception);
            throw new FaultException(oExpression.getOwner().constants.qnInvalidExpressionValue, string2);
        }
    }

    public Duration evaluateAsDuration(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        String string = this.evaluateAsString(oExpression, evaluationContext);
        try {
            Duration duration = new Duration(string);
            return duration;
        }
        catch (Exception exception) {
            String string2 = "Invalid duration: " + string;
            __log.error((Object)string2, (Throwable)exception);
            throw new FaultException(oExpression.getOwner().constants.qnInvalidExpressionValue, string2);
        }
    }

    private Context createContext(OXPath10Expression oXPath10Expression, EvaluationContext evaluationContext) {
        JaxenContexts jaxenContexts = new JaxenContexts(oXPath10Expression, this._extensionFunctions, evaluationContext);
        ContextSupport contextSupport = new ContextSupport((NamespaceContext)new JaxenNamespaceContextAdapter((javax.xml.namespace.NamespaceContext)oXPath10Expression.namespaceCtx), (FunctionContext)jaxenContexts, (VariableContext)jaxenContexts, (Navigator)new BpelDocumentNavigator(evaluationContext.getRootNode()));
        Context context = new Context(contextSupport);
        if (evaluationContext.getRootNode() != null) {
            context.setNodeSet(Collections.singletonList(evaluationContext.getRootNode()));
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPath compile(OXPath10Expression oXPath10Expression) throws JaxenException {
        XPath xPath = this._compiledExpressions.get(oXPath10Expression.xpath);
        if (xPath == null) {
            xPath = new DOMXPath(oXPath10Expression.xpath);
            Map<String, XPath> map = this._compiledExpressions;
            synchronized (map) {
                this._compiledExpressions.put(oXPath10Expression.xpath, xPath);
            }
        }
        return xPath;
    }

    private void handleJaxenException(OExpression oExpression, JaxenException jaxenException) throws FaultException {
        if (jaxenException instanceof WrappedFaultException) {
            throw ((WrappedFaultException)((Object)jaxenException)).getFaultException();
        }
        if (jaxenException.getCause() instanceof WrappedFaultException) {
            throw ((WrappedFaultException)((Object)jaxenException.getCause())).getFaultException();
        }
        throw new FaultException(oExpression.getOwner().constants.qnSubLanguageExecutionFault, jaxenException.getMessage(), (Throwable)jaxenException);
    }
}

