/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.ConnectivityManager;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingException;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingManager;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingSessionException;
import org.eclipse.smila.connectivity.framework.CrawlState;
import org.eclipse.smila.connectivity.framework.Crawler;
import org.eclipse.smila.connectivity.framework.CrawlerCriticalException;
import org.eclipse.smila.connectivity.framework.CrawlerException;
import org.eclipse.smila.connectivity.framework.DataReference;
import org.eclipse.smila.connectivity.framework.State;
import org.eclipse.smila.connectivity.framework.compound.CompoundException;
import org.eclipse.smila.connectivity.framework.compound.CompoundManager;
import org.eclipse.smila.connectivity.framework.impl.ImportRunIdHelper;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgent;
import org.eclipse.smila.connectivity.framework.performancecounters.CrawlerControllerPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.performancecounters.CrawlerPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.CrawlThreadState;
import org.eclipse.smila.connectivity.framework.util.CrawlerControllerCallback;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;

public class CrawlThread
extends Thread {
    private static final int MAX_NON_CRITICAL_ATTEMPTS_TO_GET_INDEX = 1000;
    private final Log _log = LogFactory.getLog(CrawlThread.class);
    private final CrawlerControllerCallback _controllerCallback;
    private final CrawlState _crawlState;
    private final ConnectivityManager _connectivityManager;
    private final DeltaIndexingManager _diManager;
    private final CompoundManager _compoundManager;
    private final Crawler _crawler;
    private final DataSourceConnectionConfig _configuration;
    private boolean _stopped;
    private CrawlerControllerPerformanceCounterHelper _performanceCounterHelper;
    private CrawlerPerformanceCounterHelper<? extends ConnectivityPerformanceAgent> _crawlerCounterHelper;
    private String _sessionId;
    private final ArrayList<Record> _recordBuffer = new ArrayList();
    private long _lastFlush;
    private final String _jobName;

    public CrawlThread(CrawlerControllerCallback controllerCallback, CrawlState crawlState, ConnectivityManager connectivityManager, DeltaIndexingManager diManager, CompoundManager compoundManager, Crawler crawler, DataSourceConnectionConfig configuration, String jobName) throws DeltaIndexingException, CrawlerCriticalException {
        DeltaIndexingManager.LockState state;
        this.checkMandatoryParameterParameter(controllerCallback, "controllerCallback");
        this.checkMandatoryParameterParameter(crawlState, "crawlState");
        this.checkMandatoryParameterParameter(connectivityManager, "connectivityManager");
        this.checkMandatoryParameterParameter(compoundManager, "compoundManager");
        this.checkMandatoryParameterParameter(crawler, "crawler");
        if (controllerCallback.doDeltaIndexing(configuration.getDeltaIndexing()) && (state = (DeltaIndexingManager.LockState)diManager.getLockStates().get(configuration.getDataSourceID())) != null && state == DeltaIndexingManager.LockState.LOCKED) {
            throw new DeltaIndexingException("data source " + configuration.getDataSourceID() + " is already locked by another session");
        }
        if (this._log.isTraceEnabled()) {
            String msg = "Creating CrawlThread for dataSourceId " + configuration.getDataSourceID();
            this._log.trace((Object)msg);
        }
        this._controllerCallback = controllerCallback;
        this._crawlState = crawlState;
        this._connectivityManager = connectivityManager;
        this._diManager = diManager;
        this._compoundManager = compoundManager;
        this._crawler = crawler;
        this._configuration = configuration;
        this._jobName = jobName;
        this.initializeRun();
    }

    private void checkMandatoryParameterParameter(Object parameter, String parameterName) {
        if (parameter == null) {
            String msg = "Parameter " + parameterName + " is null";
            this._log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public void run() {
        block14: {
            try {
                try {
                    if (this._controllerCallback.doDeltaIndexing(this._configuration.getDeltaIndexing())) {
                        this._sessionId = this._diManager.init(this._configuration.getDataSourceID());
                    }
                    this.getPerformanceCounterHelper().setStartDate(new Date(this._crawlState.getStartTime()));
                    this._lastFlush = System.currentTimeMillis();
                    DataReference[] dataReferences = null;
                    do {
                        dataReferences = null;
                        int i = 0;
                        i = 0;
                        while (i < 1000) {
                            try {
                                dataReferences = this._crawler.getNext();
                                break;
                            }
                            catch (CrawlerException e) {
                                this.getPerformanceCounterHelper().addException((Throwable)e);
                                this._log.warn((Object)"Non critical exception during crawler getNext() call", (Throwable)e);
                                ++i;
                            }
                        }
                        if (dataReferences != null) {
                            this.processDataReferences(dataReferences);
                            continue;
                        }
                        if (i < 999) continue;
                        this._log.error((Object)"Maximum noncritical errors reached");
                    } while (!this._stopped && dataReferences != null);
                    if (!this._stopped) {
                        this.flushRecords();
                        if (this._crawlState.getLastError() == null) {
                            this.deleteDelta(this._configuration.getDataSourceID());
                        }
                        this._crawlState.setState(CrawlThreadState.Finished);
                    } else {
                        this._crawlState.setState(CrawlThreadState.Stopped);
                    }
                }
                catch (Throwable e) {
                    this.getPerformanceCounterHelper().addCriticalException(e);
                    this._log.error((Object)"Fatal error, aborting", e);
                    this._crawlState.setLastError(e);
                    this._crawlState.setState(CrawlThreadState.Aborted);
                    this.cleanupRun();
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.cleanupRun();
                throw throwable;
            }
            this.cleanupRun();
        }
        this._log.info((Object)("Crawling thread " + this._configuration.getDataSourceID() + " stopped."));
    }

    protected void cleanupRun() {
        String msg;
        try {
            this._crawler.close();
        }
        catch (CrawlerException e) {
            this.getPerformanceCounterHelper().addException((Throwable)e);
            msg = "Error while closing Crawler after crawling dataSourceId " + this._configuration.getDataSourceID();
            this._log.error((Object)msg, (Throwable)e);
        }
        if (this._controllerCallback.doDeltaIndexing(this._configuration.getDeltaIndexing())) {
            this._log.info((Object)("Removing deltaindexing lock on datasource " + this._configuration.getDataSourceID()));
            try {
                this._diManager.finish(this._sessionId);
                this._log.info((Object)("Finished session " + this._sessionId + " and removed Deltaindexing lock on datasource " + this._configuration.getDataSourceID()));
            }
            catch (Exception e) {
                this.getPerformanceCounterHelper().addCriticalException((Throwable)e);
                msg = "Error while finishing DeltaIndexing after crawling dataSourceId " + this._configuration.getDataSourceID();
                this._log.error((Object)msg, (Throwable)e);
            }
        }
        this._log.info((Object)("Unregistering crawling thread " + this._configuration.getDataSourceID()));
        try {
            this._controllerCallback.unregister(this._configuration.getDataSourceID());
            this._log.info((Object)("Crawling thread " + this._configuration.getDataSourceID() + " unregistered"));
        }
        catch (Exception e) {
            this.getPerformanceCounterHelper().addException((Throwable)e);
            msg = "Error while unregistering CrawlThread after crawling dataSourceId " + this._configuration.getDataSourceID();
            this._log.error((Object)msg, (Throwable)e);
        }
        try {
            this._crawlState.setEndTime(Long.valueOf(System.currentTimeMillis()));
            this.getPerformanceCounterHelper().setEndDate(new Date(this._crawlState.getEndTime()));
        }
        catch (Exception e) {
            this.getPerformanceCounterHelper().addException((Throwable)e);
            msg = "Error while settingend end time in CrawlState after crawling dataSourceId " + this._configuration.getDataSourceID();
            this._log.error((Object)msg, (Throwable)e);
        }
    }

    protected void initializeRun() throws DeltaIndexingException, CrawlerCriticalException {
        try {
            this._crawler.initialize(this._configuration);
            this._crawlerCounterHelper = this._crawler.getCounterHelper();
            this.getPerformanceCounterHelper().setImportRunId(this._crawlState.getImportRunId());
            this.getPerformanceCounterHelper().setJobName(this._jobName);
        }
        catch (CrawlerException e) {
            this.getPerformanceCounterHelper().addException((Throwable)e);
            this._log.error((Object)"Non critical exception during crawler initialization", (Throwable)e);
        }
    }

    private void processDataReferences(DataReference[] dataReferences) throws CrawlerCriticalException {
        if (dataReferences != null) {
            try {
                this.getPerformanceCounterHelper().incrementDeltaIndicesBy((long)dataReferences.length);
                DataReference[] dataReferenceArray = dataReferences;
                int n = dataReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    DataReference dataReference = dataReferenceArray[n2];
                    if (this._stopped) {
                        return;
                    }
                    this.processDataReference(dataReference);
                    ++n2;
                }
            }
            catch (RuntimeException e) {
                this.getPerformanceCounterHelper().addCriticalException((Throwable)e);
                this._crawlState.setLastError((Throwable)e);
                throw e;
            }
        } else if (this._log.isWarnEnabled()) {
            this._log.warn((Object)"processDataReferences was called with dataReferences=null");
        }
    }

    /*
     * Exception decompiling
     */
    protected void processDataReference(DataReference dataReference) throws CrawlerCriticalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateDataReference(DataReference dataReference) throws CrawlerException, CrawlerCriticalException, DeltaIndexingSessionException, DeltaIndexingException {
        Record record = dataReference.getRecord();
        if (record != null) {
            ImportRunIdHelper.setImportRunIdAttribute(record, (State)this._crawlState);
            long recordAttachmentLength = this.getAttachmentsByteLength(record);
            this.getPerformanceCounterHelper().incrementAttachmentBytes(recordAttachmentLength);
            boolean isCompound = this.isCompound(record, this._configuration);
            if (isCompound) {
                record = this.processCompounds(record, this._configuration);
            }
            if (record != null) {
                this._recordBuffer.add(record);
                this.getPerformanceCounterHelper().incrementRecords();
                if (this._controllerCallback.doDeltaIndexing(this._configuration.getDeltaIndexing())) {
                    this._diManager.visit(this._sessionId, dataReference.getId(), dataReference.getHash(), isCompound);
                }
            }
        }
    }

    public void stopCrawl() {
        this._stopped = true;
    }

    private CrawlerControllerPerformanceCounterHelper getPerformanceCounterHelper() {
        if (this._performanceCounterHelper == null) {
            this._performanceCounterHelper = new CrawlerControllerPerformanceCounterHelper(this._configuration, this._crawler.hashCode());
        }
        return this._performanceCounterHelper;
    }

    public CrawlerPerformanceCounterHelper<? extends ConnectivityPerformanceAgent> getCrawlerCounterHelper() {
        return this._crawlerCounterHelper;
    }

    private long getAttachmentsByteLength(Record record) {
        if (!record.hasAttachments()) {
            return 0L;
        }
        long size = 0L;
        Iterator attachmentNames = record.getAttachmentNames();
        while (attachmentNames.hasNext()) {
            String attachmentName = (String)attachmentNames.next();
            byte[] attachment = record.getAttachmentAsBytes(attachmentName);
            if (attachment == null) continue;
            size += (long)attachment.length;
        }
        return size;
    }

    private Record processCompounds(Record record, DataSourceConnectionConfig config) throws CrawlerCriticalException {
        block18: {
            Crawler compoundCrawler = null;
            try {
                try {
                    compoundCrawler = this._compoundManager.extract(record, config);
                    if (compoundCrawler != null) {
                        while (!this._stopped) {
                            DataReference[] dataReferences = null;
                            int i = 0;
                            i = 0;
                            while (i < 1000) {
                                try {
                                    dataReferences = compoundCrawler.getNext();
                                    break;
                                }
                                catch (CrawlerException e) {
                                    this.getPerformanceCounterHelper().addException((Throwable)e);
                                    this._log.error((Object)"Non critical exception during compound crawler getNext() call", (Throwable)e);
                                    ++i;
                                }
                            }
                            if (dataReferences == null) {
                                if (i < 999) break;
                                this._log.error((Object)"Maximum noncritical errors reached");
                                break;
                            }
                            this.processDataReferences(dataReferences);
                        }
                    }
                    record = this._compoundManager.adaptCompoundRecord(record, config);
                }
                catch (CompoundException e) {
                    String msg = "Error during compound processing of record " + record.getId();
                    this._log.error((Object)msg, (Throwable)e);
                    if (compoundCrawler == null) break block18;
                    try {
                        compoundCrawler.close();
                    }
                    catch (CrawlerException e2) {
                        this.getPerformanceCounterHelper().addException((Throwable)e2);
                        String msg2 = "Error while closing CompoundCrawler while crawling dataSourceId " + this._configuration.getDataSourceID();
                        this._log.error((Object)msg2, (Throwable)e2);
                    }
                }
            }
            finally {
                if (compoundCrawler != null) {
                    try {
                        compoundCrawler.close();
                    }
                    catch (CrawlerException e) {
                        this.getPerformanceCounterHelper().addException((Throwable)e);
                        String msg = "Error while closing CompoundCrawler while crawling dataSourceId " + this._configuration.getDataSourceID();
                        this._log.error((Object)msg, (Throwable)e);
                    }
                }
            }
        }
        return record;
    }

    private boolean isCompound(Record record, DataSourceConnectionConfig config) {
        if (config.getCompoundHandling() != null) {
            try {
                return this._compoundManager.isCompound(record, config);
            }
            catch (CompoundException e) {
                String msg = "Error while checking if record " + record.getId() + " is a compound";
                this._log.error((Object)msg, (Throwable)e);
            }
        }
        return false;
    }

    private int deleteDelta(String dataSourceId) {
        int count = 0;
        if (this._controllerCallback.doDeltaDelete(this._configuration.getDeltaIndexing())) {
            try {
                Iterator it = this._diManager.obsoleteIdIterator(this._sessionId, dataSourceId);
                if (it != null) {
                    while (it.hasNext()) {
                        ConnectivityId id = (ConnectivityId)it.next();
                        if (id == null) continue;
                        Record record = DataFactory.DEFAULT.createRecord(id.getObjectId(), id.getDataSourceId());
                        ImportRunIdHelper.setImportRunIdAttribute(record, (State)this._crawlState);
                        this._connectivityManager.delete(new Record[]{record}, this._jobName);
                        this._diManager.delete(this._sessionId, id);
                        ++count;
                    }
                }
            }
            catch (Exception e) {
                this._log.error((Object)("Error during execution of deleteDelta for dataSourceId " + dataSourceId + " and job " + this._jobName), (Throwable)e);
            }
        }
        return count;
    }

    private void checkForFlush() throws ConnectivityException {
        if (this._recordBuffer.size() >= this._configuration.getRecordBuffer().getSize() || System.currentTimeMillis() - this._lastFlush > this._configuration.getRecordBuffer().getFlushInterval()) {
            this.flushRecords();
        }
    }

    private void flushRecords() throws ConnectivityException {
        if (!this._recordBuffer.isEmpty()) {
            try {
                this._lastFlush = System.currentTimeMillis();
                this._connectivityManager.add(this._recordBuffer.toArray(new Record[this._recordBuffer.size()]), this._jobName);
            }
            finally {
                this._recordBuffer.clear();
            }
        }
    }
}

