/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.performance;

import org.eclipse.smila.management.performance.PerformanceCounterFormula;
import org.eclipse.smila.management.performance.PerformanceSample;

public class PerformanceCounter {
    private PerformanceSample[] _samples;
    private final PerformanceCounterFormula _formula;
    private long _valueChange;
    private long _changesCount;

    public PerformanceCounter(PerformanceCounterFormula formula) {
        if (formula == null) {
            throw new IllegalArgumentException("Formula can't be null");
        }
        this._formula = formula;
        this.reset();
    }

    public void incrementBy(long value) {
        ++this._changesCount;
        this._valueChange += value;
    }

    public void decrementBy(long value) {
        ++this._changesCount;
        this._valueChange -= value;
    }

    public double getNextValue() {
        return this._formula.calculateValue(this._samples[0], this._samples[1]);
    }

    public double getNextSampleValue() {
        this.getNextPerformanceSample();
        return this.getNextValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerformanceSample getNextPerformanceSample() {
        PerformanceSample[] performanceSampleArray = this._samples;
        synchronized (this._samples) {
            this.sample();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._samples[1];
        }
    }

    private void sample() {
        this._samples[0].setBaseValue(this._samples[1].getBaseValue());
        this._samples[0].setRawValue(this._samples[1].getRawValue());
        this._samples[0].setTimestamp(this._samples[1].getTimestamp());
        this._samples[1].setTimestamp(System.currentTimeMillis());
        this._samples[1].setRawValue(this._samples[1].getRawValue() + this._valueChange);
        this._samples[1].setBaseValue(this._samples[1].getBaseValue() + this._changesCount);
        this._valueChange = 0L;
        this._changesCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        PerformanceSample[] performanceSampleArray = this._samples = new PerformanceSample[2];
        synchronized (this._samples) {
            this._samples[0] = new PerformanceSample();
            this._samples[1] = new PerformanceSample();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this._valueChange = 0L;
            this._changesCount = 0L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRawValue(long rawValue) {
        PerformanceSample[] performanceSampleArray = this._samples;
        synchronized (this._samples) {
            this.sample();
            this._samples[1].setRawValue(rawValue);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    public void increment() {
        this.incrementBy(1L);
    }

    public void decrement() {
        this.decrementBy(1L);
    }
}

