/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.compiler.bom.InvokeActivity;
import org.apache.ode.bpel.compiler.v2.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.v2.InvokeGeneratorMessages;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OInvoke;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvokeGenerator
extends DefaultActivityGenerator {
    private static final InvokeGeneratorMessages __imsgs = (InvokeGeneratorMessages)MessageBundle.getMessages(InvokeGeneratorMessages.class);

    InvokeGenerator() {
    }

    @Override
    public OActivity newInstance(Activity activity) {
        return new OInvoke(this._context.getOProcess(), this._context.getCurrent());
    }

    @Override
    public void compile(OActivity oActivity, Activity activity) {
        InvokeActivity invokeActivity = (InvokeActivity)activity;
        OInvoke oInvoke = (OInvoke)oActivity;
        oInvoke.partnerLink = this._context.resolvePartnerLink(invokeActivity.getPartnerLink());
        oInvoke.operation = this._context.resolvePartnerRoleOperation(oInvoke.partnerLink, invokeActivity.getOperation());
        assert (oInvoke.operation.getInput() != null);
        assert (oInvoke.operation.getInput().getMessage() != null);
        if (invokeActivity.getPortType() != null && !invokeActivity.getPortType().equals(oInvoke.partnerLink.partnerRolePortType.getQName())) {
            throw new CompilationException(__imsgs.errPortTypeMismatch(invokeActivity.getPortType(), oInvoke.partnerLink.partnerRolePortType.getQName()));
        }
        if (oInvoke.operation.getInput() != null && oInvoke.operation.getInput().getMessage() != null && oInvoke.operation.getInput().getMessage().getParts().size() > 0) {
            if (invokeActivity.getInputVar() == null) {
                throw new CompilationException(__imsgs.errInvokeNoInputMessageForInputOp(oInvoke.operation.getName()));
            }
            oInvoke.inputVar = this._context.resolveMessageVariable(invokeActivity.getInputVar(), oInvoke.operation.getInput().getMessage().getQName());
            oInvoke.variableRd.add(oInvoke.inputVar);
        }
        if (oInvoke.operation.getOutput() != null && oInvoke.operation.getOutput().getMessage() != null) {
            if (invokeActivity.getOutputVar() == null) {
                throw new CompilationException(__imsgs.errInvokeNoOutputMessageForOutputOp(oInvoke.operation.getName()));
            }
            oInvoke.outputVar = this._context.resolveMessageVariable(invokeActivity.getOutputVar(), oInvoke.operation.getOutput().getMessage().getQName());
            oInvoke.variableWr.add(oInvoke.outputVar);
        }
        List<Correlation> list = invokeActivity.getCorrelations();
        List list2 = (List)CollectionsX.filter(new ArrayList(), list, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation correlation) {
                return correlation.getPattern() == Correlation.CorrelationPattern.IN;
            }
        });
        List list3 = (List)CollectionsX.filter(new ArrayList(), list, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation correlation) {
                return correlation.getPattern() == Correlation.CorrelationPattern.OUT;
            }
        });
        List list4 = (List)CollectionsX.filter(new ArrayList(), list, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation correlation) {
                return correlation.getPattern() == Correlation.CorrelationPattern.INOUT;
            }
        });
        if (oInvoke.inputVar != null) {
            this.doCorrelations(list3, oInvoke.inputVar, oInvoke.assertCorrelationsInput, oInvoke.initCorrelationsInput);
            this.doCorrelations(list4, oInvoke.inputVar, oInvoke.assertCorrelationsInput, oInvoke.initCorrelationsInput);
        }
        if (oInvoke.outputVar != null) {
            this.doCorrelations(list2, oInvoke.outputVar, oInvoke.assertCorrelationsOutput, oInvoke.initCorrelationsOutput);
            this.doCorrelations(list4, oInvoke.outputVar, oInvoke.assertCorrelationsOutput, oInvoke.initCorrelationsOutput);
        }
    }

    private void doCorrelations(List<Correlation> list, OScope.Variable variable, Collection<OScope.CorrelationSet> collection, Collection<OScope.CorrelationSet> collection2) {
        for (Correlation correlation : list) {
            OScope.CorrelationSet correlationSet = this._context.resolveCorrelationSet(correlation.getCorrelationSet());
            switch (correlation.getInitiate()) {
                case NO: {
                    collection.add(correlationSet);
                    break;
                }
                case YES: {
                    collection2.add(correlationSet);
                    break;
                }
                case JOIN: {
                    throw new UnsupportedOperationException();
                }
            }
            for (OProcess.OProperty oProperty : correlationSet.properties) {
                try {
                    this._context.resolvePropertyAlias(variable, oProperty.name);
                }
                catch (CompilationException compilationException) {
                    if (compilationException.getCompilationMessage().source == null) {
                        compilationException.getCompilationMessage().source = correlation;
                    }
                    throw compilationException;
                }
            }
        }
    }
}

