/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2.xpath10;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.CompilationExceptionWrapper;
import org.apache.ode.bpel.compiler.XPathMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.compiler.v2.CompilerContext;
import org.apache.ode.bpel.compiler.v2.ExpressionCompiler;
import org.apache.ode.bpel.compiler.v2.xpath10.JaxenBpelHandler;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10Expression;
import org.apache.ode.utils.msg.MessageBundle;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XPath10ExpressionCompilerImpl
implements ExpressionCompiler {
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    protected CompilerContext _compilerContext;
    private String _bpelNsURI;
    protected QName _qnFnGetVariableData;
    protected QName _qnFnGetVariableProperty;
    protected QName _qnFnGetLinkStatus;
    protected Map<String, String> _properties = new HashMap<String, String>();

    public XPath10ExpressionCompilerImpl(String string) {
        this._bpelNsURI = string;
        this._qnFnGetVariableData = new QName(this._bpelNsURI, "getVariableData");
        this._qnFnGetVariableProperty = new QName(this._bpelNsURI, "getVariableProperty");
        this._qnFnGetLinkStatus = new QName(this._bpelNsURI, "getLinkStatus");
        this._properties.put("runtime-class", "org.apache.ode.bpel.rtrep.v2.xpath10.XPath10ExpressionRuntime");
    }

    @Override
    public void setCompilerContext(CompilerContext compilerContext) {
        this._compilerContext = compilerContext;
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }

    protected void doJaxenCompile(OXPath10Expression oXPath10Expression, Expression expression) throws CompilationException {
        Node node = expression.getExpression();
        if (node == null) {
            throw new IllegalStateException("XPath string and xpath node are both null");
        }
        String string = node.getNodeValue();
        if ((string = string.trim()).length() == 0) {
            throw new CompilationException(__msgs.errXPathSyntax(string));
        }
        try {
            XPathReader xPathReader = XPathReaderFactory.createReader();
            JaxenBpelHandler jaxenBpelHandler = new JaxenBpelHandler(this._bpelNsURI, oXPath10Expression, expression.getNamespaceContext(), this._compilerContext);
            xPathReader.setXPathHandler((XPathHandler)jaxenBpelHandler);
            xPathReader.parse(string);
            oXPath10Expression.xpath = string;
        }
        catch (CompilationExceptionWrapper compilationExceptionWrapper) {
            CompilationException compilationException = compilationExceptionWrapper.getCompilationException();
            if (compilationException == null) {
                compilationException = new CompilationException(__msgs.errUnexpectedCompilationError(compilationExceptionWrapper.getMessage()), (Throwable)((Object)compilationExceptionWrapper));
            }
            throw compilationException;
        }
        catch (SAXPathException sAXPathException) {
            throw new CompilationException(__msgs.errXPathSyntax(string));
        }
    }
}

