/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.httphandler;

import java.util.Map;
import org.eclipse.smila.connectivity.framework.AgentController;
import org.eclipse.smila.connectivity.framework.AgentState;
import org.eclipse.smila.connectivity.framework.httphandler.BaseConnectivityHandler;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.util.URLCreator;

public class AgentsHandler
extends BaseConnectivityHandler {
    public static final String KEY_AGENTS = "agents";
    public static final String KEY_NAME = "name";
    public static final String KEY_STATE = "state";
    public static final String KEY_URL = "url";
    private AgentController _agentController;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        AnyMap resultMap = DataFactory.DEFAULT.createAnyMap();
        AnySeq stateSeq = DataFactory.DEFAULT.createAnySeq();
        if (this._agentController != null) {
            Map<String, AgentState> agentTaskStates = this._agentController.getAgentTasksState();
            for (String availableAgent : this._agentController.getAvailableConfigurations()) {
                AnyMap stateMap = DataFactory.DEFAULT.createAnyMap();
                AgentState state = agentTaskStates.get(availableAgent);
                String stateString = state != null ? state.getState().name() : "Undefined";
                stateMap.put(KEY_NAME, availableAgent);
                stateMap.put(KEY_STATE, stateString);
                stateMap.put(KEY_URL, URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)availableAgent).toURI().toASCIIString());
                stateSeq.add((Object)stateMap);
            }
            resultMap.put(KEY_AGENTS, (Any)stateSeq);
        }
        return resultMap;
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    protected void setAgentController(AgentController agentController) {
        this._agentController = agentController;
    }

    protected void unsetAgentController(AgentController agentController) {
        if (this._agentController == agentController) {
            this._agentController = null;
        }
    }
}

