/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.util;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;

public final class ConnectivityIdFactory {
    private static ConnectivityIdFactory s_instance;

    private ConnectivityIdFactory() {
    }

    public static ConnectivityIdFactory getInstance() {
        if (s_instance == null) {
            s_instance = new ConnectivityIdFactory();
        }
        return s_instance;
    }

    public ConnectivityId createId(String dataSourceId, AnyMap idAttributes) {
        if (dataSourceId == null || dataSourceId.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter dataSourceId must not be null or empty");
        }
        if (idAttributes == null || idAttributes.size() == 0) {
            throw new IllegalArgumentException("Parameter idAttributes must not be null or empty");
        }
        StringBuilder sb = new StringBuilder(dataSourceId).append(":<");
        Iterator iter = idAttributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            sb.append((String)entry.getKey()).append('=').append(((Any)entry.getValue()).toString());
            if (!iter.hasNext()) continue;
            sb.append(';');
        }
        sb.append('>');
        return new ConnectivityId(dataSourceId, sb.toString());
    }

    public ConnectivityId createId(String dataSourceId, String simpleId) {
        if (dataSourceId == null || dataSourceId.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter dataSourceId must not be null or empty");
        }
        StringBuilder sb = new StringBuilder(dataSourceId).append(":<");
        sb.append(simpleId);
        sb.append('>');
        return new ConnectivityId(dataSourceId, sb.toString());
    }
}

