/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.schema;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.schema.DataSourceConnectionConfigPlugin;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfigSimple;
import org.eclipse.smila.connectivity.framework.schema.exceptions.SchemaNotFoundException;
import org.eclipse.smila.connectivity.framework.schema.exceptions.SchemaRuntimeException;
import org.eclipse.smila.connectivity.framework.schema.internal.JaxbPluginContext;
import org.eclipse.smila.connectivity.framework.schema.internal.JaxbThreadContext;
import org.eclipse.smila.utils.extensions.AbstractCollectionPluginRegistry;

public final class ConfigurationLoader {
    private static final ConfigurationRegistry REGISTRY = new ConfigurationRegistry();

    private ConfigurationLoader() {
    }

    public static JAXBContext newContext(String bundleID) throws SchemaNotFoundException {
        DataSourceConnectionConfigPlugin plugIn = ConfigurationLoader.getPlugin(bundleID);
        if (plugIn == null) {
            throw new SchemaNotFoundException(bundleID);
        }
        ClassLoader cl = plugIn.getClass().getClassLoader();
        Class[] allClasses = new Class[3];
        allClasses[0] = DataSourceConnectionConfig.class;
        try {
            allClasses[1] = cl.loadClass(String.valueOf(plugIn.getMessagesPackage()) + ".Attribute");
            allClasses[2] = cl.loadClass(String.valueOf(plugIn.getMessagesPackage()) + ".Process");
        }
        catch (ClassNotFoundException e) {
            throw new SchemaRuntimeException(e);
        }
        cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ConfigurationLoader.class.getClassLoader());
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])allClasses);
            return jAXBContext;
        }
        catch (JAXBException e) {
            throw new SchemaRuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static JAXBContext newSimpleContext() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ConfigurationLoader.class.getClassLoader());
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{DataSourceConnectionConfigSimple.class});
            return jAXBContext;
        }
        catch (JAXBException e) {
            throw new SchemaRuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static DataSourceConnectionConfig unmarshall(InputStream is) throws JAXBException, IOException, SchemaNotFoundException {
        DataSourceConnectionConfig dataSourceConnectionConfig;
        Log log = LogFactory.getLog(ConfigurationLoader.class);
        if (is == null) {
            throw new SchemaRuntimeException("Configaration stream is null!");
        }
        ByteArrayInputStream inputStream = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            byte[] array = bos.toByteArray();
            bos = null;
            inputStream = new ByteArrayInputStream(array);
            JaxbThreadContext.setPluginContext(Thread.currentThread(), null);
            JAXBContext jaxbContext = ConfigurationLoader.newSimpleContext();
            jaxbContext.createUnmarshaller().unmarshal((InputStream)inputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            JaxbPluginContext pluginContext = JaxbThreadContext.getPluginContext(Thread.currentThread());
            Unmarshaller finalUnmarshaller = pluginContext.createValidatingUnmarshaller();
            inputStream = new ByteArrayInputStream(array);
            dataSourceConnectionConfig = (DataSourceConnectionConfig)finalUnmarshaller.unmarshal((InputStream)inputStream);
        }
        catch (SchemaNotFoundException e) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                JaxbThreadContext.removeKey(Thread.currentThread());
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        JaxbThreadContext.removeKey(Thread.currentThread());
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((InputStream)inputStream);
        return dataSourceConnectionConfig;
    }

    public static Marshaller crateMarshaller(DataSourceConnectionConfig configuration) throws JAXBException, SchemaNotFoundException {
        String schemaID = configuration.getSchemaID();
        DataSourceConnectionConfigPlugin schema = ConfigurationLoader.getPlugin(schemaID);
        if (schema == null) {
            throw new SchemaNotFoundException("Schema " + schemaID + " is not found");
        }
        System.out.println("Schema ID= " + schemaID);
        JaxbThreadContext.setPluginContext(Thread.currentThread(), null);
        JAXBContext jaxbContext = ConfigurationLoader.newContext(schemaID);
        return jaxbContext.createMarshaller();
    }

    public static void marshall(DataSourceConnectionConfig configuration, Writer writer) throws JAXBException, SchemaNotFoundException {
        Marshaller marshaller = ConfigurationLoader.crateMarshaller(configuration);
        marshaller.marshal((Object)configuration, writer);
    }

    public static DataSourceConnectionConfigPlugin getPlugin(String id) {
        return (DataSourceConnectionConfigPlugin)REGISTRY.getPlugin(id);
    }

    private static class ConfigurationRegistry
    extends AbstractCollectionPluginRegistry<DataSourceConnectionConfigPlugin> {
        private ConfigurationRegistry() {
        }

        protected DataSourceConnectionConfigPlugin[] createEmptyArray(int size) {
            return new DataSourceConnectionConfigPlugin[size];
        }

        protected String getExtensionPointNameSpace() {
            return "org.eclipse.smila.connectivity.framework.schema";
        }

        protected String getExtensionPointLocalName() {
            return "extension";
        }
    }
}

