/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetCursor;
import org.apache.derby.client.net.NetStatement;

public class NetResultSet
extends ResultSet {
    private final NetConnection netConnection_;
    private final NetStatement netStatement_;
    final NetCursor netCursor_;
    private final NetAgent netAgent_;
    private boolean isFixedRowProtocol = false;
    public boolean firstOutovrBuilt_ = false;

    NetResultSet(NetAgent netAgent, NetStatement netStatement, Cursor cursor, int qryprctyp, int sqlcsrhld, int qryattscr, int qryattsns, int qryattset, long qryinsid, int actualResultSetType, int actualResultSetConcurrency, int actualResultSetHoldability) {
        super(netAgent, netStatement.statement_, cursor, actualResultSetType, actualResultSetConcurrency, actualResultSetHoldability);
        this.netAgent_ = netAgent;
        this.netCursor_ = (NetCursor)this.cursor_;
        this.netStatement_ = netStatement;
        this.netConnection_ = netStatement.netConnection_;
        this.netCursor_.netResultSet_ = this;
        boolean bl = this.cursorHold_ = sqlcsrhld != 240;
        if (qryattscr == 241) {
            this.scrollable_ = true;
        }
        if (qryprctyp == 9240) {
            this.isFixedRowProtocol = true;
            this.fetchSize_ = 1;
        } else {
            this.fetchSize_ = this.suggestedFetchSize_;
        }
        switch (qryattsns) {
            case 0: {
                this.sensitivity_ = 0;
                break;
            }
            case 1: {
                this.sensitivity_ = 1;
                break;
            }
            case 2: {
                this.sensitivity_ = 2;
                break;
            }
        }
        if (qryattset == 241) {
            this.isRowsetCursor_ = true;
        }
        this.queryInstanceIdentifier_ = qryinsid;
        this.nestingLevel_ = (int)(this.queryInstanceIdentifier_ >>> 48 & 0xFFFFL);
    }

    protected void parseRowset_() throws SqlException {
        int row = 0;
        while (this.netCursor_.calculateColumnOffsetsForRow_(row, true)) {
            ++this.rowsReceivedInCurrentRowset_;
            ++row;
        }
        while (this.rowsReceivedInCurrentRowset_ != this.fetchSize_ && !this.netCursor_.allRowsReceivedFromServer() && !this.isRowsetCursor_ && this.sensitivity_ != 3 && this.sensitivity_ != 2) {
            this.flowFetchToCompleteRowset();
            while (this.netCursor_.calculateColumnOffsetsForRow_(row, true)) {
                ++this.rowsReceivedInCurrentRowset_;
                ++row;
            }
        }
        this.checkAndThrowReceivedQueryTerminatingException();
    }

    public void setFetchSize_(int rows) {
        int n = this.suggestedFetchSize_ = rows == 0 ? 64 : rows;
        if (!this.isFixedRowProtocol) {
            this.fetchSize_ = this.suggestedFetchSize_;
        }
    }

    void flowFetchToCompleteRowset() throws DisconnectException {
        try {
            this.agent_.beginWriteChain(this.statement_);
            this.writeScrollableFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_, this.fetchSize_ - this.rowsReceivedInCurrentRowset_, 1, 1L, false);
            this.agent_.flow(this.statement_);
            this.readScrollableFetch_();
            this.agent_.endReadChain();
        }
        catch (SqlException e) {
            throw new DisconnectException(this.agent_, e);
        }
    }

    void queryDataWasReturnedOnOpen() throws DisconnectException {
    }

    public void writeFetch_(Section section) throws SqlException {
        if (this.resultSetType_ == 1003 && this.fetchSize_ != 0 && this.rowsYetToBeReceivedForRowset_ > 0) {
            this.netAgent_.resultSetRequest_.writeFetch(this, section, this.rowsYetToBeReceivedForRowset_);
        } else {
            this.netAgent_.resultSetRequest_.writeFetch(this, section, this.fetchSize_);
        }
    }

    public void readFetch_() throws SqlException {
        this.netAgent_.resultSetReply_.readFetch(this);
    }

    public void writeScrollableFetch_(Section section, int fetchSize, int orientation, long rowToFetch, boolean resetQueryBlocks) throws SqlException {
        this.netAgent_.resultSetRequest_.writeScrollableFetch(this, section, fetchSize, orientation, rowToFetch, resetQueryBlocks);
    }

    public void readScrollableFetch_() throws SqlException {
        this.netAgent_.resultSetReply_.readScrollableFetch(this);
    }

    public void writePositioningFetch_(Section section, int orientation, long rowToFetch) throws SqlException {
        this.netAgent_.resultSetRequest_.writePositioningFetch(this, section, orientation, rowToFetch);
    }

    public void readPositioningFetch_() throws SqlException {
        this.netAgent_.resultSetReply_.readPositioningFetch(this);
    }

    public void writeCursorClose_(Section section) throws SqlException {
        this.netAgent_.resultSetRequest_.writeCursorClose(this, section);
    }

    public void readCursorClose_() throws SqlException {
        this.netAgent_.resultSetReply_.readCursorClose(this);
    }

    protected void preClose_() throws SqlException {
        if (this.netCursor_.getQryclsimpEnabled()) {
            this.netCursor_.scanDataBufferForEndOfData();
        }
    }
}

