/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportBlob;
import org.apache.derby.impl.load.ImportClob;
import org.apache.derby.impl.load.ImportLobFile;
import org.apache.derby.impl.load.LoadError;

final class ImportReadData
implements PrivilegedExceptionAction {
    private String inputFileName;
    private int[] columnWidths;
    private int rowWidth;
    private char[] tempString;
    private int numberOfCharsReadSoFar;
    private BufferedReader bufferedReader;
    private static final int START_SIZE = 10240;
    private char[] currentToken = new char[10240];
    private int currentTokenMaxSize = 10240;
    boolean foundStartDelimiter;
    int totalCharsSoFar;
    int positionOfNonWhiteSpaceCharInFront;
    int positionOfNonWhiteSpaceCharInBack;
    int lineNumber;
    int fieldStartDelimiterIndex;
    int fieldStopDelimiterIndex;
    int stopDelimiterPosition;
    boolean foundStartAndStopDelimiters;
    boolean streamOpenForReading;
    static final int DEFAULT_FORMAT_CODE = 0;
    static final int ASCII_FIXED_FORMAT_CODE = 1;
    private int formatCode = 0;
    private boolean hasColumnDefinition;
    private char recordSeparatorChar0;
    private char fieldSeparatorChar0;
    private boolean recordSepStartNotWhite = true;
    private boolean fieldSepStartNotWhite = true;
    protected ControlInfo controlFileReader;
    protected int numberOfColumns;
    protected String[] columnTypes;
    protected char[] fieldSeparator;
    protected int fieldSeparatorLength;
    protected char[] recordSeparator;
    protected int recordSeparatorLength;
    protected String nullString;
    protected String columnDefinition;
    protected String format;
    protected String dataCodeset;
    protected char[] fieldStartDelimiter;
    protected int fieldStartDelimiterLength;
    protected char[] fieldStopDelimiter;
    protected int fieldStopDelimiterLength;
    protected boolean hasDelimiterAtEnd;
    private ImportLobFile[] lobFileHandles;
    private String lobFileName;
    private int lobOffset;
    private int lobLength;
    private boolean haveSep = true;

    private void loadPropertiesInfo() throws Exception {
        this.fieldSeparator = this.controlFileReader.getFieldSeparator().toCharArray();
        this.fieldSeparatorLength = this.fieldSeparator.length;
        this.recordSeparator = this.controlFileReader.getRecordSeparator().toCharArray();
        this.recordSeparatorLength = this.recordSeparator.length;
        this.nullString = this.controlFileReader.getNullString();
        this.columnDefinition = this.controlFileReader.getColumnDefinition();
        this.format = this.controlFileReader.getFormat();
        this.dataCodeset = this.controlFileReader.getDataCodeset();
        this.fieldStartDelimiter = this.controlFileReader.getFieldStartDelimiter().toCharArray();
        this.fieldStartDelimiterLength = this.fieldStartDelimiter.length;
        this.fieldStopDelimiter = this.controlFileReader.getFieldEndDelimiter().toCharArray();
        this.fieldStopDelimiterLength = this.fieldStopDelimiter.length;
        this.hasDelimiterAtEnd = this.controlFileReader.getHasDelimiterAtEnd();
        if (this.recordSeparatorLength > 0) {
            this.recordSeparatorChar0 = this.recordSeparator[0];
            boolean bl = this.recordSepStartNotWhite = !Character.isWhitespace(this.recordSeparatorChar0);
        }
        if (this.fieldSeparatorLength > 0) {
            this.fieldSeparatorChar0 = this.fieldSeparator[0];
            this.fieldSepStartNotWhite = !Character.isWhitespace(this.fieldSeparatorChar0);
        }
    }

    ImportReadData(String inputFileName, ControlInfo controlFileReader) throws Exception {
        this.inputFileName = inputFileName;
        this.controlFileReader = controlFileReader;
        this.loadPropertiesInfo();
        this.loadMetaData();
        this.lobFileHandles = new ImportLobFile[this.numberOfColumns];
    }

    int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    protected void ignoreFirstRow() throws Exception {
        this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength, true);
    }

    protected void loadColumnTypes() throws Exception {
        this.findNumberOfColumnsInARow();
        this.closeStream();
        this.openFile();
        String[] metaDataArray = new String[this.numberOfColumns];
        this.readNextDelimitedRow(metaDataArray);
        this.columnTypes = new String[this.numberOfColumns / 2];
        for (int idx = 0; idx < this.numberOfColumns; idx += 2) {
            this.columnTypes[idx / 2] = metaDataArray[idx + 1];
        }
        this.closeStream();
        this.openFile();
        this.numberOfColumns = 0;
    }

    private void openFile() throws Exception {
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public final Object run() throws Exception {
        this.realOpenFile();
        return null;
    }

    private void realOpenFile() throws Exception {
        InputStream inputStream;
        try {
            try {
                URL url = new URL(this.inputFileName);
                if (url.getProtocol().equals("file")) {
                    this.inputFileName = url.getFile();
                    throw new MalformedURLException();
                }
                inputStream = url.openStream();
            }
            catch (MalformedURLException ex) {
                inputStream = new FileInputStream(this.inputFileName);
            }
        }
        catch (FileNotFoundException ex) {
            throw LoadError.dataFileNotFound(this.inputFileName, ex);
        }
        catch (SecurityException se) {
            throw LoadError.dataFileNotFound(this.inputFileName, se);
        }
        InputStreamReader rd = this.dataCodeset == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.dataCodeset);
        this.bufferedReader = new BufferedReader(rd, 32768);
        this.streamOpenForReading = true;
    }

    private void loadMetaData() throws Exception {
        this.openFile();
        if (this.columnDefinition.toUpperCase(Locale.ENGLISH).equals("True".toUpperCase(Locale.ENGLISH))) {
            this.hasColumnDefinition = true;
            this.ignoreFirstRow();
        }
        if (this.formatCode == 0) {
            this.findNumberOfColumnsInARow();
        }
        this.closeStream();
    }

    void closeStream() throws Exception {
        if (this.streamOpenForReading) {
            this.bufferedReader.close();
            this.streamOpenForReading = false;
        }
        if (this.lobFileHandles != null) {
            for (int i = 0; i < this.numberOfColumns; ++i) {
                if (this.lobFileHandles[i] == null) continue;
                this.lobFileHandles[i].close();
            }
        }
    }

    int findNumberOfColumnsInARow() throws Exception {
        this.numberOfColumns = 1;
        while (!this.readTokensUntilEndOfRecord()) {
            ++this.numberOfColumns;
        }
        if (this.hasDelimiterAtEnd) {
            --this.numberOfColumns;
        }
        if (this.numberOfCharsReadSoFar == 0) {
            this.numberOfColumns = 0;
        }
        return this.numberOfColumns;
    }

    private void checkForWhiteSpaceInFront() {
        char currentChar;
        if (!(this.positionOfNonWhiteSpaceCharInFront + 1 != this.totalCharsSoFar || this.foundStartDelimiter || this.foundStartAndStopDelimiters || !Character.isWhitespace(currentChar = this.currentToken[this.positionOfNonWhiteSpaceCharInFront]) || !this.recordSepStartNotWhite && currentChar == this.recordSeparatorChar0 || !this.fieldSepStartNotWhite && currentChar == this.fieldSeparatorChar0)) {
            ++this.positionOfNonWhiteSpaceCharInFront;
        }
    }

    private void checkForWhiteSpaceInBack() {
        boolean onlyWhiteSpaceSoFar = true;
        this.positionOfNonWhiteSpaceCharInBack = 0;
        for (int i = this.totalCharsSoFar; i > this.stopDelimiterPosition && onlyWhiteSpaceSoFar; --i) {
            char currentChar = this.currentToken[i];
            if (Character.isWhitespace(currentChar)) {
                if (!this.recordSepStartNotWhite && currentChar == this.recordSeparatorChar0 || !this.fieldSepStartNotWhite && currentChar == this.fieldSeparatorChar0) continue;
                ++this.positionOfNonWhiteSpaceCharInBack;
                continue;
            }
            onlyWhiteSpaceSoFar = false;
        }
    }

    boolean readTokensUntilEndOfRecord() throws Exception {
        int nextChar;
        int fieldSeparatorIndex = 0;
        int recordSeparatorIndex = 0;
        this.fieldStopDelimiterIndex = 0;
        this.fieldStartDelimiterIndex = 0;
        this.totalCharsSoFar = 0;
        this.positionOfNonWhiteSpaceCharInFront = 0;
        this.foundStartDelimiter = false;
        this.foundStartAndStopDelimiters = false;
        this.numberOfCharsReadSoFar = 0;
        do {
            if ((nextChar = this.bufferedReader.read()) == -1) {
                return true;
            }
            ++this.numberOfCharsReadSoFar;
            this.currentToken[this.totalCharsSoFar++] = (char)nextChar;
            this.checkForWhiteSpaceInFront();
            if (this.totalCharsSoFar == this.currentTokenMaxSize) {
                this.currentTokenMaxSize *= 2;
                char[] tempArray = new char[this.currentTokenMaxSize];
                System.arraycopy(this.currentToken, 0, tempArray, 0, this.totalCharsSoFar);
                this.currentToken = tempArray;
            }
            if ((fieldSeparatorIndex = this.lookForPassedSeparator(this.fieldSeparator, fieldSeparatorIndex, this.fieldSeparatorLength, nextChar, false)) != -1) continue;
            return false;
        } while (this.foundStartDelimiter || (recordSeparatorIndex = this.lookForPassedSeparator(this.recordSeparator, recordSeparatorIndex, this.recordSeparatorLength, nextChar, true)) != -1);
        return true;
    }

    private int lookForPassedSeparator(char[] delimiter, int delimiterIndex, int delimiterLength, int nextChar, boolean lookForRecordSeperator) throws IOException {
        if (!this.foundStartDelimiter) {
            if (this.fieldStartDelimiterLength != 0 && !this.foundStartAndStopDelimiters && this.totalCharsSoFar != this.positionOfNonWhiteSpaceCharInFront && this.totalCharsSoFar - this.positionOfNonWhiteSpaceCharInFront <= this.fieldStartDelimiterLength) {
                if (nextChar == this.fieldStartDelimiter[this.fieldStartDelimiterIndex]) {
                    ++this.fieldStartDelimiterIndex;
                    if (this.fieldStartDelimiterIndex == this.fieldStartDelimiterLength) {
                        this.foundStartDelimiter = true;
                        this.totalCharsSoFar = 0;
                        this.positionOfNonWhiteSpaceCharInFront = 0;
                        return 0;
                    }
                } else if (this.fieldStartDelimiterIndex > 0) {
                    this.reCheckRestOfTheCharacters(this.totalCharsSoFar - this.fieldStartDelimiterIndex, this.fieldStartDelimiter, this.fieldStartDelimiterLength);
                }
            }
            if (lookForRecordSeperator) {
                if (nextChar == 13 || nextChar == 10) {
                    this.recordSeparatorChar0 = (char)nextChar;
                    if (nextChar == 13) {
                        this.omitLineFeed();
                    }
                    --this.totalCharsSoFar;
                    return -1;
                }
                return delimiterIndex;
            }
            if (nextChar == delimiter[delimiterIndex]) {
                if (++delimiterIndex == delimiterLength) {
                    this.totalCharsSoFar -= delimiterLength;
                    return -1;
                }
                return delimiterIndex;
            }
            if (delimiterIndex > 0) {
                return this.reCheckRestOfTheCharacters(this.totalCharsSoFar - delimiterIndex, delimiter, delimiterLength);
            }
        } else {
            if (nextChar == this.fieldStopDelimiter[this.fieldStopDelimiterIndex]) {
                ++this.fieldStopDelimiterIndex;
                if (this.fieldStopDelimiterIndex == this.fieldStopDelimiterLength) {
                    boolean skipped = this.skipDoubleDelimiters(this.fieldStopDelimiter);
                    if (!skipped) {
                        this.foundStartDelimiter = false;
                        this.totalCharsSoFar -= this.fieldStopDelimiterLength;
                        this.stopDelimiterPosition = this.totalCharsSoFar;
                        this.foundStartAndStopDelimiters = true;
                    } else {
                        this.fieldStopDelimiterIndex = 0;
                    }
                    return 0;
                }
                return 0;
            }
            if (this.fieldStopDelimiterIndex > 0) {
                this.reCheckRestOfTheCharacters(this.totalCharsSoFar - this.fieldStopDelimiterIndex, this.fieldStopDelimiter, this.fieldStopDelimiterLength);
                return 0;
            }
        }
        return 0;
    }

    private int reCheckRestOfTheCharacters(int startFrom, char[] delimiter, int delimiterLength) {
        int delimiterIndex = 0;
        for (int i = startFrom; i < this.totalCharsSoFar; ++i) {
            if (this.currentToken[i] == delimiter[delimiterIndex]) {
                ++delimiterIndex;
                continue;
            }
            delimiterIndex = 0;
        }
        return delimiterIndex;
    }

    private boolean skipDoubleDelimiters(char[] characterDelimiter) throws IOException {
        boolean skipped = true;
        int cDelLength = characterDelimiter.length;
        this.bufferedReader.mark(cDelLength);
        for (int i = 0; i < cDelLength; ++i) {
            int nextChar = this.bufferedReader.read();
            if (nextChar == characterDelimiter[i]) continue;
            this.bufferedReader.reset();
            skipped = false;
            break;
        }
        return skipped;
    }

    private void omitLineFeed() throws IOException {
        this.bufferedReader.mark(1);
        int nextChar = this.bufferedReader.read();
        if (nextChar != 10) {
            this.bufferedReader.reset();
        }
    }

    int getCurrentRowNumber() {
        return this.lineNumber;
    }

    boolean readNextRow(String[] returnStringArray) throws Exception {
        if (!this.streamOpenForReading) {
            this.openFile();
            if (this.hasColumnDefinition) {
                this.ignoreFirstRow();
            }
        }
        boolean readVal = this.formatCode == 0 ? this.readNextDelimitedRow(returnStringArray) : this.readNextFixedRow(returnStringArray);
        return readVal;
    }

    private boolean readNextFixedRow(String[] returnStringArray) throws Exception {
        int i;
        int readLength = 0;
        int totalLength = 0;
        while ((readLength += this.bufferedReader.read(this.tempString, readLength, this.rowWidth - readLength)) < this.rowWidth) {
            if (readLength == totalLength - 1) {
                if (readLength == -1) {
                    return false;
                }
                if (totalLength != this.rowWidth - this.recordSeparator.length) {
                    throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
                }
                this.haveSep = false;
                break;
            }
            totalLength = readLength;
        }
        int colStart = 0;
        for (i = 0; i < this.numberOfColumns; ++i) {
            int colWidth = this.columnWidths[i];
            if (colWidth == 0) {
                returnStringArray[i] = null;
                continue;
            }
            String checkAgainstNullString = new String(this.tempString, colStart, colWidth);
            returnStringArray[i] = checkAgainstNullString.trim().equals(this.nullString) ? null : checkAgainstNullString;
            colStart += colWidth;
        }
        if (this.haveSep) {
            for (i = this.recordSeparatorLength - 1; i >= 0; --i) {
                if (this.tempString[colStart + i] == this.recordSeparator[i]) continue;
                throw LoadError.recordSeparatorMissing(this.lineNumber + 1);
            }
        } else {
            this.haveSep = true;
        }
        ++this.lineNumber;
        return true;
    }

    private boolean readNextDelimitedRow(String[] returnStringArray) throws Exception {
        int i;
        int upperLimit = this.numberOfColumns - 1;
        if (upperLimit < 0) {
            return false;
        }
        for (i = 0; i < upperLimit; ++i) {
            if (!this.readNextToken(this.fieldSeparator, 0, this.fieldSeparatorLength, false)) {
                if (i == 0) {
                    return false;
                }
                throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
            }
            if (this.stopDelimiterPosition != 0 && this.stopDelimiterPosition != this.totalCharsSoFar) {
                for (int k = this.stopDelimiterPosition + 1; k < this.totalCharsSoFar; ++k) {
                    if (Character.isWhitespace(this.currentToken[k])) continue;
                    throw LoadError.dataAfterStopDelimiter(this.lineNumber + 1, i + 1);
                }
                this.totalCharsSoFar = this.stopDelimiterPosition;
            }
            returnStringArray[i] = this.totalCharsSoFar != -1 ? new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar) : null;
        }
        if (!this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength, true)) {
            if (upperLimit == 0) {
                return false;
            }
            throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
        }
        if (this.stopDelimiterPosition != 0 && this.stopDelimiterPosition != this.totalCharsSoFar) {
            for (i = this.stopDelimiterPosition + 1; i < this.totalCharsSoFar; ++i) {
                if (Character.isWhitespace(this.currentToken[i])) continue;
                throw LoadError.dataAfterStopDelimiter(this.lineNumber + 1, this.numberOfColumns);
            }
            this.totalCharsSoFar = this.stopDelimiterPosition;
        }
        if (this.hasDelimiterAtEnd && this.fieldStopDelimiterLength <= 0) {
            --this.totalCharsSoFar;
        }
        if (this.totalCharsSoFar > -1) {
            if (!this.hasDelimiterAtEnd) {
                returnStringArray[upperLimit] = new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar);
            } else if (this.totalCharsSoFar == this.fieldSeparatorLength && this.isFieldSep(this.currentToken)) {
                String currentStr = new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar);
                returnStringArray[upperLimit] = this.currentToken[this.totalCharsSoFar + 1] == this.fieldStopDelimiter[0] ? currentStr : null;
            } else {
                returnStringArray[upperLimit] = this.totalCharsSoFar > 0 ? new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar) : null;
            }
        } else {
            returnStringArray[upperLimit] = null;
        }
        ++this.lineNumber;
        return true;
    }

    private boolean isFieldSep(char[] chrArray) {
        for (int i = 0; i < chrArray.length && i < this.fieldSeparatorLength; ++i) {
            if (chrArray[i] == this.fieldSeparator[i]) continue;
            return false;
        }
        return true;
    }

    boolean readNextToken(char[] delimiter, int delimiterIndex, int delimiterLength, boolean isRecordSeperator) throws Exception {
        this.fieldStopDelimiterIndex = 0;
        this.fieldStartDelimiterIndex = 0;
        this.totalCharsSoFar = 0;
        this.positionOfNonWhiteSpaceCharInFront = 0;
        this.stopDelimiterPosition = 0;
        this.foundStartAndStopDelimiters = false;
        this.foundStartDelimiter = false;
        int nextChar;
        while ((nextChar = this.bufferedReader.read()) != -1) {
            int returnValue;
            this.currentToken[this.totalCharsSoFar++] = (char)nextChar;
            this.checkForWhiteSpaceInFront();
            if (this.totalCharsSoFar == this.currentTokenMaxSize) {
                this.currentTokenMaxSize *= 2;
                char[] tempArray = new char[this.currentTokenMaxSize];
                System.arraycopy(this.currentToken, 0, tempArray, 0, this.totalCharsSoFar);
                this.currentToken = tempArray;
            }
            if ((returnValue = this.lookForPassedSeparator(delimiter, delimiterIndex, delimiterLength, nextChar, isRecordSeperator)) == -1) {
                if (!this.foundStartAndStopDelimiters) {
                    if (this.totalCharsSoFar == 0) {
                        this.totalCharsSoFar = -1;
                    } else {
                        this.checkForWhiteSpaceInBack();
                        this.totalCharsSoFar = this.totalCharsSoFar - this.positionOfNonWhiteSpaceCharInFront - this.positionOfNonWhiteSpaceCharInBack;
                    }
                }
                return true;
            }
            delimiterIndex = returnValue;
        }
        return false;
    }

    String getClobColumnFromExtFileAsString(String lobLocationStr, int colIndex) throws SQLException {
        try {
            this.initExternalLobFile(lobLocationStr, colIndex);
            if (this.lobLength == -1) {
                return null;
            }
            return this.lobFileHandles[colIndex - 1].getString(this.lobOffset, this.lobLength);
        }
        catch (Exception ex) {
            throw LoadError.unexpectedError(ex);
        }
    }

    Clob getClobColumnFromExtFile(String lobLocationStr, int colIndex) throws SQLException {
        try {
            this.initExternalLobFile(lobLocationStr, colIndex);
            if (this.lobLength == -1) {
                return null;
            }
            return new ImportClob(this.lobFileHandles[colIndex - 1], this.lobOffset, this.lobLength);
        }
        catch (Exception ex) {
            throw LoadError.unexpectedError(ex);
        }
    }

    Blob getBlobColumnFromExtFile(String lobLocationStr, int colIndex) throws SQLException {
        this.initExternalLobFile(lobLocationStr, colIndex);
        if (this.lobLength == -1) {
            return null;
        }
        return new ImportBlob(this.lobFileHandles[colIndex - 1], this.lobOffset, this.lobLength);
    }

    private void initExternalLobFile(String lobLocationStr, int colIndex) throws SQLException {
        int lengthIndex = lobLocationStr.lastIndexOf(".");
        int offsetIndex = lobLocationStr.lastIndexOf(".", lengthIndex - 1);
        this.lobLength = Integer.parseInt(lobLocationStr.substring(lengthIndex + 1, lobLocationStr.length() - 1));
        this.lobOffset = Integer.parseInt(lobLocationStr.substring(offsetIndex + 1, lengthIndex));
        this.lobFileName = lobLocationStr.substring(0, offsetIndex);
        if (this.lobFileHandles[colIndex - 1] == null) {
            try {
                File lobsFile = new File(this.lobFileName);
                if (lobsFile.getParentFile() == null) {
                    lobsFile = new File(new File(this.inputFileName).getParentFile(), this.lobFileName);
                }
                this.lobFileHandles[colIndex - 1] = new ImportLobFile(lobsFile, this.controlFileReader.getDataCodeset());
            }
            catch (Exception ex) {
                throw LoadError.unexpectedError(ex);
            }
        }
    }
}

