/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.agent.feed;

import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.fetcher.FeedFetcher;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.HashMapFeedInfoCache;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.framework.AbstractAgent;
import org.eclipse.smila.connectivity.framework.AgentCriticalException;
import org.eclipse.smila.connectivity.framework.AgentException;
import org.eclipse.smila.connectivity.framework.agent.feed.messages.Attribute;
import org.eclipse.smila.connectivity.framework.agent.feed.messages.Process;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.AgentThreadState;
import org.eclipse.smila.connectivity.framework.util.ConnectivityHashFactory;
import org.eclipse.smila.connectivity.framework.util.ConnectivityIdFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;

public class FeedAgent
extends AbstractAgent {
    private static final long MILLI_SECOND_MULTIPLIER = 1000L;
    private final Log _log = LogFactory.getLog(FeedAgent.class);
    private long _updateInterval;
    private List<String> _feedUrls;
    private Attribute[] _attributes;

    public FeedAgent() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Creating FeedAgent instance");
        }
    }

    public void run() {
        try {
            try {
                Thread.currentThread().setContextClassLoader(SyndFeed.class.getClassLoader());
                FeedFetcherCache feedInfoCache = HashMapFeedInfoCache.getInstance();
                HttpURLFeedFetcher feedFetcher = new HttpURLFeedFetcher(feedInfoCache);
                while (!this.isStopThread()) {
                    try {
                        for (String feedUrl : this._feedUrls) {
                            this.fetch((FeedFetcher)feedFetcher, feedUrl);
                        }
                        Thread.sleep(this._updateInterval);
                    }
                    catch (InterruptedException e) {
                        if (!this._log.isDebugEnabled()) continue;
                        this._log.debug((Object)"FeedAgent thread was interrupted", (Throwable)e);
                    }
                }
            }
            catch (Throwable t) {
                if (this._performanceCounters != null) {
                    this._performanceCounters.addException(t);
                }
                this.getAgentState().setLastError(t);
                this.getAgentState().setState(AgentThreadState.Aborted);
                this._log.error((Object)"Fatal error, aborting", t);
                try {
                    this.stopThread();
                }
                catch (Exception e) {
                    this._log.error((Object)"Error while stopping thread.", (Throwable)e);
                }
            }
        }
        finally {
            try {
                this.stopThread();
            }
            catch (Exception e) {
                this._log.error((Object)"Error while stopping thread.", (Throwable)e);
            }
        }
    }

    protected void initialize() throws AgentException {
        this._updateInterval = ((Process)this.getConfig().getProcess()).getUpdateInterval().longValue() * 1000L;
        this._feedUrls = ((Process)this.getConfig().getProcess()).getFeedUrl();
        DataSourceConnectionConfig.Attributes attributes = this.getConfig().getAttributes();
        List attrs = attributes.getAttribute();
        this._attributes = attrs.toArray(new Attribute[attrs.size()]);
    }

    private void fetch(FeedFetcher feedFetcher, String feedUrl) throws AgentCriticalException {
        try {
            SyndFeed feed = feedFetcher.retrieveFeed(new URL(feedUrl));
            if (feed != null) {
                List entries;
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Fetched feed " + feedUrl));
                }
                if ((entries = feed.getEntries()) != null) {
                    this.getCounterHelper().incrementDeltaIndicesBy((long)entries.size());
                    for (SyndEntryImpl entry : entries) {
                        try {
                            if (entry == null) continue;
                            AnyMap idAttributes = DataFactory.DEFAULT.createAnyMap();
                            AnyMap hashAttributes = DataFactory.DEFAULT.createAnyMap();
                            HashMap<String, byte[]> hashAttachments = new HashMap<String, byte[]>();
                            this.readIdAndHashAttributesAndAttachments(feed, entry, idAttributes, hashAttributes, hashAttachments);
                            String hash = this.createHash(hashAttributes, hashAttachments);
                            Record record = this.createRecord(feed, entry, idAttributes);
                            if (this._log.isTraceEnabled()) {
                                this._log.trace((Object)("created record " + record.getId()));
                            }
                            long recordAttachmentLength = this.getAttachmentsByteLength(record);
                            this.getCounterHelper().incrementAttachmentBytes(recordAttachmentLength);
                            this.getCounterHelper().incrementRecords();
                            this.getControllerCallback().add(this.getSessionId(), this.getConfig().getDeltaIndexing(), record, hash);
                        }
                        catch (AgentException e) {
                            this.getCounterHelper().addException((Throwable)e);
                            this.getAgentState().setLastError((Throwable)e);
                            this._log.error((Object)("Error during creation of record for entry " + entry.getUri() + " of feed " + feedUrl), (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (FetcherException e) {
            this.getCounterHelper().addException((Throwable)e);
            this.getAgentState().setLastError((Throwable)e);
            this._log.error((Object)("HTTP error during fetching of feed " + feedUrl), (Throwable)e);
        }
        catch (FeedException e) {
            this.getCounterHelper().addException((Throwable)e);
            this.getAgentState().setLastError((Throwable)e);
            this._log.error((Object)("Error during fetching of feed " + feedUrl + ". The feed is invalid"), (Throwable)e);
        }
        catch (IOException e) {
            this.getCounterHelper().addException((Throwable)e);
            this.getAgentState().setLastError((Throwable)e);
            this._log.error((Object)("TCP error during fetching of feed " + feedUrl), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            this.getCounterHelper().addException((Throwable)e);
            this.getAgentState().setLastError((Throwable)e);
            this._log.error((Object)("Error during fetching of feed " + feedUrl + ". The URL is invalid"), (Throwable)e);
        }
    }

    private Record createRecord(SyndFeed feed, SyndEntryImpl entry, AnyMap idAttributes) throws AgentException {
        ConnectivityId id = ConnectivityIdFactory.getInstance().createId(this.getConfig().getDataSourceID(), idAttributes);
        Record record = DataFactory.DEFAULT.createRecord();
        record.setId(id.getObjectId());
        record.setSource(id.getDataSourceId());
        this.fillRecord(feed, entry, record);
        return record;
    }

    private String createHash(AnyMap hashAttributes, Map<String, byte[]> hashAttachments) {
        return ConnectivityHashFactory.getInstance().createHash(hashAttributes, hashAttachments);
    }

    private void readIdAndHashAttributesAndAttachments(SyndFeed feed, SyndEntryImpl entry, AnyMap idAttributes, AnyMap hashAttributes, Map<String, byte[]> hashAttachments) throws AgentException {
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attributeDef = attributeArray[n2];
            if (attributeDef.isKeyAttribute() || attributeDef.isHashAttribute()) {
                if (attributeDef.isAttachment()) {
                    byte[] value = this.readAttachment(feed, entry, attributeDef);
                    hashAttachments.put(attributeDef.getName(), value);
                } else {
                    Any any = this.readAttribute(feed, entry, attributeDef);
                    if (any != null) {
                        if (attributeDef.isKeyAttribute()) {
                            idAttributes.put(attributeDef.getName(), any);
                        }
                        if (attributeDef.isHashAttribute()) {
                            hashAttributes.put(attributeDef.getName(), any);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void fillRecord(SyndFeed feed, SyndEntryImpl entry, Record record) throws AgentException {
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attributeDef = attributeArray[n2];
            if (attributeDef.isAttachment()) {
                byte[] value = this.readAttachment(feed, entry, attributeDef);
                record.setAttachment(attributeDef.getName(), value);
            } else {
                Any any = this.readAttribute(feed, entry, attributeDef);
                if (any != null) {
                    record.getMetadata().put(attributeDef.getName(), any);
                }
            }
            ++n2;
        }
    }

    private Any readAttribute(SyndFeed feed, SyndEntryImpl entry, Attribute attributeDef) throws AgentException {
        switch (attributeDef.getFeedAttributes()) {
            case FEED_AUTHORS: {
                return this.getPersons(feed.getAuthors(), feed.getAuthor());
            }
            case FEED_CATEGORIES: {
                return this.getCategories(feed.getCategories());
            }
            case FEED_CONTRIBUTORS: {
                return this.getPersons(feed.getContributors(), null);
            }
            case FEED_COPYRIGHT: {
                return this.getValue(feed.getCopyright());
            }
            case FEED_DESCRIPTION: {
                return this.getValue(feed.getDescription());
            }
            case FEED_ENCODING: {
                return this.getValue(feed.getEncoding());
            }
            case FEED_TYPE: {
                return this.getValue(feed.getFeedType());
            }
            case FEED_IMAGE: {
                return this.getImage(feed.getImage());
            }
            case FEED_LANGUAGE: {
                return this.getValue(feed.getLanguage());
            }
            case FEED_LINKS: {
                return this.getLinks(feed.getLinks(), feed.getLink());
            }
            case FEED_PUBLISH_DATE: {
                return this.getValue(feed.getPublishedDate());
            }
            case FEED_TITLE: {
                return this.getValue(feed.getTitle());
            }
            case FEED_URI: {
                return this.getValue(feed.getUri());
            }
            case AUTHORS: {
                return this.getPersons(entry.getAuthors(), entry.getAuthor());
            }
            case CATEGORIES: {
                return this.getCategories(entry.getCategories());
            }
            case CONTENTS: {
                return this.getContents(entry.getContents());
            }
            case CONTRIBUTORS: {
                return this.getPersons(entry.getContributors(), null);
            }
            case DESCRIPTION: {
                return this.getContent(entry.getDescription());
            }
            case ENCLOSURES: {
                return this.getEnclosures(entry.getEnclosures());
            }
            case LINKS: {
                return this.getLinks(entry.getLinks(), entry.getLink());
            }
            case PUBLISH_DATE: {
                return this.getValue(entry.getPublishedDate());
            }
            case TITLE: {
                return this.getValue(entry.getTitle());
            }
            case URI: {
                return this.getValue(entry.getUri());
            }
            case UPDATE_DATE: {
                return this.getValue(entry.getUpdatedDate());
            }
        }
        throw new RuntimeException("Unknown feed attributes type " + (Object)((Object)attributeDef.getFeedAttributes()));
    }

    private Value getValue(Object object) {
        if (object != null) {
            return DataFactory.DEFAULT.autoConvertValue(object);
        }
        return null;
    }

    private void putValue(AnyMap map, String name, Object object) {
        Value value = this.getValue(object);
        if (value != null) {
            map.put(name, (Any)value);
        }
    }

    private AnyMap getImage(SyndImage feedImage) {
        block3: {
            if (feedImage != null) {
                try {
                    AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
                    this.putValue(anyMap, "Link", feedImage.getLink());
                    this.putValue(anyMap, "Title", feedImage.getTitle());
                    this.putValue(anyMap, "Url", feedImage.getUrl());
                    this.putValue(anyMap, "Description", feedImage.getDescription());
                }
                catch (InvalidValueTypeException e) {
                    if (!this._log.isErrorEnabled()) break block3;
                    this._log.error((Object)"Error while creating AnyMap for image.", (Throwable)e);
                }
            }
        }
        return null;
    }

    private AnySeq getPersons(List<SyndPerson> persons, String fallbackValue) {
        block7: {
            AnySeq anySeq = DataFactory.DEFAULT.createAnySeq();
            if (persons != null && !persons.isEmpty()) {
                for (SyndPerson person : persons) {
                    try {
                        AnyMap personMap = DataFactory.DEFAULT.createAnyMap();
                        this.putValue(personMap, "Email", person.getEmail());
                        this.putValue(personMap, "Name", person.getName());
                        this.putValue(personMap, "Uri", person.getUri());
                        anySeq.add((Object)personMap);
                    }
                    catch (InvalidValueTypeException e) {
                        if (!this._log.isErrorEnabled()) continue;
                        this._log.error((Object)"Error while creating AnyMap for Person ", (Throwable)e);
                    }
                }
                return anySeq;
            }
            if (fallbackValue != null) {
                try {
                    AnyMap personMap = DataFactory.DEFAULT.createAnyMap();
                    this.putValue(personMap, "Name", fallbackValue);
                    anySeq.add((Object)personMap);
                    return anySeq;
                }
                catch (InvalidValueTypeException e) {
                    if (!this._log.isErrorEnabled()) break block7;
                    this._log.error((Object)"Error while creating AnyMap for Person ", (Throwable)e);
                }
            }
        }
        return null;
    }

    private AnySeq getCategories(List<SyndCategory> categories) {
        if (categories != null) {
            AnySeq categoryList = DataFactory.DEFAULT.createAnySeq();
            for (SyndCategory category : categories) {
                try {
                    AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
                    this.putValue(anyMap, "Name", category.getName());
                    this.putValue(anyMap, "TaxanomyUri", category.getTaxonomyUri());
                    categoryList.add((Object)anyMap);
                }
                catch (InvalidValueTypeException e) {
                    if (!this._log.isErrorEnabled()) continue;
                    this._log.error((Object)"Error while creating AnyMap for Category ", (Throwable)e);
                }
            }
            return categoryList;
        }
        return null;
    }

    private AnySeq getEnclosures(List<SyndEnclosure> enclosures) {
        if (enclosures != null) {
            AnySeq enclosureList = DataFactory.DEFAULT.createAnySeq();
            for (SyndEnclosure enclosure : enclosures) {
                try {
                    AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
                    this.putValue(anyMap, "Type", enclosure.getType());
                    this.putValue(anyMap, "Url", enclosure.getUrl());
                    this.putValue(anyMap, "Length", enclosure.getLength());
                    enclosureList.add((Object)anyMap);
                }
                catch (InvalidValueTypeException e) {
                    if (!this._log.isErrorEnabled()) continue;
                    this._log.error((Object)"Error while creating AnyMap for Category ", (Throwable)e);
                }
            }
            return enclosureList;
        }
        return null;
    }

    private AnySeq getLinks(List<SyndLink> links, String fallbackValue) {
        block7: {
            AnySeq anySeq = DataFactory.DEFAULT.createAnySeq();
            if (links != null && !links.isEmpty()) {
                for (SyndLink link : links) {
                    try {
                        AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
                        this.putValue(anyMap, "Href", link.getHref());
                        this.putValue(anyMap, "Hreflang", link.getHreflang());
                        this.putValue(anyMap, "Rel", link.getRel());
                        this.putValue(anyMap, "Title", link.getTitle());
                        this.putValue(anyMap, "Type", link.getType());
                        this.putValue(anyMap, "Length", link.getLength());
                        anySeq.add((Object)anyMap);
                    }
                    catch (InvalidValueTypeException e) {
                        if (!this._log.isErrorEnabled()) continue;
                        this._log.error((Object)"Error while creating AnyMap for Link ", (Throwable)e);
                    }
                }
                return anySeq;
            }
            if (fallbackValue != null) {
                try {
                    AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
                    this.putValue(anyMap, "Href", fallbackValue);
                    anySeq.add((Object)anyMap);
                    return anySeq;
                }
                catch (InvalidValueTypeException e) {
                    if (!this._log.isErrorEnabled()) break block7;
                    this._log.error((Object)"Error while creating AnyMap for Person ", (Throwable)e);
                }
            }
        }
        return null;
    }

    private AnySeq getContents(List<SyndContent> contents) {
        if (contents != null) {
            AnySeq anySeq = DataFactory.DEFAULT.createAnySeq();
            for (SyndContent content : contents) {
                AnyMap anyMap = this.getContent(content);
                if (anyMap == null) continue;
                anySeq.add((Object)anyMap);
            }
            return anySeq;
        }
        return null;
    }

    private AnyMap getContent(SyndContent content) {
        block10: {
            if (content != null) {
                try {
                    String type;
                    AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
                    if (content.getMode() != null) {
                        this.putValue(anyMap, "Mode", content.getMode());
                    }
                    if (content.getValue() != null) {
                        this.putValue(anyMap, "Value", content.getValue());
                    }
                    if ("html".equals(type = content.getType())) {
                        type = "text/html";
                    } else if ("xml".equals(type)) {
                        type = "text/xml";
                    } else if ("text".equals(type)) {
                        type = "text/Plain";
                    }
                    this.putValue(anyMap, "Type", type);
                    return anyMap;
                }
                catch (InvalidValueTypeException e) {
                    if (!this._log.isErrorEnabled()) break block10;
                    this._log.error((Object)"Error while creating AnyMap for Content ", (Throwable)e);
                }
            }
        }
        return null;
    }

    private byte[] readAttachment(SyndFeed feed, SyndEntryImpl entry, Attribute attribute) throws AgentException {
        Any value = this.readAttribute(feed, entry, attribute);
        if (value != null) {
            if (value.isString()) {
                try {
                    return ((Value)value).asString().getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new AgentException((Throwable)e);
                }
            }
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("The value type " + value.getValueType() + " of attribute " + attribute.getName() + " cannot be used for attachments."));
            }
        }
        return null;
    }
}

