/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import javax.wsdl.Operation;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.PartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.rapi.PartnerLinkModel;

public class ReliablePartnerRoleMessageExchangeImpl
extends PartnerRoleMessageExchangeImpl {
    public ReliablePartnerRoleMessageExchangeImpl(ODEProcess oDEProcess, long l, String string, PartnerLinkModel partnerLinkModel, Operation operation, EndpointReference endpointReference, EndpointReference endpointReference2, PartnerRoleChannel partnerRoleChannel) {
        super(oDEProcess, l, string, partnerLinkModel, operation, endpointReference, endpointReference2, partnerRoleChannel);
    }

    protected void checkReplyContextOk() {
        super.checkReplyContextOk();
        if (!this._contexts.isTransacted()) {
            throw new BpelEngineException("Cannot replyXXX from non-transaction context!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyAsync(String string) {
        this._accessLock.lock();
        try {
            this.checkReplyContextOk();
            if (this._state != PartnerRoleMessageExchangeImpl.State.INVOKE_XXX) {
                throw new IllegalStateException("Invalid context for replyAsync(); can only be called during MessageExchangeContext call. ");
            }
            this._foreignKey = string;
        }
        finally {
            this._accessLock.unlock();
        }
    }

    protected void asyncACK() {
        assert (this._contexts.isTransacted()) : "checkReplyContext() should have prevented us from getting here.";
        assert (!this._process.isInMemory()) : "resumeInstance() for reliable in-mem processes makes no sense.";
        MessageExchangeDAO messageExchangeDAO = this.getDAO();
        WorkEvent workEvent = this.generatePartnerResponseWorkEvent(messageExchangeDAO);
        this.save(messageExchangeDAO);
        this._contexts.scheduler.schedulePersistedJob(workEvent.getDetail(), null);
    }

    public InvocationStyle getInvocationStyle() {
        return InvocationStyle.RELIABLE;
    }

    private WorkEvent generatePartnerResponseWorkEvent(MessageExchangeDAO messageExchangeDAO) {
        WorkEvent workEvent = new WorkEvent();
        workEvent.setProcessId(this._process.getPID());
        workEvent.setChannel(messageExchangeDAO.getChannel());
        workEvent.setIID(this._iid);
        workEvent.setMexId(this._mexId);
        workEvent.setType(WorkEvent.Type.PARTNER_RESPONSE);
        return workEvent;
    }
}

