/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.common.ProcessFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.memdao.MessageExchangeDAOImpl;
import org.apache.ode.bpel.memdao.ProcessDaoImpl;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BpelDAOConnectionImpl
implements BpelDAOConnection {
    private static final Log __log = LogFactory.getLog(BpelDAOConnectionImpl.class);
    public static long TIME_TO_LIVE = 120000L;
    private TransactionManager _txm;
    private Map<QName, ProcessDaoImpl> _store;
    private List<BpelEvent> _events = new LinkedList<BpelEvent>();
    private final List<MessageExchangeDAOImpl> _mexList = new LinkedList<MessageExchangeDAOImpl>();
    private final Map<String, MessageExchangeDAOImpl> _mexStore = new HashMap<String, MessageExchangeDAOImpl>();
    private static AtomicLong counter = new AtomicLong(0x3FFFFFFFFFFFFFFFL);
    private static volatile long _lastRemoval = 0L;

    BpelDAOConnectionImpl(Map<QName, ProcessDaoImpl> map, TransactionManager transactionManager) {
        this._store = map;
        this._txm = transactionManager;
    }

    public ProcessDAO getProcess(QName qName) {
        return this._store.get(qName);
    }

    public ProcessDAO createProcess(QName qName, QName qName2, String string, long l) {
        ProcessDaoImpl processDaoImpl = new ProcessDaoImpl(this, this._store, qName, qName2, string, l);
        this._store.put(qName, processDaoImpl);
        return processDaoImpl;
    }

    public ProcessInstanceDAO getInstance(Long l) {
        for (ProcessDaoImpl processDaoImpl : this._store.values()) {
            ProcessInstanceDAO processInstanceDAO = processDaoImpl._instances.get(l);
            if (processInstanceDAO == null) continue;
            return processInstanceDAO;
        }
        return null;
    }

    public Collection<ProcessInstanceDAO> instanceQuery(InstanceFilter instanceFilter) {
        if (instanceFilter.getLimit() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ProcessInstanceDAO> arrayList = new ArrayList<ProcessInstanceDAO>();
        block0: for (ProcessDaoImpl processDaoImpl : this._store.values()) {
            boolean bl = true;
            if (instanceFilter.getNameFilter() != null && !this.equalsOrWildcardMatch(instanceFilter.getNameFilter(), processDaoImpl.getProcessId().getLocalPart())) {
                bl = false;
            }
            if (instanceFilter.getNamespaceFilter() != null && !this.equalsOrWildcardMatch(instanceFilter.getNamespaceFilter(), processDaoImpl.getProcessId().getNamespaceURI())) {
                bl = false;
            }
            if (!bl) continue;
            for (ProcessInstanceDAO processInstanceDAO : processDaoImpl._instances.values()) {
                boolean bl2 = true;
                if (instanceFilter.getStatusFilter() != null) {
                    boolean bl3 = false;
                    for (Short s : instanceFilter.convertFilterState()) {
                        if (processInstanceDAO.getState() != s.byteValue()) continue;
                        bl3 = true;
                    }
                    if (!bl3) {
                        bl2 = false;
                    }
                }
                if (instanceFilter.getStartedDateFilter() != null && !this.dateMatch(instanceFilter.getStartedDateFilter(), processInstanceDAO.getCreateTime(), instanceFilter)) {
                    bl2 = false;
                }
                if (instanceFilter.getLastActiveDateFilter() != null && !this.dateMatch(instanceFilter.getLastActiveDateFilter(), processInstanceDAO.getLastActiveTime(), instanceFilter)) {
                    bl2 = false;
                }
                if (!bl2) continue;
                arrayList.add(processInstanceDAO);
                if (arrayList.size() != instanceFilter.getLimit()) continue;
                break block0;
            }
        }
        if (instanceFilter.getOrders() != null) {
            final List list = instanceFilter.getOrders();
            Collections.sort(arrayList, new Comparator<ProcessInstanceDAO>(){

                @Override
                public int compare(ProcessInstanceDAO processInstanceDAO, ProcessInstanceDAO processInstanceDAO2) {
                    for (String string : list) {
                        int n = BpelDAOConnectionImpl.this.compareInstanceUsingKey(string, processInstanceDAO, processInstanceDAO2);
                        if (n == 0) continue;
                        return n;
                    }
                    return 0;
                }
            });
        }
        return arrayList;
    }

    public void close() {
    }

    public Collection<ProcessDAO> processQuery(ProcessFilter processFilter) {
        throw new UnsupportedOperationException("Can't query process configuration using a transient DAO.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageExchangeDAO createMessageExchange(final String string, char c) {
        MessageExchangeDAOImpl messageExchangeDAOImpl = new MessageExchangeDAOImpl(c, string);
        messageExchangeDAOImpl.createTime = new Date();
        Map<String, MessageExchangeDAOImpl> map = this._mexStore;
        synchronized (map) {
            this._mexStore.put(string, messageExchangeDAOImpl);
            this._mexList.add(messageExchangeDAOImpl);
        }
        this.cleanupDeadWood();
        this.onRollback(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = BpelDAOConnectionImpl.this._mexStore;
                synchronized (map) {
                    MessageExchangeDAOImpl messageExchangeDAOImpl = (MessageExchangeDAOImpl)BpelDAOConnectionImpl.this._mexStore.remove(string);
                    if (messageExchangeDAOImpl != null) {
                        BpelDAOConnectionImpl.this._mexList.remove(messageExchangeDAOImpl);
                    }
                }
            }
        });
        return messageExchangeDAOImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDeadWood() {
        long l = System.currentTimeMillis();
        if (l > _lastRemoval + TIME_TO_LIVE / 4L) {
            _lastRemoval = l;
            Map<String, MessageExchangeDAOImpl> map = this._mexStore;
            synchronized (map) {
                LinkedList<MessageExchangeDAOImpl> linkedList = new LinkedList<MessageExchangeDAOImpl>();
                for (MessageExchangeDAOImpl messageExchangeDAOImpl : this._mexList) {
                    long l2 = messageExchangeDAOImpl._createTime.getTime();
                    if (l - l2 <= TIME_TO_LIVE) break;
                    linkedList.add(messageExchangeDAOImpl);
                }
                this._mexList.removeAll(linkedList);
                this._mexStore.values().removeAll(linkedList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageExchangeDAO getMessageExchange(String string) {
        Map<String, MessageExchangeDAOImpl> map = this._mexStore;
        synchronized (map) {
            return this._mexStore.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMessageExchange(String string) {
        Map<String, MessageExchangeDAOImpl> map = this._mexStore;
        synchronized (map) {
            MessageExchangeDAO messageExchangeDAO = this._mexStore.remove(string);
            if (messageExchangeDAO != null) {
                this._mexList.remove(messageExchangeDAO);
            }
        }
    }

    private int compareInstanceUsingKey(String string, ProcessInstanceDAO processInstanceDAO, ProcessInstanceDAO processInstanceDAO2) {
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        String string4 = string;
        if (string.startsWith("+") || string.startsWith("-")) {
            string4 = string.substring(1, string.length());
            if (string.startsWith("-")) {
                bl = false;
            }
        }
        ProcessDAO processDAO = this.getProcess(processInstanceDAO.getProcess().getProcessId());
        ProcessDAO processDAO2 = this.getProcess(processInstanceDAO2.getProcess().getProcessId());
        if ("pid".equals(string4)) {
            string2 = processDAO.getProcessId().toString();
            string3 = processDAO2.getProcessId().toString();
        } else if ("name".equals(string4)) {
            string2 = processDAO.getProcessId().getLocalPart();
            string3 = processDAO2.getProcessId().getLocalPart();
        } else if ("namespace".equals(string4)) {
            string2 = processDAO.getProcessId().getNamespaceURI();
            string3 = processDAO2.getProcessId().getNamespaceURI();
        } else if ("version".equals(string4)) {
            string2 = "" + processDAO.getVersion();
            string3 = "" + processDAO2.getVersion();
        } else if ("status".equals(string4)) {
            string2 = "" + processInstanceDAO.getState();
            string3 = "" + processInstanceDAO2.getState();
        } else if ("started".equals(string4)) {
            string2 = ISO8601DateParser.format((Date)processInstanceDAO.getCreateTime());
            string3 = ISO8601DateParser.format((Date)processInstanceDAO2.getCreateTime());
        } else if ("last-active".equals(string4)) {
            string2 = ISO8601DateParser.format((Date)processInstanceDAO.getLastActiveTime());
            string3 = ISO8601DateParser.format((Date)processInstanceDAO2.getLastActiveTime());
        }
        if (bl) {
            return string2.compareTo(string3);
        }
        return string3.compareTo(string2);
    }

    private boolean equalsOrWildcardMatch(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string.endsWith("*") && string2.startsWith(string.substring(0, string.length() - 1))) {
            return true;
        }
        return string2.endsWith("*") && string.startsWith(string2.substring(0, string2.length() - 1));
    }

    public boolean dateMatch(List<String> list, Date date, InstanceFilter instanceFilter) {
        boolean bl = true;
        for (String string : list) {
            String string2 = ISO8601DateParser.format((Date)date);
            String string3 = Filter.getDateWithoutOp((String)string);
            if (string.startsWith("=")) {
                if (string2.startsWith(string3)) continue;
                bl = false;
                continue;
            }
            if (string.startsWith("<=")) {
                if (string2.startsWith(string3) || string2.compareTo(string3) <= 0) continue;
                bl = false;
                continue;
            }
            if (string.startsWith(">=")) {
                if (string2.startsWith(string3) || string2.compareTo(string3) >= 0) continue;
                bl = false;
                continue;
            }
            if (string.startsWith("<")) {
                if (string2.compareTo(string3) <= 0) continue;
                bl = false;
                continue;
            }
            if (!string.startsWith(">") || string2.compareTo(string3) >= 0) continue;
            bl = false;
        }
        return bl;
    }

    public ScopeDAO getScope(Long l) {
        for (ProcessDaoImpl processDaoImpl : this._store.values()) {
            for (ProcessInstanceDAO processInstanceDAO : processDaoImpl._instances.values()) {
                if (processInstanceDAO.getScope(l) == null) continue;
                return processInstanceDAO.getScope(l);
            }
        }
        return null;
    }

    public void insertBpelEvent(BpelEvent bpelEvent, ProcessDAO processDAO, ProcessInstanceDAO processInstanceDAO) {
        this._events.add(bpelEvent);
    }

    public List<Date> bpelEventTimelineQuery(InstanceFilter instanceFilter, BpelEventFilter bpelEventFilter) {
        ArrayList<Date> arrayList = new ArrayList<Date>();
        CollectionsX.transform(arrayList, this._events, (UnaryFunction)new UnaryFunction<BpelEvent, Date>(){

            public Date apply(BpelEvent bpelEvent) {
                return bpelEvent.getTimestamp();
            }
        });
        return arrayList;
    }

    public List<BpelEvent> bpelEventQuery(InstanceFilter instanceFilter, BpelEventFilter bpelEventFilter) {
        return this._events;
    }

    public Collection<ProcessInstanceDAO> instanceQuery(String string) {
        throw new UnsupportedOperationException();
    }

    public void defer(final Runnable runnable) {
        try {
            this._txm.getTransaction().registerSynchronization(new Synchronization(){

                public void afterCompletion(int n) {
                }

                public void beforeCompletion() {
                    runnable.run();
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void onRollback(final Runnable runnable) {
        try {
            this._txm.getTransaction().registerSynchronization(new Synchronization(){

                public void afterCompletion(int n) {
                    if (n != 3) {
                        runnable.run();
                    }
                }

                public void beforeCompletion() {
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

