/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.framework.AbstractCrawler;
import org.eclipse.smila.connectivity.framework.CrawlerCallback;
import org.eclipse.smila.connectivity.framework.CrawlerCriticalException;
import org.eclipse.smila.connectivity.framework.CrawlerException;
import org.eclipse.smila.connectivity.framework.DataReference;
import org.eclipse.smila.connectivity.framework.crawler.jdbc.JdbcCrawlerPerformanceAgent;
import org.eclipse.smila.connectivity.framework.crawler.jdbc.messages.Attribute;
import org.eclipse.smila.connectivity.framework.crawler.jdbc.messages.Process;
import org.eclipse.smila.connectivity.framework.crawler.jdbc.util.GroupingRange;
import org.eclipse.smila.connectivity.framework.crawler.jdbc.util.PreparedStatementTypedParameter;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgent;
import org.eclipse.smila.connectivity.framework.performancecounters.CrawlerPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.DataReferenceFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;

public class JdbcCrawler
extends AbstractCrawler {
    public static final String POC_DATA_ROWS_RETRIEVED = "databaseRows";
    private static final String POC_CRAWLING_EXCEPTIONS = "producerExceptions";
    private static final String POC_CRITICAL_CRAWLING_EXCEPTIONS = "producerCriticalExceptions";
    private static final String POC_DATA_REFS_CREATED = "dataRefsCreated";
    private static final String POC_RECORDS_CREATED = "recordsCreated";
    private static final String POC_DATA_REFS_RETRIEVED_BY_CLIENT = "dataRefsRetrievedByClient";
    private static final int INTERNAL_QUEUE_CAPACITY = 12000;
    private static final int RECORD_CACHE_WARNING_THRESHOLD = 48000;
    private static final long QUEUE_POLL_WAITING = 300L;
    private static final long WAIT_FOR_CRAWLING_THREAD_TERMINATION_WHEN_FORCECLOSING = 5000L;
    private static final int MAX_QUEUE_SIZE = 20;
    private static final int HAS_NEXT_ITEM_THREAD_WAIT = 50;
    private final Log _log = LogFactory.getLog(JdbcCrawler.class);
    private final Object _openedMonitor = new Object();
    private boolean _opened;
    private Process _process;
    private String _dataSourceID;
    private HashMap<ConnectivityId, Record> _recordCache;
    private ArrayBlockingQueue<DataReference> _internalQueue;
    private HashMap<String, Integer> _attributeMapping;
    private Connection _connection;
    private PreparedStatement _retrievalStatement;
    private ResultSet _retrievalResultSet;
    private ResultSetMetaData _retrievalResultSetMetaData;
    private Attribute[] _attributes;
    private boolean _isProducerRunning;
    private CrawlingProducerThread _producerThread;
    private CrawlerCriticalException _producerException;
    private boolean _forceClosing;
    private ArrayList<GroupingRange> _groupingRanges;
    private Iterator<GroupingRange> _groupingRangesIterator;
    private GroupingRange _currentGroupingRange;
    private CrawlerPerformanceCounterHelper<JdbcCrawlerPerformanceAgent> _performanceCounters;

    public JdbcCrawler() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Creating new JdbcCrawler instance");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block17: {
            block16: {
                block15: {
                    Object object = this._openedMonitor;
                    synchronized (object) {
                        block14: {
                            this._forceClosing = true;
                            this._opened = false;
                            this._log.info((Object)"Closing JdbcCrawler...");
                            try {
                                this._producerThread.join(5000L);
                            }
                            catch (InterruptedException exception) {
                                if (!this._log.isTraceEnabled()) break block14;
                                this._log.trace((Object)"Encounterd InterruptedException while waiting for the ProducerThread to die.", (Throwable)exception);
                            }
                        }
                        this._isProducerRunning = false;
                        this._producerThread = null;
                    }
                    try {
                        if (this._retrievalResultSet != null) {
                            this._retrievalResultSet.close();
                            this._retrievalResultSet = null;
                        }
                    }
                    catch (SQLException e) {
                        if (!this._log.isErrorEnabled()) break block15;
                        this._log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    if (this._retrievalStatement != null) {
                        this._retrievalStatement.close();
                        this._retrievalStatement = null;
                    }
                }
                catch (SQLException e) {
                    if (!this._log.isErrorEnabled()) break block16;
                    this._log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                if (this._connection != null) {
                    this._connection.close();
                    this._connection = null;
                }
            }
            catch (SQLException e) {
                if (!this._log.isErrorEnabled()) break block17;
                this._log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this._dataSourceID = null;
    }

    private DataReference createDataReference(Object[] data) throws CrawlerCriticalException {
        DataReference dataRef = null;
        Record record = this.createRecord(data);
        AnyMap idAttributes = this.getIdAttributes(record);
        AnyMap hashAttributes = this.getHashAttributes(record);
        dataRef = DataReferenceFactory.getInstance().createDataReference((CrawlerCallback)this, this._dataSourceID, idAttributes, hashAttributes);
        this._recordCache.put(dataRef.getId(), record);
        if (this._recordCache.size() > 48000) {
            this._performanceCounters.increment(POC_RECORDS_CREATED);
        }
        return dataRef;
    }

    private AnyMap getHashAttributes(Record record) {
        AnyMap hashAttributes = DataFactory.DEFAULT.createAnyMap();
        for (Map.Entry entry : record.getMetadata().entrySet()) {
            String attributeName = (String)entry.getKey();
            Attribute[] attributeArray = this._attributes;
            int n = this._attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute processingAttrib = attributeArray[n2];
                if (processingAttrib.getName().equals(attributeName) && processingAttrib.isHashAttribute()) {
                    hashAttributes.put(attributeName, (Any)entry.getValue());
                }
                ++n2;
            }
        }
        return hashAttributes;
    }

    private AnyMap getIdAttributes(Record record) {
        AnyMap idAttributes = DataFactory.DEFAULT.createAnyMap();
        for (Map.Entry entry : record.getMetadata().entrySet()) {
            String attributeName = (String)entry.getKey();
            Attribute[] attributeArray = this._attributes;
            int n = this._attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute processingAttrib = attributeArray[n2];
                if (processingAttrib.getName().equals(attributeName) && processingAttrib.isKeyAttribute()) {
                    idAttributes.put(attributeName, (Any)entry.getValue());
                }
                ++n2;
            }
        }
        return idAttributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Record createRecord(Object[] data) throws CrawlerCriticalException {
        Record record = DataFactory.DEFAULT.createRecord();
        AnyMap metaData = record.getMetadata();
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute.isAttachment()) {
                Object attachmentValue = this.readAttribute(data, attribute);
                if (attachmentValue != null) {
                    byte[] byteValue;
                    if (attachmentValue instanceof String) {
                        try {
                            record.setAttachment(attribute.getName(), ((String)attachmentValue).getBytes("utf-8"));
                        }
                        catch (UnsupportedEncodingException exception) {
                            this._log.warn((Object)"UTF-8 Encoding ist not supported by this VM. (Very unlikely...)", (Throwable)exception);
                        }
                    } else if (attachmentValue instanceof byte[]) {
                        record.setAttachment(attribute.getName(), (byte[])attachmentValue);
                    } else if (attachmentValue instanceof Blob) {
                        Blob blob = (Blob)attachmentValue;
                        byteValue = null;
                        try {
                            byteValue = IOUtils.toByteArray((InputStream)blob.getBinaryStream());
                        }
                        catch (IOException exception) {
                            this._log.error((Object)("Encountered IOException when getting byte[]-Value of BLOB-Stream for attribute [" + attribute.getName() + "]. Assigning null-Value."), (Throwable)exception);
                            byteValue = null;
                        }
                        catch (SQLException exception) {
                            this._log.error((Object)("Encountered SQLException when retrieving BLOB-Stream for attribute [" + attribute.getName() + "]. Assigning null-Value."), (Throwable)exception);
                            byteValue = null;
                        }
                        record.setAttachment(attribute.getName(), byteValue);
                    } else {
                        if (!(attachmentValue instanceof Clob)) throw new IllegalArgumentException("Unsupported Attachment type [" + attachmentValue.getClass().getName() + "]");
                        Clob clob = (Clob)attachmentValue;
                        byteValue = null;
                        try {
                            byteValue = IOUtils.toByteArray((InputStream)clob.getAsciiStream());
                        }
                        catch (IOException exception) {
                            this._log.error((Object)("Encountered IOException when getting byte[]-Value of CLOB-Stream for attribute [" + attribute.getName() + "]. Assigning null-Value."), (Throwable)exception);
                            byteValue = null;
                        }
                        catch (SQLException exception) {
                            this._log.error((Object)("Encountered SQLException when retrieving CLOB-Stream for attribute [" + attribute.getName() + "]. Assigning null-Value."), (Throwable)exception);
                            byteValue = null;
                        }
                        record.setAttachment(attribute.getName(), byteValue);
                    }
                }
            } else {
                Object value = this.readAttribute(data, attribute);
                if (value != null) {
                    if (value instanceof Object[]) {
                        try {
                            AnySeq anySeq = record.getFactory().createAnySeq();
                            Object[] objectArray = (Object[])value;
                            int n3 = objectArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Object object = objectArray[n4];
                                anySeq.add((Object)record.getFactory().autoConvertValue(object));
                                ++n4;
                            }
                            metaData.put(attribute.getName(), (Any)anySeq);
                        }
                        catch (InvalidValueTypeException exception) {
                            this._log.error((Object)("Could not set value of attribute [" + attribute.getName() + "] as LiteralArrayAttribute."), (Throwable)exception);
                        }
                    } else {
                        try {
                            metaData.put(attribute.getName(), (Any)record.getFactory().autoConvertValue(value));
                        }
                        catch (InvalidValueTypeException exception) {
                            this._log.error((Object)("Could not set value of attribute [" + attribute.getName() + "] as SimpleLiteralAttribute."), (Throwable)exception);
                        }
                    }
                }
            }
            ++n2;
        }
        return record;
    }

    public Thread getProducerThread() {
        return this._producerThread;
    }

    private boolean hasNext() throws CrawlerCriticalException {
        block6: {
            try {
                if (this._retrievalResultSet == null) {
                    this.populateRetrievalResultSet();
                }
                if (!this._retrievalResultSet.next()) break block6;
                this._retrievalResultSet.previous();
                return true;
            }
            catch (SQLException e) {
                throw new CrawlerCriticalException("Encounterd SQLException in hasNext()-Procedure", (Throwable)e);
            }
        }
        if (this._groupingRangesIterator != null && this._groupingRangesIterator.hasNext()) {
            this._currentGroupingRange = this._groupingRangesIterator.next();
            this.populateRetrievalResultSet();
            if (this._retrievalResultSet.next()) {
                this._retrievalResultSet.previous();
                return true;
            }
        }
        return false;
    }

    private boolean hasNextItemInQueue() {
        while (this._isProducerRunning && this._internalQueue.isEmpty()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                this._log.trace((Object)"Got interrupted while waiting for queue to fill up in hasNextItemInQueue()-Procedure");
            }
        }
        return !this._internalQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DataSourceConnectionConfig config) throws CrawlerException, CrawlerCriticalException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Initializing JdbcCrawler...");
        }
        Object object = this._openedMonitor;
        synchronized (object) {
            if (this._opened) {
                throw new CrawlerCriticalException("Crawler is already busy. This should not be the case when initializing.");
            }
            this._opened = true;
            this._forceClosing = false;
        }
        this._performanceCounters = new CrawlerPerformanceCounterHelper(config, ((Object)((Object)this)).hashCode(), JdbcCrawlerPerformanceAgent.class);
        this._isProducerRunning = true;
        this._internalQueue = new ArrayBlockingQueue(12000);
        this._dataSourceID = config.getDataSourceID();
        DataSourceConnectionConfig.Attributes attributes = config.getAttributes();
        List attributeList = attributes.getAttribute();
        this._attributes = attributeList.toArray(new Attribute[attributeList.size()]);
        this._process = (Process)config.getProcess();
        this._recordCache = new HashMap();
        this._producerThread = new CrawlingProducerThread();
        this._producerThread.start();
    }

    private void populateAttributeMapping() throws SQLException {
        this._attributeMapping = new HashMap();
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            int i = 1;
            while (i <= this._retrievalResultSetMetaData.getColumnCount()) {
                if (this._retrievalResultSetMetaData.getColumnName(i).trim().equalsIgnoreCase(attribute.getColumnName().trim())) {
                    this._attributeMapping.put(attribute.getName(), i);
                    this._log.debug((Object)("Mapping dataset column with name [" + this._retrievalResultSetMetaData.getColumnName(i) + "] to Attribute with name [" + attribute.getName() + "] which declares SQL-Type [" + attribute.getSqlType() + "] and selects column [" + attribute.getColumnName() + "]"));
                    break;
                }
                ++i;
            }
            ++n2;
        }
        if (this._attributeMapping.size() != this._retrievalResultSetMetaData.getColumnCount() || this._attributeMapping.size() != this._attributes.length) {
            this._log.warn((Object)("Only " + this._attributeMapping.size() + " Attribute-Mappings could be found. " + this._retrievalResultSetMetaData.getColumnCount() + " Resultset-Columns and " + (this._attributes.length - this._attributeMapping.size()) + " Schema-Attributes remain unmapped. Check name and type conformance"));
        }
    }

    private void populateRetrievalResultSet() throws SQLException {
        ResultSet resultSet;
        if (this._retrievalResultSet != null) {
            this._log.info((Object)"Closing Retrieval Resultset for re-population");
            this._retrievalResultSet.close();
            this._retrievalResultSet = null;
        }
        if (this._groupingRanges != null && this._groupingRanges.size() > 0) {
            PreparedStatementTypedParameter[] endValues;
            PreparedStatementTypedParameter[] startValues;
            PreparedStatementTypedParameter[] preparedStatementTypedParameterArray = startValues = this._currentGroupingRange.getStartValues();
            int n = startValues.length;
            int n2 = 0;
            while (n2 < n) {
                PreparedStatementTypedParameter startValue = preparedStatementTypedParameterArray[n2];
                this._log.trace((Object)("Setting Start-Value [" + startValue.toString() + "] as statement parameter"));
                startValue.applyToPreparedStatement(this._retrievalStatement);
                ++n2;
            }
            PreparedStatementTypedParameter[] preparedStatementTypedParameterArray2 = endValues = this._currentGroupingRange.getEndValues();
            int n3 = endValues.length;
            n = 0;
            while (n < n3) {
                PreparedStatementTypedParameter endValue = preparedStatementTypedParameterArray2[n];
                this._log.trace((Object)("Setting End-Value [" + endValue.toString() + "] as statement parameter"));
                endValue.applyToPreparedStatement(this._retrievalStatement);
                ++n;
            }
        }
        this._log.trace((Object)"Executing retrieval statement");
        this._retrievalResultSet = resultSet = this._retrievalStatement.executeQuery();
        this._retrievalResultSetMetaData = this._retrievalResultSet.getMetaData();
        if (this._attributeMapping == null) {
            this.populateAttributeMapping();
        }
    }

    private void prepareConnection() throws CrawlerCriticalException {
        Process.Database database = this._process.getDatabase();
        String driverName = database.getJdbcDriver();
        try {
            Class.forName(database.getJdbcDriver()).newInstance();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Loaded JDBC driver [" + driverName + "]"));
            }
        }
        catch (ClassNotFoundException e) {
            String errorMessage = "Unable to load jdbc driver [" + driverName + "]";
            throw new CrawlerCriticalException(errorMessage, (Throwable)e);
        }
        catch (InstantiationException e) {
            String errorMessage = "Unable to load jdbc driver [" + driverName + "]";
            throw new CrawlerCriticalException(errorMessage, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String errorMessage = "Unable to load jdbc driver [" + driverName + "]";
            throw new CrawlerCriticalException(errorMessage, (Throwable)e);
        }
        try {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Connecting to database [" + database.getConnection() + "]"));
            }
            this._connection = DriverManager.getConnection(database.getConnection(), database.getUser(), database.getPassword());
        }
        catch (SQLException e) {
            String errorMessage = "Failed to connect to database [" + database.getConnection() + "]";
            throw new CrawlerCriticalException(errorMessage, (Throwable)e);
        }
    }

    private void prepareGrouping() throws CrawlerCriticalException {
        Process.Selections.Grouping grouping = this._process.getSelections().getGrouping();
        BigInteger stepping = BigInteger.ONE;
        ResultSet groupingResultSet = null;
        ResultSetMetaData groupingMetaData = null;
        if (grouping != null) {
            this._groupingRanges = new ArrayList();
            String groupingSQL = grouping.getSQL();
            stepping = grouping.getStepping();
            Statement groupingStatement = null;
            try {
                try {
                    groupingStatement = this._connection.createStatement(1004, 1007);
                    this._log.debug((Object)("Executing SQL for grouping preparation: [" + groupingSQL + "]"));
                    groupingResultSet = groupingStatement.executeQuery(groupingSQL);
                    groupingMetaData = groupingResultSet.getMetaData();
                    this._log.debug((Object)("Retrieved groupingResultSet with [" + groupingMetaData.getColumnCount() + "] columns"));
                    int i = 1;
                    while (i <= groupingMetaData.getColumnCount()) {
                        Class<?> columnClass = null;
                        try {
                            columnClass = Class.forName(groupingMetaData.getColumnClassName(i));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this._log.error((Object)("This should never happen: the class[" + groupingMetaData.getColumnClassName(i) + "] for the column " + i + " in the grouping result set could not be resolved"));
                        }
                        if (Number.class.isAssignableFrom(columnClass)) {
                            this._log.debug((Object)("RowNr " + i + " of the grouping result set is of type [" + columnClass.getName() + "], which is derived from [Number]: fine for use in a grouping"));
                        } else if (String.class.equals(columnClass)) {
                            this._log.debug((Object)("RowNr " + i + " of the grouping result set is of type [String]: fine for use in a grouping"));
                        } else {
                            throw new CrawlerCriticalException("RowNr " + i + " of the grouping result set is of type [" + columnClass.getName() + "]: NOT supported as a grouping field");
                        }
                        ++i;
                    }
                    int groupingRecords = 0;
                    PreparedStatementTypedParameter[] startValues = null;
                    PreparedStatementTypedParameter[] endValues = null;
                    PreparedStatementTypedParameter[] finalValues = new PreparedStatementTypedParameter[groupingMetaData.getColumnCount()];
                    while (groupingResultSet.next()) {
                        int i2;
                        if (groupingRecords == 0) {
                            startValues = new PreparedStatementTypedParameter[groupingMetaData.getColumnCount()];
                            i2 = 1;
                            while (i2 <= groupingMetaData.getColumnCount()) {
                                startValues[i2 - 1] = new PreparedStatementTypedParameter(groupingResultSet.getObject(i2), i2 * 2 - 1, groupingMetaData.getColumnType(i2));
                                ++i2;
                            }
                        }
                        if (++groupingRecords == stepping.intValue()) {
                            endValues = new PreparedStatementTypedParameter[groupingMetaData.getColumnCount()];
                            i2 = 1;
                            while (i2 <= groupingMetaData.getColumnCount()) {
                                endValues[i2 - 1] = new PreparedStatementTypedParameter(groupingResultSet.getObject(i2), i2 * 2, groupingMetaData.getColumnType(i2));
                                ++i2;
                            }
                            GroupingRange groupingRange = new GroupingRange(startValues, endValues);
                            this._groupingRanges.add(groupingRange);
                            if (this._log.isTraceEnabled()) {
                                this._log.trace((Object)("Added GroupingRange: [" + groupingRange.toString() + "] to _groupingRanges"));
                            }
                            groupingRecords = 0;
                            continue;
                        }
                        i2 = 1;
                        while (i2 <= groupingMetaData.getColumnCount()) {
                            finalValues[i2 - 1] = new PreparedStatementTypedParameter(groupingResultSet.getObject(i2), i2 * 2, groupingMetaData.getColumnType(i2));
                            ++i2;
                        }
                    }
                    if (groupingRecords != 0 && stepping.intValue() != 1) {
                        GroupingRange finalgroupingRange = new GroupingRange(startValues, finalValues);
                        this._groupingRanges.add(finalgroupingRange);
                        this._log.debug((Object)("Added final GroupingRange [" + finalgroupingRange.toString() + "] to _groupingRanges"));
                    }
                }
                catch (SQLException sQLException) {
                    throw new CrawlerCriticalException("Encountered SQLException while preparing Groupings");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (groupingStatement != null) {
                        groupingStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    this._log.error((Object)"Could not closeGrouping statement");
                }
                try {
                    groupingResultSet.close();
                    this._log.debug((Object)"Closed Grouping Resultset");
                }
                catch (SQLException sQLException) {
                    this._log.error((Object)"Could not close Resultset for Grouping statement");
                }
                throw throwable;
            }
            try {
                if (groupingStatement != null) {
                    groupingStatement.close();
                }
            }
            catch (SQLException sQLException) {
                this._log.error((Object)"Could not closeGrouping statement");
            }
            try {
                groupingResultSet.close();
                this._log.debug((Object)"Closed Grouping Resultset");
            }
            catch (SQLException sQLException) {
                this._log.error((Object)"Could not close Resultset for Grouping statement");
            }
        }
        this._groupingRangesIterator = this._groupingRanges.iterator();
        if (this._groupingRangesIterator.hasNext()) {
            this._currentGroupingRange = this._groupingRangesIterator.next();
        }
        this._log.debug((Object)String.format("Prepared %d grouping ranges based on specified stepping of %d", this._groupingRanges.size(), stepping.intValue()));
    }

    private void prepareRetrievalStatement() throws CrawlerCriticalException {
        String retrievalSql = this._process.getSelections().getSQL();
        retrievalSql = retrievalSql.trim();
        if (this._process.getSelections().getGrouping() != null) {
            this.prepareGrouping();
            this._log.debug((Object)("Transforming SQL passed from index: [" + retrievalSql + "]"));
            Pattern groupingPlaceholderPattern = Pattern.compile("%\\d\\d(min|max)");
            Matcher matcher = groupingPlaceholderPattern.matcher(retrievalSql);
            String transformedSQL = matcher.replaceAll("?");
            this._log.debug((Object)("Using transformed SQL for PreparedStatement: [" + transformedSQL + "]"));
            retrievalSql = transformedSQL;
        }
        try {
            this._retrievalStatement = this._connection.prepareStatement(retrievalSql, 1004, 1007);
        }
        catch (SQLException e) {
            throw new CrawlerCriticalException("Failed to create statement on database connection", (Throwable)e);
        }
    }

    private Object readAttribute(Object[] data, Attribute attribute) throws CrawlerCriticalException {
        if (data == null) {
            throw new CrawlerCriticalException("Could not extract required attribute [" + attribute.getName() + "]. The data Object to read it from was null");
        }
        int index = -1;
        try {
            index = this._attributeMapping.get(attribute.getName());
            return data[index - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CrawlerCriticalException("Could not extract required attribute [" + attribute.getName() + "]");
        }
    }

    private void rethrowProducerExceptions() throws CrawlerCriticalException {
        if (this._producerException != null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"Rethrowing Producer Exceptions");
            }
            throw this._producerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataReference[] getNext() throws CrawlerException, CrawlerCriticalException {
        this.rethrowProducerExceptions();
        while (this.hasNextItemInQueue()) {
            try {
                DataReference dataRef = this._internalQueue.poll(300L, TimeUnit.MILLISECONDS);
                if (dataRef == null) continue;
                Object object = this._openedMonitor;
                synchronized (object) {
                    ArrayList<DataReference> tempList = new ArrayList<DataReference>();
                    tempList.add(dataRef);
                    int size = this._internalQueue.drainTo(tempList, 19);
                    this._performanceCounters.incrementBy(POC_DATA_REFS_RETRIEVED_BY_CLIENT, (long)(size + 1));
                    return tempList.toArray(new DataReference[size + 1]);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable t) {
                this._log.error((Object)"Error occurred in getNext()", t);
                throw new CrawlerCriticalException(t);
            }
        }
        return null;
    }

    public void dispose(ConnectivityId id) {
        this._recordCache.remove(id);
    }

    public byte[] getAttachment(ConnectivityId id, String name) throws CrawlerException, CrawlerCriticalException {
        Record record = this._recordCache.get(id);
        if (record == null) {
            throw new CrawlerException("The requested record with id [" + id + "] was not found in the Crawler's cache");
        }
        return record.getAttachmentAsBytes(name);
    }

    public String[] getAttachmentNames(ConnectivityId id) throws CrawlerException, CrawlerCriticalException {
        Record record = this._recordCache.get(id);
        if (record == null) {
            throw new CrawlerException("The requested record with id [" + id + "] was not found in the Crawler's cache");
        }
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = record.getAttachmentNames();
        while (it.hasNext()) {
            names.add((String)it.next());
        }
        return names.toArray(new String[0]);
    }

    public AnyMap getMetadata(ConnectivityId id) throws CrawlerException, CrawlerCriticalException {
        Record record = this._recordCache.get(id);
        if (record == null) {
            throw new CrawlerException("The requested record with id [" + id + "] was not found in the Crawler's cache");
        }
        return record.getMetadata();
    }

    public CrawlerPerformanceCounterHelper<? extends ConnectivityPerformanceAgent> getCounterHelper() {
        return this._performanceCounters;
    }

    static /* synthetic */ void access$0(JdbcCrawler jdbcCrawler, boolean bl) {
        jdbcCrawler._isProducerRunning = bl;
    }

    static /* synthetic */ boolean access$1(JdbcCrawler jdbcCrawler) {
        return jdbcCrawler._forceClosing;
    }

    static /* synthetic */ Log access$2(JdbcCrawler jdbcCrawler) {
        return jdbcCrawler._log;
    }

    static /* synthetic */ CrawlerCriticalException access$3(JdbcCrawler jdbcCrawler) {
        return jdbcCrawler._producerException;
    }

    static /* synthetic */ void access$4(JdbcCrawler jdbcCrawler) throws CrawlerCriticalException {
        jdbcCrawler.prepareConnection();
    }

    static /* synthetic */ void access$5(JdbcCrawler jdbcCrawler, CrawlerCriticalException crawlerCriticalException) {
        jdbcCrawler._producerException = crawlerCriticalException;
    }

    static /* synthetic */ CrawlerPerformanceCounterHelper access$6(JdbcCrawler jdbcCrawler) {
        return jdbcCrawler._performanceCounters;
    }

    static /* synthetic */ void access$7(JdbcCrawler jdbcCrawler) throws CrawlerCriticalException {
        jdbcCrawler.prepareRetrievalStatement();
    }

    static /* synthetic */ boolean access$8(JdbcCrawler jdbcCrawler) throws CrawlerCriticalException {
        return jdbcCrawler.hasNext();
    }

    static /* synthetic */ ResultSetMetaData access$9(JdbcCrawler jdbcCrawler) {
        return jdbcCrawler._retrievalResultSetMetaData;
    }

    static /* synthetic */ ResultSet access$10(JdbcCrawler jdbcCrawler) {
        return jdbcCrawler._retrievalResultSet;
    }

    static /* synthetic */ DataReference access$11(JdbcCrawler jdbcCrawler, Object[] objectArray) throws CrawlerCriticalException {
        return jdbcCrawler.createDataReference(objectArray);
    }

    static /* synthetic */ Object access$12(JdbcCrawler jdbcCrawler) {
        return jdbcCrawler._openedMonitor;
    }

    static /* synthetic */ ArrayBlockingQueue access$13(JdbcCrawler jdbcCrawler) {
        return jdbcCrawler._internalQueue;
    }

    private class CrawlingProducerThread
    extends Thread {
        private CrawlingProducerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                try {
                    try {
                        JdbcCrawler.access$4(JdbcCrawler.this);
                    }
                    catch (CrawlerCriticalException e) {
                        JdbcCrawler.access$5(JdbcCrawler.this, e);
                        JdbcCrawler.access$6(JdbcCrawler.this).increment("producerCriticalExceptions");
                        JdbcCrawler.access$2(JdbcCrawler.this).error((Object)"Encountered critical Exception in prepareConnection() procedure", (Throwable)e);
                    }
                    try {
                        JdbcCrawler.access$7(JdbcCrawler.this);
                    }
                    catch (CrawlerCriticalException e) {
                        JdbcCrawler.access$5(JdbcCrawler.this, e);
                        JdbcCrawler.access$6(JdbcCrawler.this).increment("producerCriticalExceptions");
                        JdbcCrawler.access$2(JdbcCrawler.this).error((Object)"Encountered critical Exception in prepareRetievalStatement() procedure", (Throwable)e);
                    }
                    if (true) ** GOTO lbl55
                    do {
                        values = new Object[JdbcCrawler.access$9(JdbcCrawler.this).getColumnCount()];
                        JdbcCrawler.access$10(JdbcCrawler.this).next();
                        i = 1;
                        while (i <= values.length) {
                            values[i - 1] = JdbcCrawler.access$10(JdbcCrawler.this).getObject(i);
                            ++i;
                        }
                        JdbcCrawler.access$6(JdbcCrawler.this).increment("databaseRows");
                        waiting = true;
                        dataRef = null;
                        while (waiting) {
                            block41: {
                                if (dataRef == null) {
                                    try {
                                        dataRef = JdbcCrawler.access$11(JdbcCrawler.this, values);
                                        JdbcCrawler.access$6(JdbcCrawler.this).increment("dataRefsCreated");
                                    }
                                    catch (InvalidValueTypeException e) {
                                        JdbcCrawler.access$6(JdbcCrawler.this).increment("producerExceptions");
                                        JdbcCrawler.access$2(JdbcCrawler.this).error((Object)"", (Throwable)e);
                                    }
                                    try {
                                        if (JdbcCrawler.access$2(JdbcCrawler.this).isTraceEnabled()) {
                                            JdbcCrawler.access$2(JdbcCrawler.this).trace((Object)("Putting DataReference [" + dataRef + "] in internal queue"));
                                        }
                                        var4_9 = JdbcCrawler.access$12(JdbcCrawler.this);
                                        synchronized (var4_9) {
                                            JdbcCrawler.access$13(JdbcCrawler.this).put(dataRef);
                                        }
                                    }
                                    catch (InterruptedException v1) {
                                        if (!JdbcCrawler.access$2(JdbcCrawler.this).isTraceEnabled()) break block41;
                                        JdbcCrawler.access$2(JdbcCrawler.this).trace((Object)"Got interrupted...");
                                    }
                                }
                            }
                            waiting = false;
                        }
lbl55:
                        // 3 sources

                        if (JdbcCrawler.access$1(JdbcCrawler.this)) return;
                    } while (JdbcCrawler.access$8(JdbcCrawler.this));
                    return;
                }
                catch (CrawlerCriticalException e) {
                    JdbcCrawler.access$5(JdbcCrawler.this, e);
                    JdbcCrawler.access$6(JdbcCrawler.this).increment("producerCriticalExceptions");
                    JdbcCrawler.access$2(JdbcCrawler.this).error((Object)"Encountered critical Exception in Producer-Thread", (Throwable)e);
                    JdbcCrawler.access$0(JdbcCrawler.this, false);
                    if (JdbcCrawler.access$1(JdbcCrawler.this)) {
                        JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling was terminated by close()-Procedure");
                        return;
                    } else if (JdbcCrawler.access$3(JdbcCrawler.this) != null) {
                        JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling terminated with Exception");
                        return;
                    } else {
                        JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling terminated normally");
                    }
                    return;
                }
                catch (SQLException e) {
                    JdbcCrawler.access$5(JdbcCrawler.this, new CrawlerCriticalException("Encountered SQLException in Producer-Thread", (Throwable)e));
                    JdbcCrawler.access$6(JdbcCrawler.this).increment("producerCriticalExceptions");
                    JdbcCrawler.access$2(JdbcCrawler.this).error((Object)"Encountered SQLException in Producer-Thread", (Throwable)e);
                    JdbcCrawler.access$0(JdbcCrawler.this, false);
                    if (JdbcCrawler.access$1(JdbcCrawler.this)) {
                        JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling was terminated by close()-Procedure");
                        return;
                    } else if (JdbcCrawler.access$3(JdbcCrawler.this) != null) {
                        JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling terminated with Exception");
                        return;
                    } else {
                        JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling terminated normally");
                    }
                    return;
                }
                catch (RuntimeException e) {
                    JdbcCrawler.access$5(JdbcCrawler.this, new CrawlerCriticalException("Encountered RuntimeException in Producer-Thread", (Throwable)e));
                    JdbcCrawler.access$6(JdbcCrawler.this).increment("producerCriticalExceptions");
                    JdbcCrawler.access$2(JdbcCrawler.this).error((Object)"Encountered RuntimeException in ProducerThread", (Throwable)e);
                    {
                        catch (Throwable var5_11) {
                            throw var5_11;
                        }
                    }
                    JdbcCrawler.access$0(JdbcCrawler.this, false);
                    if (JdbcCrawler.access$1(JdbcCrawler.this)) {
                        JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling was terminated by close()-Procedure");
                        return;
                    } else if (JdbcCrawler.access$3(JdbcCrawler.this) != null) {
                        JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling terminated with Exception");
                        return;
                    } else {
                        JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling terminated normally");
                    }
                    return;
                }
            }
            finally {
                JdbcCrawler.access$0(JdbcCrawler.this, false);
                if (JdbcCrawler.access$1(JdbcCrawler.this)) {
                    JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling was terminated by close()-Procedure");
                } else if (JdbcCrawler.access$3(JdbcCrawler.this) != null) {
                    JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling terminated with Exception");
                } else {
                    JdbcCrawler.access$2(JdbcCrawler.this).info((Object)"DbCrawling terminated normally");
                }
            }
        }
    }
}

