/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.hooks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.OdeFault;
import org.apache.ode.axis2.hooks.ODEAxisOperationDispatcher;
import org.apache.ode.axis2.hooks.ODEMessageReceiver;
import org.apache.ode.axis2.util.Axis2UriResolver;
import org.apache.ode.axis2.util.Axis2WSDLLocator;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.utils.AxisUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Element;

public class ODEAxisService {
    private static final Log LOG = LogFactory.getLog(ODEAxisService.class);

    public static AxisService createService(AxisConfiguration axisConfiguration, ProcessConf processConf, QName qName, String string, String string2) throws AxisFault {
        Definition definition = processConf.getDefinitionForService(qName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create AxisService: service=" + qName + " port=" + string + " WSDL=" + definition.getDocumentBaseURI() + " BPEL=" + processConf.getBpelDocument()));
        }
        try {
            Object object2;
            URI uRI = processConf.getBaseURI().resolve(definition.getDocumentBaseURI());
            InputStream inputStream = uRI.toURL().openStream();
            WSDL11ToAxisPatchedBuilder wSDL11ToAxisPatchedBuilder = new WSDL11ToAxisPatchedBuilder(inputStream, qName, string);
            wSDL11ToAxisPatchedBuilder.setBaseUri(uRI.toString());
            wSDL11ToAxisPatchedBuilder.setCustomResolver(new Axis2UriResolver());
            wSDL11ToAxisPatchedBuilder.setCustomWSLD4JResolver(new Axis2WSDLLocator(uRI));
            wSDL11ToAxisPatchedBuilder.setServerSide(true);
            AxisService axisService = wSDL11ToAxisPatchedBuilder.populateService();
            axisService.setParent((AxisDescription)axisConfiguration);
            axisService.setName(string2);
            axisService.setWsdlFound(true);
            axisService.setCustomWsdl(true);
            axisService.setClassLoader(axisConfiguration.getServiceClassLoader());
            URL uRL = null;
            for (Object object2 : processConf.getFiles()) {
                if (((File)object2).getAbsolutePath().indexOf(definition.getDocumentBaseURI()) <= 0) continue;
                uRL = ((File)object2).toURI().toURL();
            }
            if (uRL != null) {
                axisService.setFileName(uRL);
            }
            URL uRL2 = processConf.getBaseURI().resolve(qName.getLocalPart() + ".axis2").toURL();
            LOG.debug((Object)("Looking for Axis2 service configuration file: " + uRL2));
            try {
                AxisUtils.configureService((AxisService)axisService, (URL)uRL2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOG.debug((Object)("Axis2 service configuration not found: " + uRL2));
            }
            catch (IOException iOException) {
                LOG.warn((Object)("Exception while configuring service: " + uRL2), (Throwable)iOException);
            }
            ODEAxisService.declarePartsElements(definition, qName, string2, string);
            object2 = axisService.getOperations();
            ODEMessageReceiver oDEMessageReceiver = new ODEMessageReceiver();
            while (object2.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)object2.next();
                if (axisOperation.getMessageReceiver() != null) continue;
                axisOperation.setMessageReceiver((MessageReceiver)oDEMessageReceiver);
            }
            if (ODEAxisService.isJmsEndpoint(processConf, qName, string)) {
                axisService.addParameter(new Parameter("transport.jms.Destination", (Object)ODEAxisService.extractJMSDestinationName(string2, ODEAxisService.deriveBaseServiceUri(processConf))));
            }
            return axisService;
        }
        catch (Exception exception) {
            throw AxisFault.makeFault((Throwable)exception);
        }
    }

    public static AxisService createService(AxisConfiguration axisConfiguration, QName qName, String string, String string2, Definition definition, MessageReceiver messageReceiver) throws AxisFault {
        WSDL11ToAxisServiceBuilder wSDL11ToAxisServiceBuilder = new WSDL11ToAxisServiceBuilder(definition, qName, string);
        AxisService axisService = wSDL11ToAxisServiceBuilder.populateService();
        axisService.setName(string2);
        axisService.setWsdlFound(true);
        axisService.setClassLoader(axisConfiguration.getServiceClassLoader());
        Iterator iterator = axisService.getOperations();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            if (axisOperation.getMessageReceiver() != null) continue;
            axisOperation.setMessageReceiver(messageReceiver);
        }
        return axisService;
    }

    private static String extractJMSDestinationName(String string, String string2) {
        String string3 = "dynamicQueues/";
        int n = string.indexOf(string3);
        if (n == -1) {
            string3 = "dynamicTopics/";
            n = string.indexOf(string3);
        }
        if (n == -1) {
            string3 = string2 + "/";
            n = string.indexOf(string3);
            return n != -1 ? string.substring(string3.length()) : string;
        }
        return string.substring(n);
    }

    private static String extractEndpointUri(ProcessConf processConf, QName qName, String string) throws AxisFault {
        Definition definition = processConf.getDefinitionForService(qName);
        String string2 = null;
        Service service = definition.getService(qName);
        if (service == null) {
            throw new OdeFault("Unable to find service " + qName + " from service WSDL definition " + definition.getDocumentBaseURI());
        }
        Port port = service.getPort(string);
        if (port == null) {
            throw new OdeFault("Couldn't find port " + string + " in definition " + qName);
        }
        for (Object e : port.getExtensibilityElements()) {
            if (!(e instanceof SOAPAddress)) continue;
            string2 = ((SOAPAddress)e).getLocationURI();
        }
        if (string2 == null) {
            throw new OdeFault("Could not extract any soap:address from service WSDL definition " + qName + " (necessary to establish the process target address)!");
        }
        return string2;
    }

    private static boolean isJmsEndpoint(ProcessConf processConf, QName qName, String string) throws AxisFault {
        String string2 = ODEAxisService.extractEndpointUri(processConf, qName, string);
        return string2.startsWith("jms:");
    }

    public static String extractServiceName(ProcessConf processConf, QName qName, String string) throws AxisFault {
        String string2 = ODEAxisService.parseURLForService(ODEAxisService.extractEndpointUri(processConf, qName, string), ODEAxisService.deriveBaseServiceUri(processConf));
        if (string2 == null) {
            throw new OdeFault("The soap:address used for service WSDL definition " + qName + " and port " + string + " should be of the form http://hostname:port/ode/processes/myProcessEndpointName");
        }
        return string2;
    }

    protected static String parseURLForService(String string, String string2) {
        int n;
        String string3 = "/processes/";
        if (string.startsWith("jms://")) {
            string3 = "jms://";
        }
        if (-1 != (n = string.indexOf(string3))) {
            int n2 = n + string3.length();
            if (string.length() > n2 + 1) {
                String string4 = string.substring(n2);
                int n3 = string4.indexOf(63);
                if (n3 > 0) {
                    string4 = string4.substring(0, n3);
                }
                if (string.startsWith("jms")) {
                    boolean bl = string2.endsWith("/") || string4.startsWith("/");
                    string4 = string2 + (bl ? "" : "/") + string4;
                }
                return string4;
            }
        }
        return null;
    }

    public static String deriveBaseServiceUri(ProcessConf processConf) {
        if (processConf != null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = processConf.getPackage();
            if (string != null) {
                stringBuffer.append(string).append("/");
                if (processConf.getBpelDocument() != null) {
                    String string2;
                    String string3 = processConf.getBpelDocument();
                    if (string3.indexOf(".") > 0) {
                        string3 = string3.substring(0, string3.indexOf("."));
                    }
                    stringBuffer.append(string3).append("/");
                    String string4 = string2 = processConf.getType() != null ? processConf.getType().getLocalPart() : null;
                    if (string2 != null) {
                        stringBuffer.append(string2);
                        return stringBuffer.toString();
                    }
                }
            }
        }
        return null;
    }

    private static void declarePartsElements(Definition definition, QName qName, String string, String string2) {
        List list = definition.getService(qName).getPort(string2).getBinding().getPortType().getOperations();
        for (Object e : list) {
            Part part;
            Operation operation = (Operation)e;
            Collection collection = operation.getInput().getMessage().getParts().values();
            if (collection.size() != 1 || (part = (Part)collection.iterator().next()).getElementName() == null) continue;
            ODEAxisOperationDispatcher.addElmtToOpMapping(string, operation.getName(), part.getElementName().getLocalPart());
        }
    }

    public static class WSDL11ToAxisPatchedBuilder
    extends WSDL11ToAxisServiceBuilder {
        public WSDL11ToAxisPatchedBuilder(InputStream inputStream, QName qName, String string) {
            super(inputStream, qName, string);
        }

        public WSDL11ToAxisPatchedBuilder(Definition definition, QName qName, String string) {
            super(definition, qName, string);
        }

        public WSDL11ToAxisPatchedBuilder(Definition definition, QName qName, String string, boolean bl) {
            super(definition, qName, string, bl);
        }

        public WSDL11ToAxisPatchedBuilder(InputStream inputStream, AxisService axisService) {
            super(inputStream, axisService);
        }

        public WSDL11ToAxisPatchedBuilder(InputStream inputStream) {
            super(inputStream);
        }

        protected XmlSchema getXMLSchema(Element element, String string) {
            XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
            if (string != null) {
                xmlSchemaCollection.setBaseUri(string);
            }
            return xmlSchemaCollection.read(element, string);
        }
    }
}

