/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyConvertException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.ValueFormatHelper;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.ResultDescription;

public class Task {
    public static final String PROPERTY_JOB_NAME = "jobName";
    public static final String PROPERTY_JOB_RUN_ID = "jobRunId";
    public static final String PROPERTY_WORKFLOW_RUN_ID = "workflowRunId";
    public static final String PROPERTY_WORKER_HOST = "workerHost";
    public static final String PROPERTY_RECOVERABLE = "recoverable";
    public static final String PROPERTY_ORIGINAL_QUALIFIER = "originalQualifier";
    public static final String PROPERTY_ORIGINAL_WORKER = "originalWorker";
    public static final String PROPERTY_START_TIME = "startTime";
    public static final String PROPERTY_END_TIME = "endTime";
    public static final String PROPERTY_CREATED_TIME = "createdTime";
    public static final String PROPERY_TASK_AGE = "taskAge";
    public static final String PROPERTY_POSTPONED = "postponed";
    public static final String KEY_TASK_ID = "taskId";
    public static final String KEY_WORKER_NAME = "workerName";
    public static final String KEY_QUALIFIER = "qualifier";
    public static final String KEY_PROPERTIES = "properties";
    public static final String KEY_PARAMETERS = "parameters";
    public static final String KEY_INPUT = "input";
    public static final String KEY_OUTPUT = "output";
    public static final String KEY_RESULT_DESCRIPTION = "resultDescription";
    private final String _taskId;
    private final String _workerName;
    private String _qualifier;
    private final Map<String, String> _properties;
    private final AnyMap _parameters;
    private final Map<String, List<BulkInfo>> _inputBulks;
    private final Map<String, List<BulkInfo>> _outputBulks;
    private final ResultDescription _resultDescription;

    public Task(String taskId, String workerName) {
        this(taskId, workerName, null);
    }

    private Task(String taskId, String workerName, ResultDescription result) {
        this._taskId = taskId;
        this._workerName = workerName;
        this._properties = new LinkedHashMap<String, String>();
        this._parameters = DataFactory.DEFAULT.createAnyMap();
        this._inputBulks = new LinkedHashMap<String, List<BulkInfo>>();
        this._outputBulks = new LinkedHashMap<String, List<BulkInfo>>();
        this._resultDescription = result;
    }

    public Task createRetryTask(String taskId) {
        String originalWorkerName = this.getProperties().remove(PROPERTY_ORIGINAL_WORKER);
        Task newTask = new Task(taskId, originalWorkerName);
        newTask.getProperties().putAll(this.getProperties());
        newTask.getParameters().putAll((Map)this.getParameters());
        newTask.getInputBulks().putAll(this.getInputBulks());
        newTask.getOutputBulks().putAll(this.getOutputBulks());
        newTask.setQualifier(this.getProperties().remove(PROPERTY_ORIGINAL_QUALIFIER));
        newTask.getProperties().remove(PROPERTY_START_TIME);
        newTask.getProperties().remove(PROPERTY_END_TIME);
        newTask.getProperties().remove(PROPERY_TASK_AGE);
        return newTask;
    }

    public Task createFinishTask(ResultDescription result, String finishWorkerName) {
        Task finishTask = new Task(this._taskId, finishWorkerName, result);
        finishTask.getProperties().putAll(this.getProperties());
        finishTask.getParameters().putAll((Map)this.getParameters());
        finishTask.getInputBulks().putAll(this.getInputBulks());
        finishTask.getOutputBulks().putAll(this.getOutputBulks());
        finishTask.getProperties().put(PROPERTY_END_TIME, ValueFormatHelper.getDefaultDateTimeFormat().format(new Date()));
        finishTask.getProperties().put(PROPERTY_ORIGINAL_WORKER, this._workerName);
        if (!StringUtils.isEmpty((String)this._qualifier)) {
            finishTask.getProperties().put(PROPERTY_ORIGINAL_QUALIFIER, this._qualifier);
        }
        return finishTask;
    }

    public static Task fromAny(Any any) throws AnyConvertException {
        if (!(any instanceof AnyMap)) {
            throw new AnyConvertException("Error parsing task from Any object that is no Map.");
        }
        try {
            AnyMap anyTask = (AnyMap)any;
            String taskId = anyTask.getStringValue(KEY_TASK_ID);
            String workerName = anyTask.getStringValue(KEY_WORKER_NAME);
            ResultDescription result = null;
            if (anyTask.get((Object)KEY_RESULT_DESCRIPTION) != null) {
                result = ResultDescription.fromAny(anyTask.getMap(KEY_RESULT_DESCRIPTION));
            }
            Task task = new Task(taskId, workerName, result);
            if (anyTask.containsKey((Object)KEY_QUALIFIER)) {
                task.setQualifier(anyTask.getStringValue(KEY_QUALIFIER));
            }
            Task.parseStrings((Any)anyTask.get((Object)KEY_PROPERTIES), task.getProperties());
            Task.copyAnyMap((Any)anyTask.get((Object)KEY_PARAMETERS), task.getParameters());
            Task.parseBulks((Any)anyTask.get((Object)KEY_INPUT), task.getInputBulks());
            Task.parseBulks((Any)anyTask.get((Object)KEY_OUTPUT), task.getOutputBulks());
            return task;
        }
        catch (Exception ex) {
            throw new AnyConvertException("Error parsing task from Any object", (Throwable)ex);
        }
    }

    private static void parseStrings(Any any, Map<String, String> stringMap) throws Exception {
        if (any != null && any.isMap()) {
            for (String key : ((AnyMap)any).keySet()) {
                String value = ((AnyMap)any).getStringValue(key);
                stringMap.put(key, value);
            }
        }
    }

    private static void copyAnyMap(Any any, AnyMap anyMap) {
        if (any != null && any.isMap()) {
            anyMap.putAll((Map)any.asMap());
        }
    }

    private static void parseBulks(Any any, Map<String, List<BulkInfo>> bulkMap) throws Exception {
        if (any != null && any.isMap()) {
            AnyMap anyMap = (AnyMap)any;
            for (Map.Entry entry : anyMap.entrySet()) {
                String key = (String)entry.getKey();
                ArrayList<BulkInfo> bulkList = new ArrayList<BulkInfo>();
                for (Any bulkAny : (Any)entry.getValue()) {
                    bulkList.add(BulkInfo.fromAny(bulkAny));
                }
                bulkMap.put(key, bulkList);
            }
        }
    }

    public String getTaskId() {
        return this._taskId;
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public String getQualifier() {
        return this._qualifier;
    }

    public void setQualifier(String qualifier) {
        this._qualifier = qualifier;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public AnyMap getParameters() {
        return this._parameters;
    }

    public Map<String, List<BulkInfo>> getInputBulks() {
        return this._inputBulks;
    }

    public Map<String, List<BulkInfo>> getOutputBulks() {
        return this._outputBulks;
    }

    public ResultDescription getResultDescription() {
        return this._resultDescription;
    }

    public void setTaskCreatedProperties() {
        if (!"_finishingTasks".equals(this._workerName) && !this._properties.containsKey(PROPERTY_CREATED_TIME)) {
            this._properties.put(PROPERTY_CREATED_TIME, ValueFormatHelper.getDefaultDateTimeFormat().format(new Date()));
        }
    }

    public void setTaskStartedProperties() {
        if (!"_finishingTasks".equals(this._workerName)) {
            SimpleDateFormat df = ValueFormatHelper.getDefaultDateTimeFormat();
            Date startTime = new Date();
            this._properties.put(PROPERTY_START_TIME, df.format(startTime));
            String createdTimeString = this._properties.get(PROPERTY_CREATED_TIME);
            long taskAge = 0L;
            if (createdTimeString != null) {
                try {
                    Date createdTime = df.parse(createdTimeString);
                    taskAge = startTime.getTime() - createdTime.getTime();
                }
                catch (ParseException parseException) {}
            }
            this._properties.put(PROPERY_TASK_AGE, Long.toString(taskAge));
        }
    }

    public AnyMap toAny() {
        try {
            AnyMap taskAny = DataFactory.DEFAULT.createAnyMap();
            taskAny.put(KEY_TASK_ID, this.getTaskId());
            taskAny.put(KEY_WORKER_NAME, this.getWorkerName());
            if (this.getQualifier() != null) {
                taskAny.put(KEY_QUALIFIER, this.getQualifier());
            }
            if (this.getProperties() != null) {
                taskAny.put(KEY_PROPERTIES, (Any)this.convertStringMap(this.getProperties()));
            }
            if (this.getParameters() != null) {
                taskAny.put(KEY_PARAMETERS, (Any)this.getParameters());
            }
            if (this.getInputBulks() != null) {
                taskAny.put(KEY_INPUT, (Any)this.convertSlotMap(this.getInputBulks()));
            }
            if (this.getOutputBulks() != null) {
                taskAny.put(KEY_OUTPUT, (Any)this.convertSlotMap(this.getOutputBulks()));
            }
            if (this.getResultDescription() != null) {
                taskAny.put(KEY_RESULT_DESCRIPTION, (Any)this.getResultDescription().toAny());
            }
            return taskAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for task " + this.getTaskId(), ex);
        }
    }

    private AnyMap convertSlotMap(Map<String, List<BulkInfo>> slotMap) throws Exception {
        AnyMap slotsAny = DataFactory.DEFAULT.createAnyMap();
        for (Map.Entry<String, List<BulkInfo>> entry : slotMap.entrySet()) {
            String slotName = entry.getKey();
            List<BulkInfo> bulkInfos = entry.getValue();
            AnySeq bulkInfosAny = DataFactory.DEFAULT.createAnySeq();
            for (BulkInfo bulkInfo : bulkInfos) {
                bulkInfosAny.add((Object)bulkInfo.toAny());
            }
            slotsAny.put(slotName, (Any)bulkInfosAny);
        }
        return slotsAny;
    }

    private AnyMap convertStringMap(Map<String, String> stringMap) throws Exception {
        AnyMap mapAny = DataFactory.DEFAULT.createAnyMap();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            mapAny.put(entry.getKey(), entry.getValue());
        }
        return mapAny;
    }

    public String toString() {
        return this.getTaskId();
    }
}

