/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.jobmanager.definitions.BucketDefinition;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;

public class BucketsHandler
extends AJobManagerHandler {
    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        DefinitionPersistence defPersistence = this.getDefinitionPersistence();
        if (this.isGetRequest(method)) {
            HashMap resultMap = new HashMap();
            ArrayList bucketList = new ArrayList();
            for (String bucketName : defPersistence.getBuckets()) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("name", bucketName);
                map.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)bucketName));
                bucketList.add(map);
            }
            resultMap.put("buckets", bucketList);
            return resultMap;
        }
        if (this.isPostRequest(method)) {
            if (inputRecord == null) {
                throw new IllegalArgumentException("Missing input, cannot create buckets from nothing.");
            }
            AnyMap definition = inputRecord.getMetadata();
            Value timestamp = inputRecord.getFactory().createDateTimeValue(new Date());
            definition.put("timestamp", (Any)timestamp);
            definition.remove((Object)"readOnly");
            BucketDefinition createdBucket = BucketDefinition.parseBucket(definition);
            defPersistence.addBucket(createdBucket);
            AnyMap result = DataFactory.DEFAULT.createAnyMap();
            result.put("name", createdBucket.getName());
            result.put("timestamp", (Any)timestamp);
            result.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)createdBucket.getName()).toExternalForm());
            return result;
        }
        return null;
    }

    protected int getSuccessStatus(String method, String requestUri) {
        if ("POST".equals(method)) {
            return 201;
        }
        return super.getSuccessStatus(method, requestUri);
    }

    @Override
    protected boolean isValidMethod(String method, String requestUri) {
        return this.isGetOrPostRequest(method);
    }
}

