/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.jobmanager.JobRunInfo;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.jobmanager.exceptions.JobManagerException;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;

public class JobsHandler
extends AJobManagerHandler {
    public static final String KEY_RETURN_DETAILS = "returnDetails";
    public static final String KEY_LATEST_JOB_RUN = "latestJobRun";

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        DefinitionPersistence defPersistence = this.getDefinitionPersistence();
        if (this.isGetRequest(method)) {
            AnyMap resultMap = DataFactory.DEFAULT.createAnyMap();
            AnySeq jobList = DataFactory.DEFAULT.createAnySeq();
            boolean showDetails = inputRecord != null && inputRecord.getMetadata().containsKey((Object)KEY_RETURN_DETAILS) ? inputRecord.getMetadata().getBooleanValue(KEY_RETURN_DETAILS) : true;
            for (String jobName : defPersistence.getJobs()) {
                AnyMap jobDetails;
                AnyMap map = DataFactory.DEFAULT.createAnyMap();
                map.put("name", jobName);
                map.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)jobName).toString());
                if (showDetails && !(jobDetails = this.getJobDetails(jobName, requestUri)).isEmpty()) {
                    map.put(KEY_LATEST_JOB_RUN, (Any)jobDetails);
                }
                jobList.add((Object)map);
            }
            resultMap.put("jobs", (Any)jobList);
            return resultMap;
        }
        if (this.isPostRequest(method)) {
            if (inputRecord == null) {
                throw new IllegalArgumentException("Missing input, cannot create jobs from nothing.");
            }
            AnyMap definition = inputRecord.getMetadata();
            Value timestamp = inputRecord.getFactory().createDateTimeValue(new Date());
            definition.put("timestamp", (Any)timestamp);
            definition.remove((Object)"readOnly");
            JobDefinition createdJob = JobDefinition.parseJob(definition);
            defPersistence.addJob(createdJob);
            AnyMap result = DataFactory.DEFAULT.createAnyMap();
            result.put("name", createdJob.getName());
            result.put("timestamp", (Any)timestamp);
            result.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)createdJob.getName()).toExternalForm());
            return result;
        }
        return null;
    }

    private AnyMap getJobDetails(String jobName, String requestUri) throws JobManagerException, MalformedURLException {
        AnyMap map = DataFactory.DEFAULT.createAnyMap();
        JobRunInfo currentRun = this.getJobRunDataProvider().getJobRunInfo(jobName);
        String jobRunId2 = null;
        if (currentRun == null) {
            Collection<String> completedJobRunIds = this.getJobRunDataProvider().getCompletedJobRunIds(jobName);
            if (!completedJobRunIds.isEmpty()) {
                for (String jobRunId2 : completedJobRunIds) {
                }
            }
        } else {
            jobRunId2 = currentRun.getId();
        }
        if (jobRunId2 != null) {
            AnyMap jobRunData = this.getJobRunDataProvider().getJobRunData(jobName, jobRunId2);
            this.safeCopyValues(jobRunData, map, Arrays.asList("mode", "state", "startTime", "endTime"));
            if (jobRunData.containsKey((Object)"workflowRuns")) {
                AnyMap workflowCounters = jobRunData.getMap("workflowRuns");
                this.safeCopyValues(workflowCounters, map, Arrays.asList("successfulWorkflowRunCount", "failedWorkflowRunCount"));
            }
            if (jobRunData.containsKey((Object)"tasks")) {
                AnyMap taskCounters = jobRunData.getMap("tasks");
                this.safeCopyValues(taskCounters, map, Arrays.asList("successfulTaskCount", "failedWithoutRetryTaskCount", "failedAfterRetryTaskCount"));
            }
            map.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)(String.valueOf(jobName) + "/" + jobRunId2)).toString());
        }
        return map;
    }

    private void safeCopyValues(AnyMap sourceMap, AnyMap destinationMap, Collection<String> keys) {
        for (String key : keys) {
            if (!sourceMap.containsKey((Object)key)) continue;
            destinationMap.put(key, (Any)sourceMap.get((Object)key));
        }
    }

    protected int getSuccessStatus(String method, String requestUri) {
        if (this.isPostRequest(method)) {
            return 201;
        }
        return super.getSuccessStatus(method, requestUri);
    }

    @Override
    protected boolean isValidMethod(String method, String requestUri) {
        return this.isGetOrPostRequest(method);
    }
}

