/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.jobmanager.exceptions.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;

public class WorkerHandler
extends AJobManagerHandler {
    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        WorkerDefinition worker;
        DefinitionPersistence defPersistence = this.getDefinitionPersistence();
        String name = this.getName(requestUri);
        boolean returnDetails = false;
        if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)"returnDetails")) {
            returnDetails = inputRecord.getMetadata().getBooleanValue("returnDetails");
        }
        if ((worker = defPersistence.getWorker(name)) == null) {
            throw new ConfigNotFoundException("Worker '" + name + "' not found.");
        }
        return worker.toAny(returnDetails);
    }

    private String getName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }
}

