/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.WorkflowDefinition;
import org.eclipse.smila.jobmanager.exceptions.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;

public class WorkflowHandler
extends AJobManagerHandler {
    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        DefinitionPersistence defPersistence = this.getDefinitionPersistence();
        String workflowName = this.getWorkflowName(requestUri);
        if (this.isGetRequest(method)) {
            WorkflowDefinition workflow;
            boolean returnDetails = false;
            if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)"returnDetails")) {
                returnDetails = inputRecord.getMetadata().getBooleanValue("returnDetails");
            }
            if ((workflow = defPersistence.getWorkflow(workflowName)) == null) {
                throw new ConfigNotFoundException("Workflow '" + workflowName + "' not found.");
            }
            return workflow.toAny(returnDetails);
        }
        if (this.isDeleteRequest(method)) {
            defPersistence.removeWorkflow(workflowName);
        }
        return null;
    }

    private String getWorkflowName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    @Override
    protected boolean isValidMethod(String method, String requestUri) {
        return this.isGetOrDeleteRequest(method);
    }
}

