/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.JobRun;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.definitions.BucketDefinition;
import org.eclipse.smila.jobmanager.definitions.DataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkflowAction;
import org.eclipse.smila.jobmanager.definitions.WorkflowDefinition;
import org.eclipse.smila.jobmanager.exceptions.PersistenceException;
import org.eclipse.smila.jobmanager.persistence.RunStorage;
import org.eclipse.smila.utils.collections.MultiValueMap;

public class JobRunImpl
implements JobRun {
    private final String _jobRunId;
    private final JobDefinition _jobDef;
    private final WorkflowDefinition _workflowDef;
    private WorkflowAction _startAction;
    private final MultiValueMap<String, WorkflowAction> _bucketToTriggeredAction = new MultiValueMap();
    private final Map<String, Bucket> _buckets = new HashMap<String, Bucket>();
    private final Map<WorkflowAction, Map<String, Bucket>> _actionInputBuckets = new HashMap<WorkflowAction, Map<String, Bucket>>();
    private final Map<WorkflowAction, Map<String, Bucket>> _actionOutputBuckets = new HashMap<WorkflowAction, Map<String, Bucket>>();
    private final Map<String, WorkerDefinition> _workers = new HashMap<String, WorkerDefinition>();
    private final AnyMap _parameters = DataFactory.DEFAULT.createAnyMap();
    private final Map<String, BucketDefinition> _bucketDefinitions = new HashMap<String, BucketDefinition>();

    public JobRunImpl(String runId, String jobName, RunStorage runStorage, DefinitionPersistence definitions) throws Exception {
        AnyMap jobRunData = runStorage.getJobRunData(jobName, true);
        AnyMap jobDefinitionMap = jobRunData.getMap("jobDefinition");
        AnyMap workflowDefinitionMap = jobRunData.getMap("workflowDefinition");
        AnySeq bucketsSeq = jobRunData.getSeq("bucketDefinitions");
        if (bucketsSeq != null && bucketsSeq.size() > 0) {
            for (AnyMap bucketsAny : bucketsSeq) {
                this._bucketDefinitions.put(bucketsAny.getStringValue("name"), new BucketDefinition(bucketsAny));
            }
        }
        this._jobRunId = runId;
        this._jobDef = new JobDefinition(jobDefinitionMap);
        this._workflowDef = new WorkflowDefinition(workflowDefinitionMap);
        this.compileWorkflow(definitions);
    }

    private void compileWorkflow(DefinitionPersistence definitions) throws PersistenceException {
        if (this._jobDef.getParameters() != null) {
            this._parameters.putAll((Map)this._jobDef.getParameters());
        }
        if (this._workflowDef.getParameters() != null) {
            this._parameters.putAll((Map)this._workflowDef.getParameters());
        }
        this._startAction = this._workflowDef.getStartAction();
        this.compileWorkflowAction(this._startAction, definitions);
        if (this._workflowDef.getActions() != null) {
            for (WorkflowAction action : this._workflowDef.getActions()) {
                this.compileWorkflowAction(action, definitions);
            }
        }
    }

    private void compileWorkflowAction(WorkflowAction action, DefinitionPersistence definitions) throws PersistenceException {
        String workerName = action.getWorker();
        WorkerDefinition workerDef = this.getWorkerDefinition(definitions, workerName);
        this._actionInputBuckets.put(action, new HashMap());
        this._actionOutputBuckets.put(action, new HashMap());
        Map<String, String> actionInputSlotsDefinition = action.getInput();
        Collection<WorkerDefinition.Input> workerInputSlots = workerDef.getInput();
        this.compileActionSlotConfigurations(action, definitions, actionInputSlotsDefinition, workerInputSlots, true);
        if (actionInputSlotsDefinition != null) {
            for (String bucketName : actionInputSlotsDefinition.values()) {
                this._bucketToTriggeredAction.add((Object)bucketName, (Object)action);
            }
        }
        Map<String, String> actionOutputSlotsDefinition = action.getOutput();
        Collection<WorkerDefinition.Output> workerOutputSlots = workerDef.getOutput();
        this.compileActionSlotConfigurations(action, definitions, actionOutputSlotsDefinition, workerOutputSlots, false);
    }

    private void compileActionSlotConfigurations(WorkflowAction action, DefinitionPersistence definitions, Map<String, String> actionSlots, Collection<? extends WorkerDefinition.InputOutput<?>> workerSlots, boolean isInputSlots) throws PersistenceException {
        if (actionSlots != null) {
            for (Map.Entry<String, String> slot : actionSlots.entrySet()) {
                String slotName = slot.getKey();
                String bucketName = slot.getValue();
                Bucket bucket = this._buckets.get(bucketName);
                if (bucket == null) {
                    BucketDefinition bucketDef = this._bucketDefinitions.get(bucketName);
                    boolean isPersistent = true;
                    if (bucketDef == null) {
                        String slotDataObjectType = this.getSlotType(slotName, workerSlots);
                        isPersistent = false;
                        bucketDef = new BucketDefinition(bucketName, slotDataObjectType);
                    }
                    DataObjectTypeDefinition dot = definitions.getDataObjectType(bucketDef.getDataObjectType());
                    bucket = new Bucket(bucketDef, dot, isPersistent, this._parameters);
                    this._buckets.put(bucketName, bucket);
                }
                if (isInputSlots) {
                    this._actionInputBuckets.get(action).put(slotName, bucket);
                    continue;
                }
                this._actionOutputBuckets.get(action).put(slotName, bucket);
            }
        }
    }

    private String getSlotType(String slotName, Collection<? extends WorkerDefinition.InputOutput<?>> slots) {
        if (slots != null) {
            for (WorkerDefinition.InputOutput<?> iterableElement : slots) {
                if (!iterableElement.getName().equals(slotName)) continue;
                return iterableElement.getType();
            }
        }
        return null;
    }

    private WorkerDefinition getWorkerDefinition(DefinitionPersistence definitions, String workerName) throws PersistenceException {
        WorkerDefinition workerDef = this._workers.get(workerName);
        if (workerDef == null) {
            workerDef = definitions.getWorker(workerName);
            this._workers.put(workerName, workerDef);
        }
        return workerDef;
    }

    @Override
    public String getJobName() {
        return this._jobDef.getName();
    }

    @Override
    public String getJobRunId() {
        return this._jobRunId;
    }

    @Override
    public WorkflowAction getStartAction() {
        return this._startAction;
    }

    @Override
    public AnyMap getParameters() {
        return this._parameters;
    }

    @Override
    public Map<String, Bucket> getInputBucketsForAction(WorkflowAction action) {
        return this._actionInputBuckets.get(action);
    }

    @Override
    public Map<String, Bucket> getOutputBucketsForAction(WorkflowAction action) {
        return this._actionOutputBuckets.get(action);
    }

    @Override
    public Collection<Bucket> getBuckets() {
        return this._buckets.values();
    }

    @Override
    public Bucket getBucket(String bucketName) {
        return this._buckets.get(bucketName);
    }

    @Override
    public boolean isTriggeredBy(Bucket triggeringBucket) {
        if (this._startAction.getInput() != null) {
            for (String inputBucketName : this._startAction.getInput().values()) {
                Bucket inputBucket = this.getBucket(inputBucketName);
                if (!inputBucket.isPersistent() || !triggeringBucket.getBucketId().equals(inputBucket.getBucketId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<WorkflowAction> getTriggeredActionsForBucket(String bucketName) {
        return (Collection)this._bucketToTriggeredAction.get((Object)bucketName);
    }

    @Override
    public Collection<Bucket> getTriggerBuckets() {
        ArrayList<Bucket> startBuckets = new ArrayList<Bucket>();
        if (this._startAction.getInput() != null) {
            for (String inputBucketName : this._startAction.getInput().values()) {
                Bucket inputBucket = this.getBucket(inputBucketName);
                if (!inputBucket.isPersistent()) continue;
                startBuckets.add(inputBucket);
            }
        }
        return startBuckets;
    }
}

