/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.taskgenerator;

import java.util.List;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskworker.input.InputMode;

public abstract class TaskGenerationUtil {
    public static void setAdditionalTaskProperties(List<Task> tasks, String jobName, String jobRunId, String workflowRunId, WorkerDefinition worker) {
        String qualifierSlot = null;
        for (WorkerDefinition.Input input : worker.getInput()) {
            if (!input.getModes().contains(InputMode.QUALIFIER)) continue;
            qualifierSlot = input.getName();
        }
        for (Task task : tasks) {
            List inputBulks;
            task.getProperties().put("workflowRunId", workflowRunId);
            task.getProperties().put("jobRunId", jobRunId);
            task.getProperties().put("jobName", jobName);
            if (qualifierSlot == null || (inputBulks = (List)task.getInputBulks().get(qualifierSlot)) == null || inputBulks.isEmpty()) continue;
            BulkInfo firstBulk = (BulkInfo)inputBulks.get(0);
            task.setQualifier(firstBulk.getObjectName());
        }
    }
}

