/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel.activities;

import org.apache.commons.lang.StringUtils;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.v2.CompilerContext;
import org.apache.ode.bpel.rtrep.v2.OExtensionActivity;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.eclipse.smila.datamodel.xml.DOMRecordReader;
import org.eclipse.smila.processing.bpel.activities.PipeletHolder;
import org.eclipse.smila.processing.bpel.counter.PipeletPerformanceCounter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PipeletActivityValidator {
    private final DOMRecordReader _configParser = new DOMRecordReader();

    public CompilationMessage createErrorCompilationMessage(String key, String message) {
        CompilationMessage msg = new CompilationMessage();
        msg.severity = (short)2;
        msg.phase = 0;
        msg.code = key;
        msg.messageText = message;
        return msg;
    }

    public PipeletHolder validateActivity(OProcess pipelineProcess, OExtensionActivity activity, Element content, String key, CompilerContext compilerContext) {
        PipeletHolder instance = new PipeletHolder(key);
        this.parsePipeletClass(instance, content);
        this.parseVariables(instance, content, compilerContext);
        this.parseConfiguration(instance, content);
        String counterName = String.valueOf(activity.name) + "@" + activity.debugInfo.startLine;
        instance.setCounter(new PipeletPerformanceCounter(pipelineProcess.getName(), instance.getClassName(), counterName));
        return instance;
    }

    private void parsePipeletClass(PipeletHolder instance, Element content) {
        instance.setClassName(this.getAttributeOfElement(content, "pipelet", "class"));
        if (instance.getClassName() == null) {
            throw new CompilationException(this.createErrorCompilationMessage(instance.getKey(), "Missing definition of pipelet class"));
        }
    }

    private void parseVariables(PipeletHolder instance, Element content, CompilerContext compilerContext) {
        String input = this.getAttributeOfElement(content, "variables", "input");
        if (input == null) {
            throw new CompilationException(this.createErrorCompilationMessage(instance.getKey(), "Missing input attribute"));
        }
        this.checkVariableExists(instance, input, compilerContext);
        String output = this.getAttributeOfElement(content, "variables", "output");
        this.checkVariableExists(instance, output, compilerContext);
        String index = this.getAttributeOfElement(content, "variables", "index");
        this.checkVariableExists(instance, index, compilerContext);
        instance.setInputVariable(input);
        instance.setOutputVariable(output);
        instance.setIndexVariable(index);
    }

    private String getAttributeOfElement(Element content, String localName, String attribute) {
        String attributeValue = null;
        NodeList nodes = content.getElementsByTagNameNS("http://www.eclipse.org/smila/processor", localName);
        if (nodes.getLength() > 0 && StringUtils.isBlank((String)(attributeValue = ((Element)nodes.item(0)).getAttribute(attribute)))) {
            attributeValue = null;
        }
        return attributeValue;
    }

    private void checkVariableExists(PipeletHolder instance, String variable, CompilerContext compilerContext) {
        if (variable != null) {
            try {
                compilerContext.resolveVariable(variable);
            }
            catch (Exception exception) {
                throw new CompilationException(this.createErrorCompilationMessage(instance.getKey(), "Variable '" + variable + "' is not defined."));
            }
        }
    }

    private void parseConfiguration(PipeletHolder instance, Element content) {
        NodeList config = content.getElementsByTagNameNS("http://www.eclipse.org/smila/processor", "configuration");
        if (config.getLength() > 0) {
            Element configElement = (Element)config.item(0);
            instance.setConfiguration(this._configParser.parseMap(configElement));
        }
    }
}

