/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.BpelC;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.ode.ODEServer;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.bpel.internal.BpelScanner;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;

public class DeploymentManager {
    private static final String DEPLOY_XML = "deploy.xml";
    private static final String PROCESSOR_WSDL = "processor.wsdl";
    private static final String RECORD_XSD = "record.xsd";
    private static final String DEPLOY_NAME_PLACEHOLDER = "__NAME__";
    private static final String ENDTAG_PROCESS = "  </process>";
    private static final String FORMAT_DEPLOY_INVOKE = "    <invoke partnerLink='%1$s'>\n      <service name='proc:%1$s' port='ProcessorPort' />\n    </invoke>\n";
    private static final String BPEL_EXTENSION = ".bpel";
    private final Log _log = LogFactory.getLog(this.getClass());
    private final Map<String, File> _predefinedWorkflowDirectories = new HashMap<String, File>();
    private final Map<String, File> _customWorkflowDirectories = new HashMap<String, File>();
    private long _deployCount;
    private final BpelC _bpelCompiler = BpelC.newBpelCompiler();
    private final FileFilter _bpelFilter = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return path.getName().endsWith(DeploymentManager.BPEL_EXTENSION) && path.isFile();
        }
    };

    public DeploymentManager() {
        this._bpelCompiler.setDryRun(true);
    }

    public synchronized Collection<QName> deployPredefinedWorkflows(String configurationDirectoryName, ODEServer server) throws ProcessingException, IOException {
        Collection processes;
        File configurationDirectory = ConfigUtils.getConfigFile((String)"org.eclipse.smila.processing.bpel", (String)configurationDirectoryName);
        File deploymentDirectory = this.copyToWorkspace(configurationDirectory);
        try {
            processes = server.deploy(deploymentDirectory);
        }
        catch (RuntimeException ex) {
            throw new ProcessingException("Predefined workflow directory '" + configurationDirectoryName + "' contains invalid definitions, no workflow from this directory will be available.", (Throwable)ex);
        }
        for (QName processName : processes) {
            this._predefinedWorkflowDirectories.put(processName.getLocalPart(), deploymentDirectory);
        }
        return processes;
    }

    private File copyToWorkspace(File configurationDirectory) throws IOException {
        String directoryName = configurationDirectory.getName();
        File workspaceDirectory = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.processing.bpel", (String)directoryName);
        this._log.info((Object)("Predefined workflow deploy directory is " + workspaceDirectory.getAbsolutePath()));
        FileUtils.cleanDirectory((File)workspaceDirectory);
        FileUtils.copyDirectory((File)configurationDirectory, (File)workspaceDirectory, (FileFilter)new NotFileFilter((IOFileFilter)new WildcardFileFilter(".*")));
        this._log.info((Object)"Pipeline configuration directory has been copied to workspace successfully.");
        return workspaceDirectory;
    }

    public synchronized File validateWorkflow(String workflowName, AnyMap workflowDefinition) throws ProcessingException {
        boolean isWorkflowValid = false;
        String bpelDefinition = workflowDefinition.getStringValue("definition");
        if (StringUtils.isEmpty((String)bpelDefinition)) {
            throw new ProcessingException("Workflow '" + workflowName + "' can not be deployed, " + "definition" + " is empty");
        }
        File deploymentDirectory = this.createDeploymentDirectory(workflowName, bpelDefinition);
        try {
            File bpelFile = deploymentDirectory.listFiles(this._bpelFilter)[0];
            this._bpelCompiler.compile(bpelFile);
            isWorkflowValid = true;
            File file = deploymentDirectory;
            return file;
        }
        catch (Exception e) {
            throw new ProcessingException("Error while validating workflow '" + workflowName + "'", (Throwable)e);
        }
        finally {
            if (!isWorkflowValid) {
                this.deleteDeploymentDirectory(workflowName, deploymentDirectory);
            }
        }
    }

    public synchronized QName deployWorkflow(String workflowName, AnyMap workflowDefinition, ODEServer server) throws ProcessingException {
        String bpelDefinition = workflowDefinition.getStringValue("definition");
        File deploymentDirectory = this.createDeploymentDirectory(workflowName, bpelDefinition);
        return this.deployWorkflowDir(workflowName, deploymentDirectory, server);
    }

    public synchronized QName deployWorkflowDir(String workflowName, File deploymentDirectory, ODEServer server) throws ProcessingException {
        Collection processes = null;
        Iterator processIter = null;
        if (this.isCustomWorkflow(workflowName)) {
            File undeploymentDirectory = this._customWorkflowDirectories.get(workflowName);
            try {
                processes = server.redeploy(deploymentDirectory, undeploymentDirectory);
            }
            catch (RuntimeException ex) {
                throw new ProcessingException("Custom workflow '" + workflowName + "' could not be updated.", (Throwable)ex);
            }
            this.deleteDeploymentDirectory(workflowName, undeploymentDirectory);
        } else {
            try {
                processes = server.deploy(deploymentDirectory);
            }
            catch (RuntimeException ex) {
                throw new ProcessingException("Custom workflow '" + workflowName + "' is not valid and could not be deployed .", (Throwable)ex);
            }
        }
        processIter = processes.iterator();
        if (!processIter.hasNext()) {
            throw new ProcessingException("No process was deployed. Check log for reasons.");
        }
        this._customWorkflowDirectories.put(workflowName, deploymentDirectory);
        return (QName)processIter.next();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File createDeploymentDirectory(String workflowName, String bpelDefinition) throws ProcessingException {
        boolean directoryCompleted = false;
        File deploymentDirectory = null;
        try {
            deploymentDirectory = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.processing.bpel", (String)(String.valueOf(workflowName) + "-" + ++this._deployCount));
            this.writeFile(deploymentDirectory, String.valueOf(workflowName) + BPEL_EXTENSION, bpelDefinition);
            this.copyFileToWorkspace(deploymentDirectory, RECORD_XSD);
            this.copyFileToWorkspace(deploymentDirectory, PROCESSOR_WSDL);
            String deployDescriptor = this.createDeployDescriptor(workflowName, bpelDefinition);
            this.writeFile(deploymentDirectory, DEPLOY_XML, deployDescriptor);
            directoryCompleted = true;
            File file = deploymentDirectory;
            if (!directoryCompleted) {
                this.deleteDeploymentDirectory(workflowName, deploymentDirectory);
            }
            return file;
        }
        catch (ProcessingException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new ProcessingException("Failed to create a workspace directory to deploy pipeline '" + workflowName + "'", (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                if (!directoryCompleted) {
                    this.deleteDeploymentDirectory(workflowName, deploymentDirectory);
                }
                throw throwable;
            }
        }
    }

    private void deleteDeploymentDirectory(String workflowName, File deploymentDirectory) {
        if (deploymentDirectory != null) {
            try {
                FileUtils.deleteDirectory((File)deploymentDirectory);
            }
            catch (IOException ex) {
                this._log.warn((Object)("Failed to delete directory '" + deploymentDirectory + "' for workflow '" + workflowName + "', ignoring."), (Throwable)ex);
            }
        }
    }

    private String createDeployDescriptor(String workflowName, String bpelDefinition) throws Exception {
        String deployDescriptorTemplate = this.readConfigFile(DEPLOY_XML);
        String deployDescriptor = deployDescriptorTemplate.replaceAll(DEPLOY_NAME_PLACEHOLDER, workflowName);
        BpelScanner scanner = new BpelScanner(bpelDefinition);
        try {
            while (scanner.findNextInvoke()) {
                if (!"process".equals(scanner.getCurrentOperation()) || !scanner.getCurrentPortType().endsWith("ProcessorPortType")) continue;
                String partnerLink = scanner.getCurrentPartnerLink();
                String deployInvoke = String.format(FORMAT_DEPLOY_INVOKE, partnerLink);
                deployDescriptor = deployDescriptor.replace(ENDTAG_PROCESS, String.valueOf(deployInvoke) + ENDTAG_PROCESS);
            }
        }
        catch (XMLStreamException ex) {
            throw new ProcessingException("Definition of pipeline '" + workflowName + "' is not well-formed XML", (Throwable)ex);
        }
        String processName = scanner.getProcessName();
        if (processName == null) {
            throw new ProcessingException("Name of BPEL process definition not found, this pipeline cannot be deployed.");
        }
        if (!workflowName.equals(processName)) {
            throw new ProcessingException("Name of BPEL process definition is '" + processName + "', not '" + workflowName + "' as expected.");
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Deployment descriptor for '" + workflowName + "': " + deployDescriptor));
        }
        return deployDescriptor;
    }

    private void copyFileToWorkspace(File directory, String filename) throws IOException {
        String fileContent = this.readConfigFile(filename);
        this.writeFile(directory, filename, fileContent);
    }

    private String readConfigFile(String filename) throws IOException {
        return ConfigUtils.getConfigContent((String)"org.eclipse.smila.processing.bpel", (String)("xml/" + filename));
    }

    private void writeFile(File directory, String filename, String fileContent) throws IOException {
        File file = new File(directory, filename);
        FileUtils.writeStringToFile((File)file, (String)fileContent, (String)"utf-8");
    }

    public synchronized QName undeployWorkflow(String workflowName, ODEServer server) throws ProcessingException {
        if (workflowName == null) {
            throw new ProcessingException("Workflow name must not be null.");
        }
        if (this.isPredefinedWorkflow(workflowName)) {
            throw new ProcessingException("Cannot undeploy predefined workflow '" + workflowName + "'");
        }
        File deploymentDirectory = this._customWorkflowDirectories.get(workflowName);
        if (deploymentDirectory != null) {
            Collection processNames;
            try {
                processNames = server.undeploy(deploymentDirectory);
            }
            catch (RuntimeException ex) {
                throw new ProcessingException("Failed to undeploy workflow " + workflowName + " deployed from " + deploymentDirectory, (Throwable)ex);
            }
            try {
                FileUtils.deleteDirectory((File)deploymentDirectory);
            }
            catch (IOException ex) {
                this._log.warn((Object)("Failed to delete directory '" + deploymentDirectory + "' for undeployed workflow '" + workflowName + "', ignoring."), (Throwable)ex);
            }
            this._customWorkflowDirectories.remove(workflowName);
            if (processNames != null && !processNames.isEmpty()) {
                return (QName)processNames.iterator().next();
            }
        }
        return null;
    }

    public boolean isDeployedWorkflow(String workflowName) {
        return this.isPredefinedWorkflow(workflowName) || this.isCustomWorkflow(workflowName);
    }

    public boolean isPredefinedWorkflow(String workflowName) {
        return this._predefinedWorkflowDirectories.containsKey(workflowName);
    }

    public boolean isCustomWorkflow(String workflowName) {
        return this._customWorkflowDirectories.containsKey(workflowName);
    }
}

