/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.crawler.web.Fetcher;
import org.eclipse.smila.importing.crawler.web.WebCrawlerException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class WebFetcherWorker
implements Worker {
    private static final String WORKER_NAME = "webFetcher";
    private static final String INPUT_SLOT = "linksToFetch";
    private static final String OUTPUT_SLOT = "fetchedLinks";
    private final Log _log = LogFactory.getLog(this.getClass());
    private Fetcher _fetcher;

    public String getName() {
        return WORKER_NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        Record record;
        RecordInput recordInput = taskContext.getInputs().getAsRecordInput(INPUT_SLOT);
        RecordOutput recordOutput = taskContext.getOutputs().getAsRecordOutput(OUTPUT_SLOT);
        do {
            if ((record = recordInput.getRecord()) == null) continue;
            if (!record.hasAttachment("http.content")) {
                this.fetchContent(record, taskContext);
            }
            recordOutput.writeRecord(record);
            if (!this._log.isDebugEnabled()) continue;
            this._log.debug((Object)("added record " + record.getId()));
        } while (record != null);
    }

    private void fetchContent(Record record, TaskContext taskContext) throws WebCrawlerException {
        long time = taskContext.getTimestamp();
        try {
            try {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("fetching content for record " + record.getId()));
                }
                this._fetcher.fetch(record, taskContext.getTaskParameters(), taskContext.getLog());
            }
            catch (WebCrawlerException e) {
                taskContext.getLog().warn("Failed to fetch link for record " + record.getId(), (Throwable)((Object)e));
                if (e.isRecoverable()) {
                    throw e;
                }
                taskContext.measureTime("fetchContent", time);
            }
        }
        finally {
            taskContext.measureTime("fetchContent", time);
        }
    }

    public void setFetcher(Fetcher fetcher) {
        this._fetcher = fetcher;
    }

    public void unsetFetcher(Fetcher fetcher) {
        if (this._fetcher == fetcher) {
            this._fetcher = null;
        }
    }
}

