/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.persistence.zk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.taskmanager.ResultDescription;
import org.eclipse.smila.taskmanager.TaskCompletionStatus;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.taskmanager.persistence.TaskStorage;
import org.eclipse.smila.taskmanager.persistence.zk.TaskStorageZk;
import org.eclipse.smila.taskmanager.persistence.zk.ZkTaskQueue;
import org.eclipse.smila.zookeeper.ZkConnection;
import org.eclipse.smila.zookeeper.ZkLock;
import org.eclipse.smila.zookeeper.ZooKeeperService;
import org.osgi.service.component.ComponentContext;

public class TaskWatcher
extends TimerTask {
    private static final long MS_PER_SEC = 1000L;
    private static final long DEFAULT_SLEEPYTIME = 10L;
    private static final long EMPTY_NODE_TTL = 300000L;
    private static final String WATCHER_ZNODE = "/smila/taskmanager/watcher";
    private TaskStorageZk _taskStorage;
    private TaskManager _taskManager;
    private ZooKeeperService _zkService;
    private ClusterConfigService _clusterConfigService;
    private ZkConnection _zk;
    private volatile boolean _stopped;
    private long _lastQueueCleanupTime;
    private final Timer _timer = new Timer("TaskStorageZk-TaskWatcher", true);
    private final Log _log = LogFactory.getLog(this.getClass());

    protected void activate(ComponentContext context) {
        try {
            this._zk = new ZkConnection(this._zkService);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"TaskManager activate() successful");
            }
            long sleepytime = Math.min(10L, this._clusterConfigService.getTimeToLive());
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Checking task storage each " + sleepytime + " seconds, timeToLive is " + this._clusterConfigService.getTimeToLive() + " seconds"));
            }
            long sleepytimeMs = 1000L * sleepytime;
            this._timer.schedule((TimerTask)this, sleepytimeMs, sleepytimeMs);
        }
        catch (Throwable e) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)"Error while starting TaskWatcher for TaskStorageZk.", e);
            }
            throw new RuntimeException("Error while starting TaskWatcher for TaskStorageZk.", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        this.cancel();
        this._timer.cancel();
    }

    @Override
    public void run() {
        block7: {
            try {
                ZkLock lock = this.acquireLock();
                if (lock == null) break block7;
                try {
                    if (!this._stopped) {
                        this.checkInProgressTasks();
                    }
                    if (!this._stopped) {
                        this.checkEmptyNodes();
                    }
                }
                finally {
                    this.releaseLock(lock);
                }
            }
            catch (Exception ex) {
                this._log.warn((Object)"Error during work", (Throwable)ex);
            }
        }
    }

    private ZkLock acquireLock() throws Exception {
        this._zk.ensurePathExists(WATCHER_ZNODE);
        ZkLock zkLock = new ZkLock(this._zk, WATCHER_ZNODE);
        if (zkLock.tryLock()) {
            return zkLock;
        }
        return null;
    }

    private void releaseLock(ZkLock zkLock) {
        if (zkLock != null) {
            zkLock.unlock();
        }
    }

    private void checkInProgressTasks() {
        try {
            long timeToLiveMs = this._clusterConfigService.getTimeToLive() * 1000L;
            ArrayList<ZkTaskQueue> zkTaskQueues = new ArrayList<ZkTaskQueue>(this._taskStorage.getTaskQueues());
            for (ZkTaskQueue zkTaskQueue : zkTaskQueues) {
                if (!this._stopped) {
                    Collection<String> taskIds = zkTaskQueue.getTimedOutTasks(timeToLiveMs);
                    String workerName = zkTaskQueue.getWorkerName();
                    for (String taskId : taskIds) {
                        try {
                            this._log.warn((Object)("Reached timeout for task " + taskId + ", task will be retried"));
                            this._taskManager.finishTask(workerName, taskId, this.createRecoverableErrorResult());
                        }
                        catch (Exception exception) {
                            this._log.warn((Object)("Error rolling back task " + taskId + " for worker " + workerName));
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)"Error during work", (Throwable)ex);
        }
    }

    private ResultDescription createRecoverableErrorResult() {
        return new ResultDescription(TaskCompletionStatus.RECOVERABLE_ERROR, "TimeToLive", "No keepAlive was sent for longer than " + this._clusterConfigService.getTimeToLive() + " seconds.", null);
    }

    private void checkEmptyNodes() {
        long now = System.currentTimeMillis();
        if (now - this._lastQueueCleanupTime > 300000L) {
            block8: {
                try {
                    try {
                        Collection<ZkTaskQueue> zkTaskQueues = this._taskStorage.getTaskQueues();
                        for (ZkTaskQueue zkTaskQueue : zkTaskQueues) {
                            if (!this._stopped) {
                                zkTaskQueue.cleanEmptyNodes(300000L);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception ex) {
                        this._log.warn((Object)"Error during clean up of empty nodes.", (Throwable)ex);
                        this._lastQueueCleanupTime = System.currentTimeMillis();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this._lastQueueCleanupTime = System.currentTimeMillis();
                    throw throwable;
                }
                this._lastQueueCleanupTime = System.currentTimeMillis();
            }
            this._taskStorage.checkQualifierLockAge(300000L);
        }
    }

    @Override
    public synchronized boolean cancel() {
        this._stopped = true;
        return true;
    }

    public void setTaskStorage(TaskStorage taskStorage) {
        if (taskStorage instanceof TaskStorageZk) {
            this._taskStorage = (TaskStorageZk)taskStorage;
        }
    }

    public void unsetTaskStorage(TaskStorage taskStorage) {
        if (taskStorage == this._taskStorage) {
            this._taskStorage = null;
        }
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (taskManager == this._taskManager) {
            this._taskManager = null;
        }
    }

    public void setZooKeeperService(ZooKeeperService zooKeeperService) {
        this._zkService = zooKeeperService;
    }

    public void unsetZooKeeperService(ZooKeeperService zooKeeperService) {
        if (this._zkService == zooKeeperService) {
            this._zkService = null;
        }
    }

    public void setClusterConfigService(ClusterConfigService clusterConfigService) {
        this._clusterConfigService = clusterConfigService;
    }

    public void unsetClusterConfigService(ClusterConfigService clusterConfigService) {
        if (this._clusterConfigService == clusterConfigService) {
            this._clusterConfigService = null;
        }
    }
}

