/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.importing;

import org.eclipse.smila.utils.http.NotFoundHTTPResult;

/** Special case of StateException implementing NotFoundHTTPResult, thrown if source or store are not found. */
public class StateNotFoundException extends StateException implements NotFoundHTTPResult {

  /** cause it's serializable. */
  private static final long serialVersionUID = 1L;

  /** create instance. */
  public StateNotFoundException(final String message, final boolean recoverable) {
    super(message, recoverable);
  }

  /** create instance. */
  public StateNotFoundException(final String message, final Throwable cause, final boolean recoverable) {
    super(message, cause, recoverable);
  }

  /** create instance. */
  public StateNotFoundException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /** create instance. */
  public StateNotFoundException(final String message) {
    super(message);
  }
}
