/*********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.crawler.file;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class FileFetcherWorker implements Worker {

  public static final String NAME = "fileFetcher";

  public static final String INPUT_SLOT = "filesToFetch";

  public static final String OUTPUT_SLOT = "files";

  protected final Log _log = LogFactory.getLog(getClass());

  private final FileToRecordConverter _converter = new FileToRecordConverter(DataFactory.DEFAULT);

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public void perform(final TaskContext taskContext) throws Exception {
    final RecordInput recordInput = taskContext.getInputs().getAsRecordInput(INPUT_SLOT);
    final RecordOutput recordOutput = taskContext.getOutputs().getAsRecordOutput(OUTPUT_SLOT);
    Record record;
    do {
      record = recordInput.getRecord();
      if (record != null) {
        if (_log.isDebugEnabled()) {
          _log.debug("fetching content for record " + record.getId());
        }
        fetch(record, taskContext);
        recordOutput.writeRecord(record);
        if (_log.isDebugEnabled()) {
          _log.debug("added record " + record.getId());
        }
      }
    } while (record != null);
  }

  /** fetch content, if record does not have an attachment. Measure time for fetching as "duration...fetchContent". */
  private void fetch(final Record record, final TaskContext taskContext) throws IOException {
    try {
      if (!record.hasAttachment(FileToRecordConverter.ATTACHMENT_FILE_CONTENT)) {
        final long time = taskContext.getTimestamp();
        _converter.addAttachment(record);
        taskContext.measureTime("fetchContent", time);
      }
    } catch (final IOException e) {
      taskContext.getLog().warn("Failed to fetch file for record " + record.getId(), e);
    }
  }

}
