/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.performancecounters;

import org.eclipse.smila.connectivity.framework.AgentController;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.ManagementAgentNotFoundException;
import org.eclipse.smila.management.ManagementRegistration;

/**
 * The Class CrawlerControllerPerformanceCounterHelper.
 */
public class AgentControllerPerformanceCounterHelper extends
  ConnectivityPerformanceCounterHelperBase<ConnectivityPerformanceAgent> {

  /**
   * Instantiates a new crawler controller performance counter helper.
   * 
   * @param configuration
   *          the configuration
   * @param hashCode
   *          the hash code
   */
  public AgentControllerPerformanceCounterHelper(final DataSourceConnectionConfig configuration, final int hashCode) {
    super(configuration, hashCode, ConnectivityPerformanceAgent.class);
  }

  /** {@inheritDoc} */
  @Override
  protected String getPerformanceAgentLocation() {
    return AgentController.PERFORMANCE_AGENT_LOCATION;
  }

  /** {@inheritDoc} */
  @Override
  protected String getPerformanceAgentCategory() {
    return "Agents";
  }

  /** {@inheritDoc} */
  @Override
  protected String getdateConnectionIdSuffix() {
    return "Agent";
  }

  /**
   * Inits the agent.
   * 
   * @param location
   *          the location
   * 
   * @return the agent type
   */
  @Override
  protected ConnectivityPerformanceAgent initAgent(final ManagementAgentLocation location) {
    synchronized (ManagementRegistration.INSTANCE.getMonitor()) {
      try {
        return (ConnectivityPerformanceAgent) ManagementRegistration.INSTANCE.getAgent(location);
      } catch (final ManagementAgentNotFoundException e) {
        // TODO: tests does not init it correctly
        _log.warn(String.format("Agent location [%s] is not found", location));
        // throw new RuntimeException(e);
        return null;
      } catch (final Throwable e) {
        // TODO: tests does not init it correctly
        _log.warn(String.format("Agent location [%s] is not initialized", location));
        // throw new RuntimeException(e);
        return null;
      }

    }
  }

}
