/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.exceptions;

/**
 * Exception thrown by job manager if a job dependency is not satisfied (e.g. a job should be started but is dependent
 * on a job that is not yet started, etc.).
 */
public class JobDependencyException extends JobManagerException {

  /**
   * Is serializable.
   */
  private static final long serialVersionUID = 1L;

  /** Constructs a new JobDependencyException. */
  public JobDependencyException(final String message, final Throwable cause) {
    super(message, cause, false);
  }

  /** Constructs a new JobDependencyException. */
  public JobDependencyException(final String message) {
    super(message, false);
  }
}
