/**
 * 
 */
package org.eclipse.smila.solr.util;

import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SpellingParams;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.solr.SolrConstants;

/**
 * The SpellCheckQueryConfigAdapter class.
 * 
 * @author pwissel
 * 
 */
public class SpellCheckQueryConfigAdapter {

  /**
   * The internal map.
   */
  private final AnyMap _map = DataFactory.DEFAULT.createAnyMap();

  /**
   * Constructor.
   */
  public SpellCheckQueryConfigAdapter() {
    _map.put(SolrConstants.SPELLCHECK, true);
  }

  /**
   * Get the underlying AnyMap.
   * 
   * @return the AnyMap.
   */
  public AnyMap getAnyMap() {
    return _map;
  }

  /**
   * Set spellcheck.q parameter.
   * 
   * @param query
   *          the query.
   * @return SpellCheckQueryConfigAdapter.
   */
  public SpellCheckQueryConfigAdapter setSpellCheckQuery(String query) {
    _map.put(SpellingParams.SPELLCHECK_Q, query);
    return this;
  }

  /**
   * Set spellcheck.build parameter.
   * 
   * @param value
   *          the value.
   * @return SpellCheckQueryConfigAdapter.
   */
  public SpellCheckQueryConfigAdapter setSpellCheckBuild(Boolean value) {
    _map.put(SpellingParams.SPELLCHECK_BUILD, value);
    return this;
  }

  /**
   * Set spellcheck.reload parameter.
   * 
   * @param value
   *          the value.
   * @return SpellCheckQueryConfigAdapter.
   */
  public SpellCheckQueryConfigAdapter setSpellCheckReload(Boolean value) {
    _map.put(SpellingParams.SPELLCHECK_RELOAD, value);
    return this;
  }

  /**
   * Set spellcheck.dictionary parameter.
   * 
   * @param dictionary
   *          the dictionary.
   * @return SpellCheckQueryConfigAdapter.
   */
  public SpellCheckQueryConfigAdapter setSpellCheckDictionary(String dictionary) {
    _map.put(SpellingParams.SPELLCHECK_DICT, dictionary);
    return this;
  }

  /**
   * Set spellcheck.count parameter.
   * 
   * @param count
   *          the count.
   * @return SpellCheckQueryConfigAdapter.
   */
  public SpellCheckQueryConfigAdapter setSpellCheckCount(int count) {
    _map.put(SpellingParams.SPELLCHECK_COUNT, count);
    return this;
  }

  /**
   * Set spellcheck.onlyMorePopular parameter.
   * 
   * @param value
   *          the value.
   * @return SpellCheckQueryConfigAdapter.
   */
  public SpellCheckQueryConfigAdapter setSpellCheckOnlyMorePopular(Boolean value) {
    _map.put(SpellingParams.SPELLCHECK_ONLY_MORE_POPULAR, value);
    return this;
  }

  /**
   * Set spellcheck.extendedResults parameter.
   * 
   * @param value
   *          the value.
   * @return SpellCheckQueryConfigAdapter.
   */
  public SpellCheckQueryConfigAdapter setSpellCheckExtendedResults(Boolean value) {
    _map.put(SpellingParams.SPELLCHECK_EXTENDED_RESULTS, value);
    return this;
  }

  /**
   * Set spellcheck.collate parameter.
   * 
   * @param value
   *          the value.
   * @return SpellCheckQueryConfigAdapter.
   */
  public SpellCheckQueryConfigAdapter setSpellCheckCollate(Boolean value) {
    _map.put(SpellingParams.SPELLCHECK_COLLATE, value);
    return this;
  }

  /**
   * Set spellcheck request handler (CommonParams.QT e.g. /spell).
   * 
   * @param name
   *          the name as defined in solrconfig.xml.
   * @return SpellCheckQueryConfigAdapter.
   */
  public SpellCheckQueryConfigAdapter setSpellCheckRequestHandler(String name) {
    _map.put(CommonParams.QT, name);
    return this;
  }

}
