/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1.xpath10.jaxp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.v1.EvaluationContext;
import org.apache.ode.bpel.rtrep.v1.OLink;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OXslSheet;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v1.xpath10.XslRuntimeUriResolver;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JaxpFunctionResolver
implements XPathFunctionResolver {
    private static final Log __log = LogFactory.getLog(JaxpFunctionResolver.class);
    private EvaluationContext _ectx;
    private OXPath10Expression _oxpath;

    public JaxpFunctionResolver(EvaluationContext evaluationContext, OXPath10Expression oXPath10Expression) {
        this._ectx = evaluationContext;
        this._oxpath = oXPath10Expression;
    }

    public XPathFunction resolveFunction(QName qName, int n) {
        __log.debug((Object)("JAXP runtime: Resolving function " + qName));
        String string = qName.getNamespaceURI();
        if (string == null) {
            throw new NullPointerException("Undeclared namespace for " + qName);
        }
        if (string.equals("http://schemas.xmlsoap.org/ws/2003/03/business-process/") || string.equals("http://schemas.xmlsoap.org/ws/2004/03/business-process/") || string.equals("http://docs.oasis-open.org/wsbpel/2.0/process/executable")) {
            String string2 = qName.getLocalPart();
            if ("getVariableData".equals(string2)) {
                return new GetVariableData();
            }
            if ("getVariableProperty".equals(string2)) {
                return new GetVariableProperty();
            }
            if ("getLinkStatus".equals(string2)) {
                return new GetLinkStatus();
            }
            if ("doXslTransform".equals(string2)) {
                return new DoXslTransform();
            }
            throw new NullPointerException("Unknown BPEL function: " + qName);
        }
        return null;
    }

    public class DoXslTransform
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            DOMSource dOMSource;
            Object object;
            Element element;
            Object object2;
            if (list.size() < 2 || list.size() % 2 != 0) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "doXslTransformInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
            }
            if (!(JaxpFunctionResolver.this._oxpath instanceof OXPath10ExpressionBPEL20)) {
                throw new IllegalStateException("XPath function bpws:doXslTransform not supported in BPEL 1.1!");
            }
            try {
                if (list.get(1) instanceof List) {
                    object2 = (List)list.get(1);
                    if (object2.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
                    }
                    element = (Element)object2.get(0);
                } else {
                    element = (Element)list.get(1);
                }
            }
            catch (ClassCastException classCastException) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            try {
                object2 = new URI((String)list.get(0));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathFunctionException("First parameter of the bpws:doXslTransform isn't a valid URI!");
            }
            OXslSheet oXslSheet = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.xslSheets.get(object2);
            if (oXslSheet == null) {
                throw new XPathFunctionException("Couldn't find the XSL sheet " + list.get(0) + ", process compilation or deployment was probably incomplete!");
            }
            if (!(element instanceof Element)) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            HashMap<QName, DOMSource> hashMap = null;
            if (list.size() > 2) {
                hashMap = new HashMap<QName, DOMSource>();
                for (int i = 2; i < list.size(); i += 2) {
                    object = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.namespaceCtx.derefQName((String)list.get(i));
                    dOMSource = list.get(i + 1) instanceof List ? ((List)list.get(i + 1)).get(0) : list.get(i + 1);
                    hashMap.put((QName)object, dOMSource);
                }
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Executing XSL sheet " + list.get(0) + " on element " + DOMUtils.domToString((Node)element)));
            }
            Document document = DOMUtils.newDocument();
            document.appendChild(document.importNode(element, true));
            dOMSource = new DOMSource(document);
            XslRuntimeUriResolver xslRuntimeUriResolver = new XslRuntimeUriResolver(JaxpFunctionResolver.this._oxpath, JaxpFunctionResolver.this._ectx.getBaseResourceURI());
            XslTransformHandler.getInstance().cacheXSLSheet(JaxpFunctionResolver.this._ectx.getBaseResourceURI(), (URI)object2, oXslSheet.sheetBody, (URIResolver)xslRuntimeUriResolver);
            try {
                object = XslTransformHandler.getInstance().transform(JaxpFunctionResolver.this._ectx.getBaseResourceURI(), (URI)object2, (Source)dOMSource, hashMap, (URIResolver)xslRuntimeUriResolver);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSubLanguageExecutionFault, exception.toString()));
            }
            if (object instanceof Node) {
                return ((Node)object).getChildNodes();
            }
            return object;
        }
    }

    public class GetVariableProperty
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() != 2) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "getVariablePropertyInvalidSource"), "Missing required arguments"));
            }
            OScope.Variable variable = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.vars.get(list.get(0));
            OProcess.OProperty oProperty = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.properties.get(list.get(1));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("function call:'bpws:getVariableProperty(" + variable + "," + oProperty + ")'"));
            }
            try {
                return JaxpFunctionResolver.this._ectx.readMessageProperty(variable, oProperty);
            }
            catch (FaultException faultException) {
                throw new XPathFunctionException(faultException);
            }
        }
    }

    public class GetVariableData
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + JaxpFunctionResolver.this._ectx + " args=" + list + ")"));
            }
            String string = (String)list.get(0);
            String string2 = list.size() > 1 ? (String)list.get(1) : null;
            String string3 = list.size() > 2 ? (String)list.get(2) : null;
            OXPath10Expression.OSigGetVariableData oSigGetVariableData = JaxpFunctionResolver.this._oxpath.resolveGetVariableDataSig(string, string2, string3);
            if (oSigGetVariableData == null) {
                String string4 = "InternalError: Attempt to use an unknown getVariableData signature: " + list;
                if (__log.isFatalEnabled()) {
                    __log.fatal((Object)string4);
                }
                throw new XPathFunctionException(string4);
            }
            try {
                Node node = JaxpFunctionResolver.this._ectx.readVariable(oSigGetVariableData.variable, oSigGetVariableData.part);
                if (oSigGetVariableData.location != null) {
                    node = JaxpFunctionResolver.this._ectx.evaluateQuery(node, oSigGetVariableData.location);
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("bpws:getVariableData(" + list + ")' = " + node));
                }
                return node;
            }
            catch (FaultException faultException) {
                __log.error((Object)("bpws:getVariableData(" + list + ") threw FaultException"));
                throw new XPathFunctionException(faultException);
            }
        }
    }

    public class GetLinkStatus
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() != 1) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "getLinkStatusInvalidSource"), "Illegal Arguments"));
            }
            OLink oLink = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.links.get(list.get(0));
            try {
                return JaxpFunctionResolver.this._ectx.isLinkActive(oLink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException faultException) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "getLinkStatusInvalidSource"), (Throwable)faultException));
            }
        }
    }
}

