/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableReadEvent;
import org.apache.ode.bpel.rtrep.v2.CorrelationSetInstance;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.OConstantVarType;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OPropertyVarType;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.VariableInstance;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprEvaluationContextImpl
implements EvaluationContext {
    private static final Log __log = LogFactory.getLog(ExprEvaluationContextImpl.class);
    private OdeInternalInstance _native;
    private ScopeFrame _scopeInstance;
    private Map<OLink, Boolean> _linkVals;
    private Node _root;

    public ExprEvaluationContextImpl(ScopeFrame scopeFrame, OdeInternalInstance odeInternalInstance) {
        this._native = odeInternalInstance;
        this._scopeInstance = scopeFrame;
    }

    public ExprEvaluationContextImpl(ScopeFrame scopeFrame, OdeInternalInstance odeInternalInstance, Node node) {
        this(scopeFrame, odeInternalInstance);
        this._root = node;
    }

    public ExprEvaluationContextImpl(ScopeFrame scopeFrame, OdeInternalInstance odeInternalInstance, Map<OLink, Boolean> map) {
        this(scopeFrame, odeInternalInstance);
        this._linkVals = map;
    }

    @Override
    public Node readVariable(OScope.Variable variable, OMessageVarType.Part part) throws FaultException {
        Node node;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("readVariable(" + variable + "," + part + ")"));
        }
        if (variable.type instanceof OConstantVarType) {
            node = ((OConstantVarType)variable.type).getValue();
        } else if (variable.type instanceof OPropertyVarType) {
            CorrelationSetInstance correlationSetInstance = this._scopeInstance.resolve(variable.name);
            CorrelationKey correlationKey = this._native.readCorrelation(correlationSetInstance);
            if (correlationKey == null) {
                return null;
            }
            String string = correlationKey.getValues()[0];
            Document document = DOMUtils.newDocument();
            node = document.createTextNode(string);
        } else {
            VariableInstance variableInstance = this._scopeInstance.resolve(variable);
            if (variableInstance == null) {
                return null;
            }
            VariableReadEvent variableReadEvent = new VariableReadEvent();
            variableReadEvent.setVarName(variableInstance.declaration.name);
            this.sendEvent((ScopeEvent)variableReadEvent);
            node = this._native.fetchVariableData(variableInstance, this._scopeInstance, part, false);
        }
        return node;
    }

    @Override
    public Node evaluateQuery(Node node, OExpression oExpression) throws FaultException {
        return this._native.getExpLangRuntime().evaluateNode(oExpression, new ExprEvaluationContextImpl(this._scopeInstance, this._native, node));
    }

    @Override
    public String readMessageProperty(OScope.Variable variable, OProcess.OProperty oProperty) throws FaultException {
        VariableInstance variableInstance = this._scopeInstance.resolve(variable);
        return this._native.readProperty(variableInstance, oProperty);
    }

    @Override
    public boolean isLinkActive(OLink oLink) throws FaultException {
        return this._linkVals.get(oLink);
    }

    public String toString() {
        return "{ExprEvaluationContextImpl scopeInstance=" + this._scopeInstance + ", activeLinks=" + this._linkVals + "}";
    }

    @Override
    public Node getRootNode() {
        return this._root;
    }

    @Override
    public Node getPartData(Element element, OMessageVarType.Part part) throws FaultException {
        return this._native.getPartData(element, part);
    }

    @Override
    public Long getProcessId() {
        return this._native.getPid();
    }

    @Override
    public boolean narrowTypes() {
        return true;
    }

    private void sendEvent(ScopeEvent scopeEvent) {
        this._scopeInstance.fillEventInfo(scopeEvent);
        this._native.sendEvent(scopeEvent);
    }

    @Override
    public URI getBaseResourceURI() {
        return this._native.getBaseResourceURI();
    }

    @Override
    public Node getPropertyValue(QName qName) {
        return this._native.getProcessProperty(qName);
    }
}

