/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

public abstract class BinaryListOperatorNode
extends ValueNode {
    String methodName;
    String operator;
    String leftInterfaceType;
    String rightInterfaceType;
    ValueNode receiver;
    ValueNode leftOperand;
    ValueNodeList rightOperandList;

    public void init(Object leftOperand, Object rightOperandList, Object operator, Object methodName) {
        this.leftOperand = (ValueNode)leftOperand;
        this.rightOperandList = (ValueNodeList)rightOperandList;
        this.operator = (String)operator;
        this.methodName = (String)methodName;
    }

    public String toString() {
        return "operator: " + this.operator + "\n" + "methodName: " + this.methodName + "\n" + super.toString();
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.rightOperandList != null) {
            this.printLabel(depth, "rightOperandList: ");
            this.rightOperandList.treePrint(depth + 1);
        }
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, aggregateVector);
        this.rightOperandList.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.rightOperandList.containsAllParameterNodes()) {
                throw StandardException.newException("42X35", this.operator);
            }
            this.leftOperand.setType(this.rightOperandList.getTypeServices());
        }
        if (this.rightOperandList.containsParameterNode()) {
            this.rightOperandList.setParameterDescriptor(this.leftOperand.getTypeServices());
        }
        if (this.leftOperand.getTypeId().userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        this.rightOperandList.genSQLJavaSQLTrees();
        this.bindComparisonOperator();
        return this;
    }

    public void bindComparisonOperator() throws StandardException {
        this.rightOperandList.comparable(this.leftOperand);
        boolean nullableResult = this.leftOperand.getTypeServices().isNullable() || this.rightOperandList.isNullable();
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult));
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        this.rightOperandList.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    public void setLeftOperand(ValueNode newLeftOperand) {
        this.leftOperand = newLeftOperand;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperandList(ValueNodeList newRightOperandList) {
        this.rightOperandList = newRightOperandList;
    }

    public ValueNodeList getRightOperandList() {
        return this.rightOperandList;
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        boolean pushable = this.leftOperand.categorize(referencedTabs, simplePredsOnly);
        pushable = this.rightOperandList.categorize(referencedTabs, simplePredsOnly) && pushable;
        return pushable;
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        this.rightOperandList.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperandList.isConstantExpression();
    }

    public boolean constantExpression(PredicateList whereClause) {
        return this.leftOperand.constantExpression(whereClause) && this.rightOperandList.constantExpression(whereClause);
    }

    protected int getOrderableVariantType() throws StandardException {
        int leftType = this.leftOperand.getOrderableVariantType();
        int rightType = this.rightOperandList.getOrderableVariantType();
        return Math.min(leftType, rightType);
    }

    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.leftOperand != null && !v.stopTraversal()) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        if (this.rightOperandList != null && !v.stopTraversal()) {
            this.rightOperandList = (ValueNodeList)this.rightOperandList.accept(v);
        }
        return returnNode;
    }

    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeType(o)) {
            return false;
        }
        BinaryListOperatorNode other = (BinaryListOperatorNode)o;
        if (!this.operator.equals(other.operator) || !this.leftOperand.isEquivalent(other.getLeftOperand())) {
            return false;
        }
        int sz = this.getRightOperandList().size();
        if (sz != other.rightOperandList.size()) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            ValueNode e = (ValueNode)this.rightOperandList.elementAt(i);
            if (e.isEquivalent((ValueNode)other.rightOperandList.elementAt(i))) continue;
            return false;
        }
        return true;
    }
}

