/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;

public class NormalizeResultSetNode
extends SingleChildResultSetNode {
    private boolean forUpdate;

    public void init(Object childResult, Object targetResultColumnList, Object tableProperties, Object forUpdate) throws StandardException {
        super.init(childResult, tableProperties);
        this.forUpdate = (Boolean)forUpdate;
        ResultSetNode rsn = (ResultSetNode)childResult;
        ResultColumnList rcl = rsn.getResultColumns();
        ResultColumnList targetRCL = (ResultColumnList)targetResultColumnList;
        ResultColumnList prRCList = rcl;
        rsn.setResultColumns(rcl.copyListAndObjects());
        prRCList.removeGeneratedGroupingColumns();
        prRCList.genVirtualColumnNodes(rsn, rsn.getResultColumns());
        this.resultColumns = prRCList;
        if (rsn.getReferencedTableMap() != null) {
            this.setReferencedTableMap((JBitSet)this.getReferencedTableMap().clone());
        }
        if (targetResultColumnList != null) {
            int size = Math.min(targetRCL.size(), this.resultColumns.size());
            for (int index = 0; index < size; ++index) {
                ResultColumn sourceRC = (ResultColumn)this.resultColumns.elementAt(index);
                ResultColumn resultColumn = (ResultColumn)targetRCL.elementAt(index);
                sourceRC.setType(resultColumn.getTypeServices());
            }
        }
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.resultColumns != null, "Tree structure bad");
        this.assignResultSetNumber();
        this.costEstimate = this.childResult.getFinalCostEstimate();
        int erdNumber = acb.addItem(this.makeResultDescription());
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        mb.push(this.resultSetNumber);
        mb.push(erdNumber);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.push(this.forUpdate);
        mb.callMethod((short)185, null, "getNormalizeResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 6);
    }

    public void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        this.childResult.setRefActionInfo(fkIndexConglomId, fkColArray, parentResultSetId, dependentScan);
    }
}

