/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.sql.Timestamp;
import java.util.Vector;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;

public final class RunTimeStatisticsImpl
implements RunTimeStatistics {
    public String statementText;
    public String statementName;
    public String spsName;
    public long parseTime;
    public long bindTime;
    public long optimizeTime;
    public long generateTime;
    public long compileTime;
    public long executeTime;
    public Timestamp beginCompilationTimestamp;
    public Timestamp endCompilationTimestamp;
    public Timestamp beginExecutionTimestamp;
    public Timestamp endExecutionTimestamp;
    public ResultSetStatistics topResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public RunTimeStatisticsImpl(String spsName, String statementName, String statementText, long compileTime, long parseTime, long bindTime, long optimizeTime, long generateTime, long executeTime, Timestamp beginCompilationTimestamp, Timestamp endCompilationTimestamp, Timestamp beginExecutionTimestamp, Timestamp endExecutionTimestamp, ResultSetStatistics[] subqueryTrackingArray, ResultSetStatistics topResultSetStatistics) {
        this.spsName = spsName;
        this.statementName = statementName;
        this.statementText = statementText;
        this.compileTime = compileTime;
        this.parseTime = parseTime;
        this.bindTime = bindTime;
        this.optimizeTime = optimizeTime;
        this.generateTime = generateTime;
        this.executeTime = executeTime;
        this.beginCompilationTimestamp = beginCompilationTimestamp;
        this.endCompilationTimestamp = endCompilationTimestamp;
        this.beginExecutionTimestamp = beginExecutionTimestamp;
        this.endExecutionTimestamp = endExecutionTimestamp;
        this.subqueryTrackingArray = subqueryTrackingArray;
        this.topResultSetStatistics = topResultSetStatistics;
    }

    public long getCompileTimeInMillis() {
        return this.compileTime;
    }

    public long getParseTimeInMillis() {
        return this.parseTime;
    }

    public long getBindTimeInMillis() {
        return this.bindTime;
    }

    public long getOptimizeTimeInMillis() {
        return this.optimizeTime;
    }

    public long getGenerateTimeInMillis() {
        return this.generateTime;
    }

    public long getExecuteTimeInMillis() {
        return this.executeTime;
    }

    public Timestamp getBeginCompilationTimestamp() {
        return this.beginCompilationTimestamp;
    }

    public Timestamp getEndCompilationTimestamp() {
        return this.endCompilationTimestamp;
    }

    public Timestamp getBeginExecutionTimestamp() {
        return this.beginExecutionTimestamp;
    }

    public Timestamp getEndExecutionTimestamp() {
        return this.endExecutionTimestamp;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public String getSPSName() {
        return this.spsName;
    }

    public String getStatementText() {
        return this.statementText;
    }

    public double getEstimatedRowCount() {
        if (this.topResultSetStatistics == null) {
            return 0.0;
        }
        return this.topResultSetStatistics.getEstimatedRowCount();
    }

    public String getStatementExecutionPlanText() {
        if (this.topResultSetStatistics == null) {
            return null;
        }
        String subqueryInfo = "";
        if (this.subqueryTrackingArray != null) {
            boolean foundAttached = false;
            for (int index = 0; index < this.subqueryTrackingArray.length; ++index) {
                if (this.subqueryTrackingArray[index] == null) continue;
                if (!foundAttached) {
                    subqueryInfo = MessageService.getTextMessage("43Y21.U") + ":\n";
                    foundAttached = true;
                }
                subqueryInfo = subqueryInfo + this.subqueryTrackingArray[index].getStatementExecutionPlanText(1);
            }
        }
        return subqueryInfo + this.topResultSetStatistics.getStatementExecutionPlanText(0);
    }

    public String getScanStatisticsText() {
        return this.topResultSetStatistics == null ? (String)null : this.topResultSetStatistics.getScanStatisticsText(null, 0);
    }

    public String getScanStatisticsText(String tableName) {
        if (this.topResultSetStatistics == null) {
            return null;
        }
        String s = this.topResultSetStatistics.getScanStatisticsText(tableName, 0);
        return s.equals("") ? null : s;
    }

    public String toString() {
        String spstext = this.spsName != null ? "Stored Prepared Statement Name: \n\t" + this.spsName + "\n" : "";
        return spstext + MessageService.getTextMessage("43Y22.U") + ": \n\t" + this.statementName + "\n" + MessageService.getTextMessage("43Y23.U") + ": \n\t" + this.statementText + "\n" + MessageService.getTextMessage("43Y24.U") + ": " + this.parseTime + "\n" + MessageService.getTextMessage("43Y25.U") + ": " + this.bindTime + "\n" + MessageService.getTextMessage("43Y26.U") + ": " + this.optimizeTime + "\n" + MessageService.getTextMessage("43Y27.U") + ": " + this.generateTime + "\n" + MessageService.getTextMessage("43Y28.U") + ": " + this.compileTime + "\n" + MessageService.getTextMessage("43Y29.U") + ": " + this.executeTime + "\n" + MessageService.getTextMessage("43Y30.U") + " : " + this.beginCompilationTimestamp + "\n" + MessageService.getTextMessage("43Y31.U") + " : " + this.endCompilationTimestamp + "\n" + MessageService.getTextMessage("43Y32.U") + " : " + this.beginExecutionTimestamp + "\n" + MessageService.getTextMessage("43Y33.U") + " : " + this.endExecutionTimestamp + "\n" + MessageService.getTextMessage("43Y44.U") + ": \n" + this.getStatementExecutionPlanText();
    }

    public Vector getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.topResultSetStatistics);
        return children;
    }
}

