/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.io;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.eclipse.smila.taskmanager.BulkInfo;

public abstract class IODataObject {
    protected final ObjectStoreService _objectStore;
    private final BulkInfo _dataObject;
    private long _durationOpen;
    private long _durationPerform;

    public IODataObject(BulkInfo dataObject, ObjectStoreService objectStore) {
        this._dataObject = dataObject;
        this._objectStore = objectStore;
    }

    public BulkInfo getDataObject() {
        return this._dataObject;
    }

    public String getStoreName() {
        return this.getDataObject().getStoreName();
    }

    public String getObjectName() {
        return this.getDataObject().getObjectName();
    }

    public ObjectStoreService getObjectStore() {
        return this._objectStore;
    }

    protected void ensureStore() throws ObjectStoreException {
        ObjectStoreRetryUtil.retryEnsureStore((ObjectStoreService)this.getObjectStore(), (String)this.getStoreName());
    }

    public Map<String, Number> getCounter() {
        HashMap<String, Number> counter = new HashMap<String, Number>();
        counter.put("dataObjectCount", 1);
        return counter;
    }

    public long getDurationOpen() {
        return this._durationOpen;
    }

    public long getDurationPerform() {
        return this._durationPerform;
    }

    protected long startTime() {
        return System.nanoTime();
    }

    protected void timeOpen(long startTime) {
        this._durationOpen += System.nanoTime() - startTime;
    }

    protected void timePerform(long startTime) {
        this._durationPerform += System.nanoTime() - startTime;
    }
}

